/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"

long moss_logchk(user, iocbs)
char            **user;
struct cbstruct  *iocbs;
{
    char	**pkey = NULLVP;
    char	 *pwfile = NULLCP,
                 *pu = NULLCP,
                 *cp = NULLCP;
    long	  ret = -1L;
    int		  rfd = -1,
                  found = 0;
    struct bbuf  *t_pw = NULLBB,
                 *t_pkey = NULLBB,
                 *t_disp = NULLBB;

    if (iocbs == NULL_IOCBS)
	return -1L;

    if (user != NULLVP && (pkey = tag_user(user, "public-key")) == NULLVP) {
	cp2cb(iocbs->out_errs, "Missing public key for user.\n");
	goto cleanup;
    }

    if (user != NULLVP)
	pu = pretty_user(user);

    pwfile = pw_file();

    if (filchk(pwfile, -1, 0) != OK) {
	if (user == NULLVP) 
	    cp2cb(iocbs->out_user,
		  "Not explicitly logged in under any user.\n");
	else {
	    cp = add2cp(cp, pu);
	    /* check to see if private key is even password protected */
	    if (get_key(user, NULLBB, (struct bbuf **)0) != OK)  
		cp = add2cp(cp, " is not logged in.\n");
	    else {
		cp = add2cp(cp, " private key is not password protected.\n");
		ret = 0;
	    }
	    cp2cb(iocbs->out_errs, cp);
	    FREE(cp);
	}
	goto cleanup;
    }

    if ((rfd = open(pwfile, O_RDONLY)) < 0) {
	cp2cb(iocbs->out_errs, "Unable to open login status file.\n");
	goto cleanup;
    }
    if (fdchk(rfd, 0600) != OK) {
	cp2cb(iocbs->out_errs,"Bad owner/permissions on login status file.\n");
        goto cleanup;
    }

    while (read_pwrec(rfd, &t_pw, &t_pkey, &t_disp) == OK) {
	if (user == NULLVP || !strcmp(*(pkey+1), (char *)(t_pkey->data))) {
	    found = 1;
	    cp = add2cp(cp, (char *)t_disp->data);
	    cp = add2cp(cp, " logged in.\n");
	    cp2cb(iocbs->out_user, cp);
	    FREE(cp);
	}
    }
    
    if (!found) {
	if (user == NULLVP) 
           cp2cb(iocbs->out_user,
                  "Not explicitly logged in under any user.\n");
	else {
	    /* check to see if private key is even password protected */
	    cp = add2cp(cp, pu);
	    if (get_key(user, NULLBB, (struct bbuf **)0) != OK) {
		cp = add2cp(cp, " is not logged in.\n");
		cp2cb(iocbs->out_user, cp);
		FREE(cp);
		goto cleanup;
	    }
	    cp = add2cp(cp, " private key is not password protected.\n");
	    cp2cb(iocbs->out_user, cp);
	    FREE(cp);
	}
    }

    ret = 0;

 cleanup:

    FREE(pwfile);
    FREE(pu);
    FREE_BBUF(t_pw);
    FREE_BBUF(t_pkey);
    FREE_BBUF(t_disp);

    if (rfd != -1)
	(void) close(rfd);

    return(ret);
}
