/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"

moss_login(user, iocbs)
char            **user;
struct cbstruct  *iocbs;
{
    char            *pwfile = NULLCP,
                    *pu = NULLCP,
                    *cp = NULLCP,
                   **pkey;
    int              ret = NOTOK,
                     rfd = -1,
                     wfd = -1,
                     found = 0;
    struct bbuf     *pw = NULLBB,
                    *t_pw = NULLBB,
                    *t_pkey = NULLBB,
                    *t_disp = NULLBB;

    if (iocbs == NULL_IOCBS)
	return NOTOK;

    /* we only want to set a login record if the user has a password on the
     * private key, so we need to check for this first.  we assume that if
     * a user is already logged in then the private key has a password and
     * we just update the login record with a new expiration time.
     */

    /* get the public key */

    if ((pkey = tag_user(user, "public-key")) == NULLVP) {
	cp2cb(iocbs->out_errs, "missing public-key for user\n");
	goto cleanup;
    }

    /* And the pretty text to display */

    pu = pretty_user(user);

    /* set the password file */

    pwfile = pw_file();

    /* Check, open, and unlink the old password file */

    if (filchk(pwfile, -1, 0) == OK) {
	if ((rfd = open(pwfile, O_RDONLY)) < 0) {
	    cp2cb(iocbs->out_errs,
		  "Unable to read login status file.\n");
	    goto cleanup;
	}
	if (fdchk(rfd, 0600) != OK) {
	    cp2cb(iocbs->out_errs, 
		  "Bad owner/permission on login status file.\n");
	    goto cleanup;
	}
	if (unlink(pwfile)) {
	    cp2cb(iocbs->out_errs,
                  "Unable to unlink old login status file.\n");
            goto cleanup;
	}
    }

    /* Create new password file */

    if (filchk(pwfile, 0600, 1) != OK) {
	cp2cb(iocbs->out_errs,
                  "Unable to create login status file.\n");
	goto cleanup;
    }
    if ((wfd = lk_open(pwfile, O_WRONLY)) < 0) {
        cp2cb(iocbs->out_errs,
                  "Unable to write login status file.\n");
        goto cleanup;
    }
    if (fdchk(wfd, 0600) != OK) {
	cp2cb(iocbs->out_errs,
	      "Bad owner/permission on login status file.\n");
	goto cleanup;
    }

    /* Process old records */

    if (rfd != -1)
	while (read_pwrec(rfd, &t_pw, &t_pkey, &t_disp) == OK) {
	    (void) write_pwrec(wfd, t_pw, t_pkey, t_disp);
	    if (!strcmp(*(pkey+1), (char *)t_pkey->data)) 
		found = 1;
	}

    /* Process new rcord */

    if (!found) {

	/* to login we must have access to the private key to login */

	if (get_key(user, pw, (struct bbuf **)0) == OK) {
	    cp = add2cp(cp, "Private key for ");
	    cp = add2cp(cp, pu);
	    cp = add2cp(cp, " is not protected; login not required.\n");
	    cp2cb(iocbs->out_user, cp);
	    FREE(cp);
	    return OK;      /* no login record in this case */
	}

    pwagain: 	
	switch (get_key(user, pw, (struct bbuf **)0)) {

	case OK: 	 
	    break; 	 	

	case EINVAL: 	
	    FREE_BBUF(pw);
	    cp = add2cp(cp, "Private key for ");
	    cp = add2cp(cp, pu);
	    cp = add2cp(cp, " is password protected.\n");
	    cp2cb(iocbs->out_user, cp);
	    FREE(cp);
	    if ((pw = get_password(iocbs, 0)) == NULLBB) {
		cp = add2cp(cp, "Login for ");
		cp = add2cp(cp, pu);
		cp = add2cp(cp, " denied; password required.\n");
 		cp2cb(iocbs->out_errs, cp);
		FREE(cp);
 		return NOTOK; 	 
	    } 	 
	    goto pwagain;

	default:
	    cp = add2cp(cp, "Login for ");
	    cp = add2cp(cp, pu);
	    cp = add2cp(cp, " denied; unable to access private key.\n");
	    cp2cb(iocbs->out_errs, cp);
	    FREE(cp);
	    return NOTOK;
	}

	t_pkey = alloc_bbuf();
	t_pkey->length = strlen(*(pkey+1));
	t_pkey->data = (unsigned char *)*(pkey+1);
	t_disp = alloc_bbuf();
	t_disp->length = strlen(pu);
	t_disp->data = (unsigned char *)pu;
	        (void) write_pwrec(wfd, pw, t_pkey, t_disp);
	t_pkey->data = NULLUCP;
	t_disp->data = NULLUCP;
    }

    cp = add2cp(cp, "Login for ");
    cp = add2cp(cp, pu);
    cp = add2cp(cp, " successful.\n");
    cp2cb(iocbs->out_user, cp);
    FREE(cp);

    ret = OK;

 cleanup:

    FREE(pwfile);
    FREE(pu);
    FREE_BBUF(pw);
    FREE_BBUF(t_pw);
    FREE_BBUF(t_pkey);
    FREE_BBUF(t_disp);

    if (rfd != -1)
	(void) close(rfd);

    if (wfd != -1)
	(void) lk_close(wfd);

    return(ret);
}
