/* This is the Lex definition for MOSS messages */

%{

#include "config.h"

#include "y.tab.h"

#define  INITIAL 0

int lexdebug= 0;
int yydebug= 0;

%}

%s HEADERS

vBLANKLINE	^\n
vVRSION		^"Version:"[ ]*
vDEKINFO	^"DEK-Info:"[ ]*
vKEYINFO	^"Key-Info:"[ ]*
vORIGID		^"Originator-ID:"[ ]*
vRECIPID	^"Recipient-ID:"[ ]*
vMICINFO	^"MIC-Info:"[ ]*
vHSKIP		 ","[ ]*
vID_EN		 "EN"[ ]*
vID_STR		 "STR"[ ]*
vID_DN		 "DN"[ ]*
vID_PK		 "PK"[ ]*
vID_IS		 "IS"[ ]*

%%

<INITIAL>{vVRSION}		{ BEGIN HEADERS;
				  if (lexdebug) fprintf(yyout,"\nVERSION:");
				  return VRSION; }

<HEADERS>{vHSKIP}		;

<HEADERS>{vBLANKLINE}		{ BEGIN INITIAL; 
				  if (lexdebug) fprintf(yyout,"\nBLANKLINE\n");
				  return BLANKLINE; } 

<HEADERS>{vDEKINFO}		{ if (lexdebug) fprintf(yyout,"\n\nDEKINFO:");
				  return DEKINFO; }

<HEADERS>{vKEYINFO}		{ if (lexdebug) fprintf(yyout,"\n\nKEYINFO:");
				  return KEYINFO; }

<HEADERS>{vORIGID}		{ if (lexdebug) fprintf(yyout,"\n\nORIGID:");
				  return ORIGID; }

<HEADERS>{vRECIPID}		{ if (lexdebug) fprintf(yyout,"\n\nRECIPID:");
				  return RECIPID; }

<HEADERS>{vMICINFO}		{ if (lexdebug) fprintf(yyout,"\n\nMICINFO:");
				  return MICINFO; }

<HEADERS>{vID_EN}		{ if (lexdebug) fprintf(yyout,"\nEN:");
				  strcpy(yylval.str, yytext);
				  return ID_EN; }

<HEADERS>{vID_STR}		{ if (lexdebug) fprintf(yyout,"\nSTR:");
				  strcpy(yylval.str, yytext);
				  return ID_STR; }

<HEADERS>{vID_DN}		{ if (lexdebug) fprintf(yyout,"\nDN:");
				  strcpy(yylval.str, yytext);
				  return ID_DN; }

<HEADERS>{vID_PK}		{ if (lexdebug) fprintf(yyout,"\nPK:");
				  strcpy(yylval.str, yytext);
				  return ID_PK; }

<HEADERS>{vID_IS}		{ if (lexdebug) fprintf(yyout,"\nIS:");
				  strcpy(yylval.str, yytext);
				  return ID_IS; }

<HEADERS>[^:,\n]+		{
				  strcpy(yylval.str, yytext);
				  if (lexdebug) 
				    fprintf(yyout,"\nHSTR: %s",yytext);
				  return HSTR; }

\n				;

%%
