/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "util.h"

struct bbuf *hex2bin(hex)
char *hex;
{
    unsigned char *cp;
    int i = 0, j = 0, len;
    struct bbuf *bin = NULLBB;

    if (hex == NULLCP) 
	return(NULLBB);

    if ((len = strlen(hex)) & 0x01)
	cp = alloc_uchar((len + 1) / 2);
    else
	cp = alloc_uchar(len / 2);

    if (strncasecmp(hex, "0x", 2) == 0) {
	hex += 2;
	len -= 2;
    }

    if (len & 0x01) {
	cp[j] = (cp2i(hex, 1, 16) & 0xFF);
	i = j = 1;
    }

    for ( ; i < len; i += 2, j++) 
	cp[j] = (cp2i(&hex[i], 2, 16) & 0xFF);

    bin = alloc_bbuf();
    bin->data = cp;
    bin->length = j;

    return(bin);
}
