.TH mossrc 5 "March 1995"  "7.1" "TIS/MOSS"
.SH NAME
mossrc \- tailor file for TIS/MOSS
.SH SYNOPSIS
.SH DESCRIPTION
The optional
.B .mossrc
file allows you to tailor TIS/MOSS to your personal liking.  The 
.B .mossrc
file consists of colon-separated tag/value pairs.  Tags are
case-insensitive while the case sensitivity of their values is
context-specific.  Following are the tailorable values and their
defaults:
.PP
.B database:.mossdb
.br
The name of the file containing the TIS/MOSS database.  If it does not
contain a rooted pathname, the value of
.B directory
(below) is prepended.
.PP
.B directory:
.br
The name of the directory that should be prepended to file names if they
are not rooted.  The default value of nothing translates to the
contents of the 
.B HOME
environment variable.  If 
.B directory contains a name that is not rooted, the contents of the
.B HOME
environment variable, which should be rooted, will be prepended.
.PP
.B moreproc:more
.br
Default pager.
.PP
.B pwdir:/tmp
.br
Directory in which to place login state files.
.PP
.B randproc:prandom.sh
.br
Name of program used to produce unpredictable output to seed the
pseudorandom number generator when generating key pairs.  Do not
change this without due consideration.
.PP
.B tmpdir:/tmp
.br
Rooted name of directory in which to put temporary files.
.PP
.B my-alias:me
.br
Alias that identifies user records as yours.  Used when decrypting
MOSS messages to determine if you are a recipient.
.PP
.B sig-alias:sig-user
.br
Alias that identifies the user record to use when creating signatures.
.PP
.B encrypt-alias:me
.br
Encrypt for user records with designated alias as well as those specified
on the command line if 
.B metoo
(below) is
.B yes.
.PP
.B metoo:yes
.br
Determines whether or not the user records with the alias associated with
.B encrypt-alias
are included as recipients in addition to any provided on the command line.
.PP
.B show-key:no
.br
Show the value of the data encryption key (DEK) when decrypting messages.
.PP
.B show-recips:no
.br
Show the list of recipients for encrypted messages.
.PP
The following are the various tailorable cryptographic values:
.PP
.B dek-alg:DES_CBC
.br
.B hash-alg:MD5
.br
.B key-alg:RSA_PUBF4
.br
.B key-len:512
.br
.B mic-alg:MD5
.br
.B sig-alg:MD2_RSA
.PP
The following are the various tailorable time periods, all of which 
are measured in seconds by default, but can have the letters 
.B h, d, m, 
or
.B y
appended to signify hours, days, months, and years, respectively:
.br
.B cert-period:2y
.br
.B crl-period:14d
.PP
All of the tailorable values can also be included on the command line
of TIS/MOSS commands, overriding the coded defaults and values in the 
.B .mossrc 
file, by separating the tags and values with spaces. 
.PP
A file other than 
.B .mossrc
can be used to tailor TIS/MOSS by setting the environment variable
.B MOSSRC
to the name of the file to use.  If the file name is not fully 
qualified, it is assumed to be rooted at your home directory as 
stored in the 
.B HOME 
environment variable.

.SH FILES
$HOME/.mossrc
.SH SEE ALSO
moss(1)
.SH BUGS
