/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"

static int inputfd = 0;         /* standard input */
static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

static int user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd, bb));
}

static struct bbuf *user_in()
{
    return(cbfdread(inputfd));
}

static struct bbuf *user_ne()
{
    return(cbfdneread(inputfd));
}

static int error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd, bb));
}

main(argc, argv)
int argc;
char **argv;
{
    char            **user = NULLVP,
                    **nuser = NULLVP;
    struct cbstruct   iocbs;

    if (pem_init(argc, argv, &user) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", *argv);
	exit(1);
    }

    if (argc < 5 || !strcmp(argv[1], "help")) {
        (void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
        (void) fprintf(stderr, "Usage: %s %s\nor\n       %s %s\n       %s\n",
		       myname,
		       "private-key-access <access> private-key <data>",
		       myname,
		       "private-key-access <access> private-key <data>",
		       "serial-number <hex> subject-name <dname>");
	exit(1);
    }

    if (tag_user(user, "serial-number") != NULLVP)
	if (tag_user(user, "subject-name") == NULLVP) {
	    (void) fprintf(stderr,
			   "%s: missing subject-name for serial-number\n",
			   myname);
	    exit(1);
	}

    if (tag_user(user, "private-key-access") == NULLVP
	|| tag_user(user, "private-key") == NULLVP) {
	(void) fprintf(stderr,
		       "%s: missing private-key or private-key-access\n",
		       myname);
	exit(1);
    }

    /* set up callbacks for pem_key */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.out_errs = error_out;
    iocbs.out_user = user_out;
    iocbs.in_user = user_in;
    iocbs.ne_user = user_ne;

    if ((nuser = pem_key(user, &iocbs)) == NULLVP) {
	(void) fprintf(stderr, "%s: unable to create public/private keys\n",
		       myname);
	exit(1);
    }

    if (update_indexfile(NULLVP, nuser) != OK) {
	(void) fprintf(stderr, "%s: unable to update database with\n", myname);
	user = NULLVP;
	(void) disp_user(nuser, &user);
	while (*user != NULLCP)
	    (void) fprintf(stderr, "%s\n", *user++);
	exit(1);
    }

    exit(0);
}
