/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#ifndef	_INIT_
#define _INIT_

#include "bbuf.h"
#include "general.h"

int          cpyright = 0;	   /* display copyright only once */

char	    *myname = NULLCP;	   /* execution name (argv[0]) */

char         errmsg[256];	   /* storage for last error message */

struct bbuf *seedbb = NULLBB;	   /* PRNG seed variable; must be global so
				    * routines outside crypto can initialize */

int          cert_version = 0;	   /* certificate version; do NOT change */

char       **user_tailor = NULLVP; /* user's defaults from tailor file */


/* these are the standard default tailor values
 *
 * format is tag/value pairs just like user record
 */
static char *default_tailor[] = {

    "database",     ".pemdb",	  /* default database */
    "directory",    "",           /* default directory.  "" -> $HOME */
    "moreproc",     "more",	  /* default pager */
    "pwdir",        "/tmp",	  /* directory for login state file */
    "randproc",     "prandom.sh", /* initialize random number generator */
    "tmpdir",       "/tmp",	  /* location for temporary files */

    "my-alias",     "me",         /* alias name indicating my user records */
    "sig-alias",    "sig-user",   /* default alias for generating signatures */

    "encrypt-alias","me",         /* default alias for encryption if metoo */
    "metoo",        "yes",        /* also encrypt for encrypt-alias? */

    "show-key",     "no",         /* should we show the dek? */
    "show-recips",  "no",         /* should we show all recipients? */

    "dek-alg",      "DES_CBC",	  /* message DEK algorithm */
    "hash-alg",     "MD5",	  /* general purpose hash algorithm */
    "key-alg",      "RSA_PUBF4",  /* public key algorithm */
    "key-len",      "512",	  /* key size (in bits) */
    "mic-alg",      "MD5",	  /* message MIC algorithm */
    "sig-alg",      "MD2_RSA",	  /* certificate/CRL signature algorithm */

    "cert-period",  "2y",	  /* certificate validity period */
    "crl-period",   "14d",	  /* CRL period before next update */

    NULLCP
};

/* now we define all the data structures requiring initialization */

#define	DEFINE_DATA

#include "dname.h"
#include "x500.h"

#undef	DEFINE_DATA

#endif	/* not _INIT_ */
