/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#ifndef	_X500_
#define	_X500_

#include "asn1.h"


/* useful generic structure */

struct strval {
    char *str;
    unsigned short val;
};

extern unsigned short	strlookup(), strilookup();
extern char		*vallookup();


#define PARSE_ERROR		0x00

/* Define mnemonics for asn attribute types */
#define COMMONNAME		1
#define ORGUNITNAME		2
#define ORGNAME			3
#define STATEORPROVINCE		4
#define COUNTRYNAME		5
#define STREETADDRESS		6
#define POSTALCODE		7
#define EMAILNAME		8   /* Other defined attribute type */
#define POSTALADDRESS		9
#define POSTOFFICEBOX		10
#define SURNAME			11
#define SERIALNUMBER		12
#define LOCALITYNAME		13
#define TITLE			14
#define DESCRIPTION		15
#define SEARCHGUIDE		16
#define BUSINESSCATEGORY	17
#define DELIVERYOFFICENAME	18
#define PHONENUMBER		19
#define TELEXNUMBER		20
#define TELEXTERMINALID		21
#define FAXPHONENUMBER		22
#define X121ADDRESS		23
#define ISDNNUMBER		24
#define REGISTEREDADDRESS	25
#define DESTINATIONINDICATOR	26
#define DELIVERYMETHOD		27
#define PRESENTATIONADDRESS	28
#define APPLICATIONCONTEXT	29
#define MEMBER			30
#define OWNER			31
#define ROLEOCCUPANT		32
#define SEEALSO			33
#define USERPASSWORD		34
#define USERCERTIFICATE		35
#define CACERTIFICATE		36
#define AUTHREVOCATIONLIST	37
#define CERTREVOCATIONLIST	38
#define CROSSCERTIFICATEPAIR	39

/* Define mnemonics for asn attribute syntaxes */
#define DistinguishedName	1
#define ObjectIdentifier	2
#define CaseExactString		3
#define CaseIgnoreString	4
#define PrintableString		5
#define NumericString		6
#define CaseIgnoreList		7
#define Boolean			8
#define Integer			9
#define OctetString		10
#define UTCTime			11
#define PhoneNumber		12

/* Although all attributes are defined above, only those attributes
   that need be supported for distinguished names are assigned below.
   If there is a need for support of additional attribute types, an 
   entry must be created in each of the following structures:

		label_attribute[]
		oidstr_attributes[]
		oidstr_syntax[]

   Further the defines for MaxDNAttribute and MAX_LABEL_LEN should
   be updated if applicable to ensure proper distinguished name
   manipulation.
*/

#define MaxDNAttribute		EMAILNAME

/* Define the length of the longest label for display purposes */
#define MAX_LABEL_LEN		26

#ifndef	DEFINE_DATA
extern struct strval label_attribute[1];
#else	/* DEFINE_DATA */
struct strval label_attribute[] = {

    /* These attributes currently allowed by RFC 1421 */

    "Common Name",			COMMONNAME,
    "CN",				COMMONNAME,
    "Country Name",			COUNTRYNAME,
    "C",				COUNTRYNAME,
    "Locality Name",			LOCALITYNAME,
    "L",				LOCALITYNAME,
    "State or Province Name",		STATEORPROVINCE,
    "ST",				STATEORPROVINCE,
    "Street Address",			STREETADDRESS,
    "SA",				STREETADDRESS,
    "Organization Name",		ORGNAME,
    "O",				ORGNAME,
    "Organizational Unit Name",		ORGUNITNAME,
    "OU",				ORGUNITNAME,

    /* Additional attributes outside RFC 1421 */
    "Email Name",			EMAILNAME,
    "EN",				EMAILNAME,

    "Post Office Box",			POSTOFFICEBOX,
    "PO Box",				POSTOFFICEBOX,
    "Postal Code",			POSTALCODE,
    "PC",				POSTALCODE,

    /* These attributes currently *not* displayed for input
     * by TIS/PEM

    "Title",				TITLE,
    "T",				TITLE,
    "Description",			DESCRIPTION,
    "D",				DESCRIPTION,
    "Postal Address",			POSTALADDRESS,
    "PA",				POSTALADDRESS,
    "Telephone Number",			PHONENUMBER,
    "TN",				PHONENUMBER,
    "Telex Number",			TELEXNUMBER,
    "Telex",				TELEXNUMBER,
    "Telex Terminal Identifier",	TELEXTERMINALID,
    "Telex TID",			TELEXTERMINALID,
    "Surname",				SURNAME,
    "S",				SURNAME,
    "Serial Number",			SERIALNUMBER,
    "SN",				SERIALNUMBER,
    "Facsimile Telephone Number",	FAXPHONENUMBER,
    "Fax",				FAXPHONENUMBER,

     */

    NULLCP, 0                   /* ZERO is used here */
};
#endif	/* not DEFINE_DATA */

#define MAX_OIDSTR_LEN		8
#ifndef	DEFINE_DATA
extern struct strval oidstr_attribute[1];
#else	/* DEFINE_DATA */
struct strval oidstr_attribute[] = {
    "2.5.4.3",                          COMMONNAME,
    "2.5.4.4",                          SURNAME,
    "2.5.4.5",                          SERIALNUMBER,
    "2.5.4.6",                          COUNTRYNAME,
    "2.5.4.7",                          LOCALITYNAME,
    "2.5.4.8",                          STATEORPROVINCE,
    "2.5.4.9",                          STREETADDRESS,
    "2.5.4.10",                         ORGNAME,
    "2.5.4.11",                         ORGUNITNAME,
    "2.5.4.12",                         TITLE,
    "2.5.4.13",                         DESCRIPTION,
    "2.5.4.16",                         POSTALADDRESS,
    "2.5.4.17",                         POSTALCODE,
    "2.5.4.18",                         POSTOFFICEBOX,
    "2.5.4.20",                         PHONENUMBER,
    "2.5.4.21",                         TELEXNUMBER,
    "2.5.4.22",                         TELEXTERMINALID,
    "2.5.4.23",                         FAXPHONENUMBER,

    "1.3.6.1.4.1.602.1.1",		EMAILNAME,

    NULLCP, 0                   /* ZERO is used here */
};
#endif	/* not DEFINE_DATA */

#ifndef	DEFINE_DATA
extern struct strval oidstr_syntax[1];
#else	/* DEFINE_DATA */
struct strval oidstr_syntax[] = {
    "2.5.4.3",				CaseIgnoreString,
    "2.5.4.4",				CaseIgnoreString,
    "2.5.4.5",				PrintableString,
    "2.5.4.6",				PrintableString,
    "2.5.4.7",				CaseIgnoreString,
    "2.5.4.8",				CaseIgnoreString,
    "2.5.4.9",				CaseIgnoreString,
    "2.5.4.10",				CaseIgnoreString,
    "2.5.4.11",				CaseIgnoreString,
    "2.5.4.12",				CaseIgnoreString,
    "2.5.4.13",				CaseIgnoreString,
    "2.5.4.16",				PrintableString,
    "2.5.4.17",				CaseIgnoreString,
    "2.5.4.18",				CaseIgnoreString,
    "2.5.4.20",				PhoneNumber,
    "2.5.4.21",				PrintableString,
    "2.5.4.22",				PrintableString,
    "2.5.4.23",				PhoneNumber,

    "1.3.6.1.4.1.602.1.1",		CaseIgnoreString,

    NULLCP, 0                   /* ZERO is used here */
};
#endif	/* not DEFINE_DATA */

/* We need character set designators to resolve
   potential ambiguity for string valued attributes */
#define PRS		DEFN_PRTS
#define T61S		DEFN_T61S

#ifndef	DEFINE_DATA
extern struct strval label_charset[1];
#else	/* DEFINE_DATA */
struct strval label_charset[] = {
    "PRS",			DEFN_PRTS,
    "T61",			DEFN_T61S,
    NULLCP, 0                   /* ZERO is used here */
};
#endif	/* not DEFINE_DATA */

unsigned char		asn_extract();

#endif	/* not _X500_ */
