/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

decode_utct(eutct, dutct, rlength)
struct bbuf *eutct;
long *dutct;
int *rlength;
{
    struct bbuf *bb = NULLBB;
    UTC ut;
    struct tm *tm;
    int r;
	
    if (eutct == NULLBB) {
	return(NOTOK);
    }
    if (dutct == (long *)0) {
	return(NOTOK);
    }
    if (rlength == (int *)0) {
	return(NOTOK);
    }

    r = decode_str(eutct, (CLASS_UNIV|FORM_PRIM|DEFN_UTCT), &bb, rlength);
    if (r != OK)
	return(r);
    if (bb == NULLBB || !bb->length) {
	*dutct = -1;
	return(r);
    }

    ut = str2utct((char *)bb->data, bb->length);
    tm = ut2tm(ut);
    *dutct = gtime(tm);

    (void) free_bbuf(bb);

    return(OK);
}
