/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"

#include <stdio.h>

#include "general.h"

#include "allocate.h"
#include "asn1.h"
#include "bbuf.h"
#include "oid.h"
#include "util.h"

struct bbuf *oid2prim(o)
OID	o;
{
    int i, m, n, *mp, *np;
    unsigned long j, *ip;
    unsigned char *dp, *ep;
    struct bbuf *bb;

    if (o == NULLOID || o -> oid_nelem <= 1)
	return(NULLBB);

    bb = alloc_bbuf();

    allocate(&np, int, (o->oid_nelem) * sizeof *np);
    if (np == (int *)0) {
	(void) free_bbuf(bb);
	return(NULLBB);
    }

    for (i = n = 0, ip = o -> oid_elements, mp = np;
	 i < o -> oid_nelem;
	 i++, ip++) {
	if (ip == o -> oid_elements)
	    j = *ip++ * 40, i++, j+= *ip;
	else
	    j = *ip;
	m = 0;
	do {
	    m++;
	    j >>= 7;
	}
	while (j);
	n += (*mp++ = m);
    }

    bb->data = alloc_uchar(n);
    bb->length = (int)n;

    dp = bb->data;
    for (i = 0, ip = o -> oid_elements, mp = np;
	 i < o -> oid_nelem;
	 i++, ip++) {
	if (ip == o -> oid_elements)
	    j = *ip++ * 40, i++, j += *ip;
	else
	    j = *ip;

	ep = dp + (m = *mp++) - 1;
	for (dp = ep; m-- > 0; j >>= 7)
	    *dp-- = (unsigned char)((j & 0x7f) | 0x80);
	*ep &= ~0x80;
	dp = ep + 1;
    }

    free ((char *) np);

    return(bb);
}
