/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "util.h"

struct bbuf *get_password(iocbs, verify)
struct cbstruct *iocbs;
int verify;
{
    struct bbuf *ret = NULLBB;

    /* prompt the user for private key password if we can */

    if (iocbs->out_user != NULL_OUTCB && iocbs->ne_user != NULL_INCB) {
	struct bbuf *passverify = NULLBB,
                    *pass = NULLBB;
	int attempts = 0;

	do {
	    FREE_BBUF(pass);
	    FREE_BBUF(passverify);

	    if (attempts)
		cp2cb(iocbs->out_user, "Password mis-match!\n");

	    if (++attempts > MAXPWTRIES) {
		cp2cb(iocbs->out_user, "Maximum retries exceeded!\n");
		goto cleanup;
	    }

	    cp2cb(iocbs->out_user,
		  "\nEnter password for private key (or RETURN for none): ");
	    pass = iocbs->ne_user();
	    cp2cb(iocbs->out_user, "\n");
	    if (pass == NULLBB || pass->data == NULLUCP
		|| *((char *)pass->data) == '\n') {
		FREE_BBUF(pass);
		break;
	    }

	    if (verify) {
		cp2cb(iocbs->out_user, "Re-enter password to verify: ");
		passverify = iocbs->ne_user();
		cp2cb(iocbs->out_user, "\n");
	    }

	} while (verify && bbufcmp(pass, passverify) != 0);

	ret = pass;
	FREE_BBUF(passverify);
    }

 cleanup:

    /* make sure password data is NULL terminated */
    if (ret != NULLBB) {
	unsigned char *ucp;

	ucp = alloc_uchar(ret->length + 1);
	BCOPY(ret->data, ucp, ret->length);
	ucp[ret->length += 1] = NULLC;
	FREE_UCHAR(ret->data);
	ret->data = ucp;
    }

    return ret;
}
