/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "cert.h"
#include "bbuf.h"
#include "util.h"

static int _encode_valid();

int encode_cert(dcert, ecert)
struct certificate *dcert;
struct bbuf **ecert;
{
    struct bbuf *bb = NULLBB;
    struct bbuf *bb2 = NULLBB;
    struct bbuf *bb3 = NULLBB;
    int r = OK;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (dcert == NULL_CERT) {
	return(NOTOK);
    }
    if (ecert == (struct bbuf **)0) {
	return(NOTOK);
    }
    FREE_BBUFS(*ecert);

    /* ENCODE TOBESIGNED */
    if ((r = encode_ctbs(dcert->tobesigned, &bb2)) != OK)
        goto cleanup;

    /* ENCODE THE SIGNATURE ALGORITHM IDENTIFIER  & APPEND */
    if ((r = encode_algid(dcert->sig_alg, &bb)) != OK)
        goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE SIGNATURE & APPEND */
    if ((r = encode_bits(dcert->sig, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE LENGTH & PREPEND */
    if ((r = encode_len(bb2->length, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* PREPEND THE TAG */
    if ((r = encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
        goto cleanup;
    *ecert = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    (*ecert)->status = dcert->status;

    r = OK;

 cleanup:

    if (r != OK)
	FREE_BBUF(*ecert);

    FREE_BBUF(bb2);

    return(r);
}


int encode_ctbs(dtbs,etbs)
struct tobesigned *dtbs;
struct bbuf **etbs;
{
    int r;
    struct bbuf *bb = NULLBB;
    struct bbuf *bb2 = NULLBB;
    struct bbuf *bb3 = NULLBB;

    /* CHECK OUTPUT PARAMETERS */
    if (etbs == (struct bbuf **)0) {
	return(NOTOK);
    }
    FREE_BBUF(*etbs);

    /* ENCODE MISSING TOBESIGNED AS A NULL */
    if (dtbs == NULL_TOBESIGNED) {
	r = encode_null(CLASS_UNIV|FORM_CONS|CONS_SEQ, etbs);
	return(r);
    }

    /* ENCODE VERSION ONLY IF NOT DEFAULT */
    if (dtbs->version != VERSION_DEFAULT_1988) {
	return(NOTOK);
    }

    /* ENCODE SERIAL NUMBER */
    if ((r = encode_ints(dtbs->serial, &bb2)) != OK)
        goto cleanup;

    /* ENCODE THE SIGNATURE ALGORITHM IDENTIFIER */
    if ((r = encode_algid(dtbs->sig_alg, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* APPEND ENCODED ISSUER DNAME */
    if (dtbs->issuer != NULLBB) {
        if ((bb = dup_bbuf(dtbs->issuer)) == NULLBB) {
            r = NOTOK;
            goto cleanup;
        }
    }
    else {
        if ((r = encode_null(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
            goto cleanup;
    }
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE VALIDITY PERIOD & APPEND */
    if ((r = _encode_valid(dtbs->valid, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* APPEND ENCODED SUBJECT DNAME */
    if (dtbs->subject != NULLBB) {
	if ((bb = dup_bbuf(dtbs->subject)) == NULLBB) {
	    r = NOTOK;
	    goto cleanup;
	}
    }
    else {
	if ((r = encode_null(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
            goto cleanup;
    }
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* APPEND ENCODED PUBLIC KEY */
    if (dtbs->public != NULLBB) {
	if ((bb = dup_bbuf(dtbs->public)) == NULLBB) {
	    r = NOTOK;
	    goto cleanup;
	}
    }
    else {
	if ((r = encode_null(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
            goto cleanup;
    }
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE LENGTH & PREPEND */
    if ((r = encode_len(bb2->length, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* PREPEND THE TAG */
    if ((r = encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
        goto cleanup;
    *etbs = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    r = OK;

 cleanup:

    if (r != OK)
	FREE_BBUF(*etbs);

    FREE_BBUF(bb2);
    
    return(r);
}


static int _encode_valid(dval,eval)
struct valid *dval;
struct bbuf **eval;
{
    int r = OK;
    struct bbuf *bb = NULLBB;
    struct bbuf *bb2 = NULLBB;
    struct bbuf *bb3 = NULLBB;

    /* CHECK OUTPUT PARAMETERS */
    if (eval == (struct bbuf **)0) {
	return(NOTOK);
    }
    FREE_BBUF(*eval);

    /* ENCODE MISSING VALID AS A NULL */
    if (dval == NULL_VALID) {
	if ((r = encode_null(CLASS_UNIV|FORM_CONS|CONS_SEQ, eval)) != OK)
	    return(r);
	return(OK);
    }

    /* ENCODE NOTBEFORE */
    if ((r = encode_utct(dval->begin, &bb2)) != OK)
        goto cleanup;

    /* ENCODE NOTAFTER & APPEND */
    if ((r = encode_utct(dval->end, &bb)) != OK)
        goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE LENGTH & PREPEND */
    if ((r = encode_len(bb2->length, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* PREPEND THE TAG */
    if ((r = encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
        goto cleanup;
    *eval = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    r = OK;

 cleanup:

    FREE_BBUF(bb2);

    if (r != OK)
        FREE_BBUF(*eval);

    return(r);
}
