/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "cert.h"
#include "util.h"

sig_alg_cert(ecert, aid, loc, mode)
struct bbuf **ecert;
struct algid **aid;
int loc;
int mode;
{
    struct certificate *cert= NULL_CERT;

    if (ecert == (struct bbuf **)0) {
        return(NOTOK);
    }
    if (aid == (struct algid **)0) {
	return(NOTOK);
    }
    if ((loc & INNER) != INNER && (loc & OUTER) != OUTER) {
	return(NOTOK);
    }
    if (decode_cert(*ecert, &cert) != OK) {
        return(NOTOK);
    }

    switch (mode) {
    case READ:

	FREE_ALGID(*aid);

	if ((loc & INNER) == INNER && (loc & OUTER) == OUTER) {
	    return(NOTOK);
	}

	if ((loc & INNER) == INNER) {

	    if (cert->tobesigned == NULL_TOBESIGNED 
		&& (cert->tobesigned=alloc_tobesigned_cert()) 
		== NULL_TOBESIGNED) {
	        return(NOTOK);
	    }

	    if (cert->tobesigned->sig_alg == NULL_ALGID)
		break;

	    if ((*aid = dup_algid(cert->tobesigned->sig_alg)) == NULL_ALGID)
		return(NOTOK);

	} else {

	    if (cert->sig_alg == NULL_ALGID)
		break;

	    if ((*aid = dup_algid(cert->sig_alg)) == NULL_ALGID)
		return(NOTOK);

	}

	break;

    case WRITE:

	if ((loc & INNER) == INNER) {

	    if (cert->tobesigned == NULL_TOBESIGNED) {
	        if ((cert->tobesigned = alloc_tobesigned_cert())
		    == NULL_TOBESIGNED)
		    return(NOTOK);
	    }

	    FREE_ALGID(cert->tobesigned->sig_alg);

	    if (*aid == NULL_ALGID)
		break;

	    if ((cert->tobesigned->sig_alg = dup_algid(*aid)) == NULL_ALGID)
	        return(NOTOK);

	}

	if ((loc & OUTER) == OUTER) {

	    FREE_ALGID(cert->sig_alg);

	    if (*aid == NULL_ALGID)
		break;

	    if ((cert->sig_alg = dup_algid(*aid)) == NULL_ALGID)
	        return(NOTOK);

	}
        if (encode_cert(cert, ecert) != OK) {
            return(NOTOK);
        }

	break;

    default:
	return(NOTOK);
    }

    return(OK);
}
