/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cert.h"
#include "util.h"

sig_cert(ecert, sig, length, mode)
struct bbuf **ecert;
unsigned char **sig;
int *length;
int mode;
{
    struct certificate *cert= NULL_CERT;

    if (ecert == (struct bbuf **)0) {
        return(NOTOK);
    }

    if (sig == (unsigned char **)0) {
	return(NOTOK);
    }

    if (length == (int *)0) {
	return(NOTOK);
    }
    if (decode_cert(*ecert, &cert) != OK) {
        return(NOTOK);
    }


    switch (mode) {
    case READ:
	FREE_UCHAR(*sig);
	if (cert->sig == NULLBB || !cert->sig->length)
	    break;

	if ((*sig = alloc_uchar(cert->sig->length)) == (unsigned char *)0)
	    return(NOTOK);
	*length = cert->sig->length;
	BCOPY((char *)cert->sig->data, (char *)*sig, *length);
	break;

    case WRITE:
	FREE_BBUF(cert->sig);

	if (*sig == (unsigned char *)0) 
	    break;

	if ((cert->sig = alloc_bbuf()) == NULLBB)
	    return(NOTOK);

	if ((cert->sig->data  = alloc_uchar(*length)) == NULLUCP) {
	    FREE_BBUF(cert->sig);
	    return(NOTOK);
	}
	cert->sig->length = *length;
	BCOPY(*sig, cert->sig->data, *length);
        if (encode_cert(cert, ecert) != OK) {
            return(NOTOK);
        }
	break;

    default:
	return(NOTOK);
    }

    return(OK);
}
