/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * encode_crl.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

int encode_crl(dcrl, ecrl)
struct crl *dcrl;
struct bbuf **ecrl;
{
    int ret = NOTOK;
    struct bbuf *bb= NULLBB, *bb2= NULLBB, *bb3 = NULLBB;

    /* DOUBLE-CHECK PARAMETERS */
    if (dcrl == NULL_CRL) 
	return(NOTOK);

    if (ecrl == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUFS(*ecrl);

    /* ENCODE TOBESIGNED */
    if (encode_rtbs(dcrl->tobesigned, &bb2) != OK)
        goto cleanup;

    /* ENCODE SIGNATURE ALGORITHM IDENTIFIER & APPEND */
    if (encode_algid(dcrl->sig_alg, &bb) != OK)
        goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE SIGNATURE & APPEND */
    if (encode_bits(dcrl->sig, &bb) != OK)
	goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE LENGTH & PREPEND */
    if (encode_len(bb2->length, &bb) != OK)
	goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* PREPEND THE TAG */
    if (encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb) != OK)
	goto cleanup;
    *ecrl = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    ret = OK;

 cleanup:

    if (ret != OK)
        FREE_BBUF(*ecrl);
    FREE_BBUF(bb2);

    return(ret);
}

/*****************************************************************************/
