/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

/******************************************************************************
 *  BDES2.C                                                                   *
 *----------------------------------------------------------------------------*
 *  D A T A   E N C R Y P T I O N   S T A N D A R D                           *
 *  FEDERAL INFORMATION PROCESSING STANDARDS PUBLICATION (FIPS PUB) 46        *
 *  JANUARY 15, 1977                                                          *
 *----------------------------------------------------------------------------*
 *  This DES software was developed by Steve Kent and John Linn               *
 *  at BBN Communications Corporation, Cambridge, MA                          *
 *  Do not redistribute this software, or integrate with other                *
 *  software, without preserving this notice.                                 *
 *----------------------------------------------------------------------------*
 *  Modified by David M. Balenson, March 1988, for use with NBS software.     *
 *----------------------------------------------------------------------------*
 *  Cryptographic devices and technical data regarding them are subject to    *
 *  Federal Government export controls as specified in Title 22, Code of      *
 *  Federal Regulations, Parts 121 through 128.  Cryptographic devices        *
 *  implementing the Data Encryption Standard (DES) and technical data        *
 *  regarding them must comply with these Federal regulations.                *
 ******************************************************************************/

/*  Attached find "des88c.c", the successor to "fastdemo.c".  This version of 
C DES achieves up to a 30% speedup, depending on compiler and hardware base.
In addition to optimizations, it also includes a few more explanations.
Timing results on different configurations will be appreciated; thanks
to John Lowry of BBNCC for VAX and SUN results.  Note that the "des_encrypt"
and "des_decrypt" routines have been replaced with a single "do_des" routine.
As before, please heed the caveat at the beginning of the file.  Enjoy...

--jl */

/* ----------------------------------------------------------------- */
/* This DES software was developed by Steve Kent and John Linn       */
/* of BBN Communications Corporation, Cambridge, MA                  */
/* Do not redistribute this software, or integrate with other        */
/* software, without preserving this notice                          */
/* ----------------------------------------------------------------- */

/* Some of the DES optimization tricks are discussed in Hoornaert, Goubert, */
/* and Desmedt, "Efficient hardware implementation of the DES" in the */
/* proceedings of Crypto-84 and in "Analytical Characteristics of the DES" */
/* in Crypto-83 by Davio, Desmedt, et al. */

/* DES88C.C: Re-optimization of C DES code; John Linn, Sept. 1988 */
/* Machine-specific defines: */
/* MSDOS #defined automatically for MSDOS with Microsoft C compiler */
/* #define BIGWORDS iff unsigned or int > 16 bits, long > 32 bits (C/70, VAX) */
/* #define ULALLOWED if compiler allows unsigned longs */
/* #define SNOP_PTRX to use pointer expressions to reference snop table */
/* -- use this only if 4 chars exactly make up a long and your compiler */ 
/* -- and machine are fairly permissive about long->char conversions */
/* -- if SNOP_PTRX works on a machine, it will generally be faster */

/* #define TIMEONLY to time DES cycles rather than run ordinary demo */

/* On 4.77 mHz 8088, MSC 3.0 /Ox, #defining SNOP_PTRX and ULALLOWED */
/* yields approx 12.975 msec/cycle or 4.93 Kb/sec raw bit rate */
/* running same image on IBM PC/AT yields 4.06 ms/cyc or 15.744 Kb/sec */
/* in contrast, #defining only ULALLOWED -> 14.4 ms/cyc or 4.44 Kb/sec on 8088 */

/* On BBN C/70, cc -O, #defining SNOP_PTRX and BIGWORDS */
/* yields approx. 9.34 Kb/sec raw bit rate */

/* On VAX 11/785 ccv.bbn.com, cc -O, */
/* #defining SNOP_PTRX, BIGWORDS, and ULALLOWED and running 1000 iterations */
/* yields 230 ticks, 33.39 Kb/sec running as root with "nice" = 20 (top pri)  */

/* On SUN 3/50 ashmont.bbn.com (68020 at 20 mHz, 68881), cc -O */
/* #defining SNOP_PTRX, BIGWORDS, and ULALLOWED and running 1000 iterations */
/* yields 158 ticks, 48.61 Kb/sec running as root with "nice" = 20 (top pri) */

/* #define SNOP_PTRX  */
#define ULALLOWED
#define BIGWORDS 

#include        <stdio.h>
#include        <ctype.h>
#ifdef  MSDOS
#include        <sys\types.h>
#include        <sys\timeb.h>
#endif

#ifdef  ULALLOWED
#define LTYP    unsigned long
#else
#define LTYP    long
#endif

#define BYTE unsigned char

#define FALSE   0
#define TRUE    1

#define ECB     1
#define CBC     ECB+1
#define OFB     CBC+1
#define CFB     OFB+1

/* Dan Hoey (hoey@nrl-aic)'s optimization, per 16 May 1986 netmail */
/* Exchange bits of A selected by mask M with bits of B selected by */
/* mask (M << S). TMP is a temporary. */
#define EXSHMSK(A,M,B,S,TMP)    \
    TMP = ((B >> S) ^ A) & M;   \
    A ^= TMP;                   \
    TMP <<= S;                  \
    B ^= TMP

#ifdef  TIMEONLY
/* facilities for timing */
struct tbuffer
{
  long proc_utime;
  long proc_stime;
  long child_utime;
  long child_stime;
};
struct tbuffer t_before;
struct tbuffer t_after;
#endif

/* --- some bit manipulation primitives --- */

/* g_keybit -- extract bit bnum from the key in inkey */
#define g_keybit(bnum) (01 & (inkey [bnum/8] >> (8 - (bnum%8))))

long    lrot28 (lval)
/* do left rotate of 28 bit quantity */
long    lval;
{
  lval <<= 1;
  if (0X10000000L & lval) lval++;
  lval &= 0XFFFFFFFL;
  return (lval);
}

/* --- following code and data does key schedule generation --- */

unsigned long ks [16] [4];

int setdeskey (sw1,sw2,inkey)  /* Make a key schedule from key bytes in inkey */
int sw1, sw2;
BYTE inkey [8];
{
    extern unsigned long pc2otab [8] [128];
    extern int pc1c [], pc1d [], shiftsked [];

    int   r, round;
    long  pcct, pcdt;
    long  pc2out [2];
    int   i, j, parac;
    BYTE  incopy;

    /* test parity of bytes in inkey */
    if (sw1) {
	for (i = 0; i < 8; i++)	/* do each byte */
	{
	    parac = 0;
	    incopy = inkey [i];

	    for (j = 0; j < 8; j++) /* 8 bits in a DES byte */
	    {
		if (incopy & 01) parac++;
		incopy >>= 1;
	    }
	    if (! (parac & 01)) 
		return (FALSE); /* no odd parity on this byte */
	}
    }

    /* do pc-1 permutation, extracting bits from inkey */
    pcct = pcdt = 0L;
    for (i = 0; i < 27; i++)   
	/* filling all appropriate bits */
    {
	pcct |= g_keybit(pc1c [i]);
	pcdt |= g_keybit(pc1d [i]);
	pcct <<= 1;
	pcdt <<= 1;
    }
    /* one final ior, without a shift */
    pcct |= g_keybit(pc1c [i]);
    pcdt |= g_keybit(pc1d [i]);

    for (round = 0; round < 16; round++)
    {
	/* always at least one shift */
	pcct = lrot28 (pcct);
	pcdt = lrot28 (pcdt);

	if (shiftsked [round] == 2)
	{			/* this round needs another shift */
	    pcct = lrot28 (pcct);
	    pcdt = lrot28 (pcdt);
	} 

	/* Now, pcct and pcdt have the values on which we can apply
	   pc2 and select the key bits, storing them in pc2out[0] and
	   pc2out[1]. The high order [pc2out[0]] bits all come from
	   pcct, and the low order from pcdt. */

	pc2out [0] = pc2otab [0] [pcct >> 21];
	pc2out [0] |= pc2otab [1] [0X7F & (pcct >> 14)];
	pc2out [0] |= pc2otab [2] [0X7F & (pcct >> 7)];
	pc2out [0] |= pc2otab [3] [0X7F & pcct];

	pc2out [1] = pc2otab [4] [pcdt >> 21];
	pc2out [1] |= pc2otab [5] [0X7F & (pcdt >> 14)];
	pc2out [1] |= pc2otab [6] [0X7F & (pcdt >> 7)];
	pc2out [1] |= pc2otab [7] [0X7F & pcdt];

	/* order key bits and bytes so as to be compatible with
	   the format generated by the E implementation */

	r = sw2 ? 15-round : round;

	ks [r] [0] = 0XFC00 & (pc2out [0] >> 8);
	ks [r] [0] |= (0XFC & (pc2out [0] >> 4));
	ks [r] [1] = 0XFC00 & (pc2out [1] >> 8);
	ks [r] [1] |= (0XFC & (pc2out [1] >> 4));

	ks [r] [2] = 0XFC00 & (pc2out [0] >> 2);
	ks [r] [2] |= (0XFC & (pc2out [0] << 2));
	ks [r] [3] = 0XFC00 & (pc2out [1] >> 2);
	ks [r] [3] |= (0XFC & (pc2out [1] << 2));
    }
    return (TRUE);
}


#define SPSEGSZ 256     /* num of chars in one segment of snop table */

/* Structure snop is a two-dimensional array.  The high-order dimension */
/* corresponds to 1 of 8 input bytes, each in the format produced by the E */
/* implementation (each byte has 6 significant bits, left-justified in an */
/* 8-bit byte).  Using a series of 8 table lookups in snop (one for each */
/* byte), and IOR'ing the corresponding 32-bit entries, the caller can */
/* assemble the composition of s-box lookup and P permutation as specified */
/* in DES.  In a table entry corresponding to a particular byte, only those */
/* bits are set which correspond to those selected by P for the particular */
/* s-box.  The current format for snop has 64, not 256 entries per byte */
/* position.  Therefore, it is necessary to divide a byte's value by 4 (or */
/* use it as a char pointer, as is done if SNOP_PTRX is defined) before */
/* using it as a table index. */

#define LMASK    0XFCFCFCFCL;

/* do_des -- encrypt or decrypt a block under key sched in ks */
cryptodes (in, out)   
BYTE in[8];
BYTE out[8];
{
  extern LTYP snop [8] [64];

  LTYP inar [2];
  LTYP outar [2];
  register int round;
  unsigned expan [4];   /* receives output of E transform */
  LTYP sbout, tlong, lt;
#ifdef SNOP_PTRX
  char *cp;
#endif


  packbtol(&in[0],&inar[0]);
  packbtol(&in[4],&inar[1]);

  /* first, do IP transformation */
  outar [0] = inar [0];
  outar [1] = inar [1];
  EXSHMSK(outar[1],(LTYP) 0x0f0f0f0fL,outar[0],4,lt);
  EXSHMSK(outar[1],(LTYP) 0x0000ffffL,outar[0],16,lt);
  EXSHMSK(outar[0],(LTYP) 0x33333333L,outar[1],2,lt);
  EXSHMSK(outar[0],(LTYP) 0x00ff00ffL,outar[1],8,lt);
  EXSHMSK(outar[1],(LTYP) 0x55555555L,outar[0],1,lt);

  for (round = 0; round < 16; round++)
  {
    tlong = outar [1] >> 1; 
#ifndef  ULALLOWED          
    tlong &= 0X7FFFFFFFL;       /* defeat sign extend -- jl 17 feb 84 */ 
#endif 
    if (0X1L & outar [1]) tlong |= 0X80000000L; 
    tlong &= LMASK; 
    expan [0] = (unsigned) (tlong >> 16); 
    expan [1] = (unsigned) tlong; 
    tlong = outar [1] << 3; 
    if (0X80000000L & outar [1]) tlong |= 04;  /* note 2 lsbs ignored */ 
    tlong &= LMASK; 
    expan [2] = (unsigned) (tlong >> 16); 
    expan [3] = (unsigned) tlong; 

    expan [0] ^= ks [round] [0]; 
    expan [1] ^= ks [round] [1]; 
    expan [2] ^= ks [round] [2]; 
    expan [3] ^= ks [round] [3]; 
#ifdef DEBUG_DES
   printf("after KS XOR, expan[0]=%x, expan[1]=%x, expan[2]=%x, expan[3]=%x\n",
	  expan[0], expan[1], expan[2], expan[3]);
#endif

#ifdef  BIGWORDS
    expan [0] &= 0XFFFF; expan [1] &= 0XFFFF;
    expan [2] &= 0XFFFF; expan [3] &= 0XFFFF;
#endif

#ifdef  SNOP_PTRX
    /* If machine and compiler constraints forgive and permit, */
    /* can optimize snop fetches through the use of pointer */
    /* expressions which exploit the pre-alignment of bits in */
    /* expan, 2 bits left of the LSB, to form byte ptrs into snop */
    cp = snop;
    sbout = *((LTYP *) (cp + (expan [0] >> 8)));
    sbout |= *((LTYP *) (cp + SPSEGSZ + (0XFF & expan [0])));
    sbout |= *((LTYP *) (cp + (2 * SPSEGSZ) + (expan [1] >> 8)));
    sbout |= *((LTYP *) (cp + (3 * SPSEGSZ) + (0XFF & expan [1])));
    sbout |= *((LTYP *) (cp + (4 * SPSEGSZ) + (expan [2] >> 8)));
    sbout |= *((LTYP *) (cp + (5 * SPSEGSZ) + (0XFF & expan [2])));
    sbout |= *((LTYP *) (cp + (6 * SPSEGSZ) + (expan [3] >> 8)));
    sbout |= *((LTYP *) (cp + (7 * SPSEGSZ) + (0XFF & expan [3])));
#else
    sbout = snop [1] [0X3F & (expan [0] >> 2)]; 
    sbout |= snop [0] [0X3F & (expan [0] >> 10)]; 
    sbout |= snop [3] [0X3F & (expan [1] >> 2)]; 
    sbout |= snop [2] [0X3F & (expan [1] >> 10)]; 
    sbout |= snop [5] [0X3F & (expan [2] >> 2)]; 
    sbout |= snop [4] [0X3F & (expan [2] >> 10)]; 
    sbout |= snop [7] [0X3F & (expan [3] >> 2)]; 
    sbout |= snop [6] [0X3F & (expan [3] >> 10)]; 
#endif

    tlong = outar [0]; 
    outar [0] = outar [1]; 
    outar [1] = tlong ^ sbout;

#ifdef DEBUG_DES
  printf ("after round %d, outar[0]=%lx, outar[1]=%lx\n", 
   round, outar[0], outar[1]);
#endif
  }

  /* a final swap */
  tlong = outar [0];
  outar [0] = outar [1];
  outar [1] = tlong;

  /* do IP-inverse transformation */
  EXSHMSK(outar[1],(LTYP) 0x55555555L,outar[0],1,lt);
  EXSHMSK(outar[0],(LTYP) 0x00ff00ffL,outar[1],8,lt);
  EXSHMSK(outar[0],(LTYP) 0x33333333L,outar[1],2,lt);
  EXSHMSK(outar[1],(LTYP) 0x0000ffffL,outar[0],16,lt);
  EXSHMSK(outar[1],(LTYP) 0x0f0f0f0fL,outar[0],4,lt);

  sprdltob(outar[0],&out[0]);
  sprdltob(outar[1],&out[4]);

}

/* support routines for demodes */

/* read input bytes from stdin */
int     g_inbytes (nby, buffer)     /* returns TRUE iff EOF reached */
int     nby;        /* number of bytes needed at a time */
                    /* if insufficient, will be padded with nulls */
char    buffer [];
{
  int   bufix;
  int   getcval;

  /* init all significant bytes to null pad */
  for (bufix = 0; bufix < nby; bufix++) buffer[bufix] = 0;

  for (bufix = 0; bufix < nby; bufix++)
  {
    getcval = getchar ();
    buffer [bufix] = (char) getcval;
    if (getcval == EOF)
    {
      buffer[bufix] = 0;        /* replace with pad */
      return (TRUE);            /* indicating that EOF detected */
    }
  }
  return (FALSE);       /* indicating no EOF detected */
}

/* represent a series of bytes (conditionally) in two buffers, as
   printable representation and hex representation */
di_bytes (nby, inbuf, pr_buf, hx_buf)
int     nby;
char    inbuf [];
char    pr_buf [];      /* NULL if not desired */
char    hx_buf [];      /* NULL if not desired */
{
  int i;

  for (i = 0; i < nby; i++)
  {
    if (pr_buf != NULL)
    {
      /* Try to show as a printable character, either directly or */
      /* by masking off the MSB (if the latter, prefix with '#') */
      if (inbuf [i] > 0x7f)
      {
        if (isprint (inbuf [i] & 0x7f))
	    (void) sprintf (pr_buf, "#%c", inbuf [i] & 0x7f);
        else (void) sprintf (pr_buf, "  ");
      }
      else
      {
        if (isprint (inbuf [i]))
          (void) sprintf (pr_buf, " %c", inbuf [i]);
        else (void) sprintf (pr_buf, "  ");
      }
      pr_buf += 2;
    }
    if (hx_buf != NULL)
    {
      (void) sprintf (hx_buf, "%1x%1x", 0xf & (inbuf[i]>>4),0xf & inbuf [i]);
      hx_buf += 2;
    }
  }
  if (pr_buf != NULL) (void) sprintf (pr_buf, "|");
  if (hx_buf != NULL) (void) sprintf (hx_buf, "|");
}

packbtol (as_ba, as_l)   /* pack 4 bytes into a long */
char    as_ba [];
LTYP *as_l;
{
  LTYP lt;

  lt = as_ba [0] & 0xff;
  lt <<= 8;
  lt |= as_ba [1] & 0xff;
  lt <<= 8;
  lt |= as_ba [2] & 0xff;
  lt <<= 8;
  lt |= as_ba [3] & 0xff;

  *as_l = lt;
}

sprdltob (as_l, as_ba)  /* spread a long into 4 bytes */
LTYP as_l;
char    as_ba [];
{
  as_ba [0] = (char) ((as_l >> 24) & 0xff);
  as_ba [1] = (char) ((as_l >> 16) & 0xff);
  as_ba [2] = (char) ((as_l >> 8) & 0xff);
  as_ba [3] = (char) (as_l & 0xff);
}

lsh64 (lar, count)      /* left shift a 64-bit quantity maintained */
LTYP lar[];
int     count;          /* a long has at least 32 bits */
{
  int   i; 
  LTYP t;

  for (i = 0; i < count; i++)
  {
    t = (lar [1] >> 31) & 0x1l;
    lar [1] <<= 1;
    lar [0] <<= 1;
    lar [0] |= t;
  }  
  lar [0] &= 0xffffffffl;
  lar [1] &= 0xffffffffl;
}

rsh64 (lar, count)      /* right shift a 64-bit quantity maintained */
LTYP lar[];
int     count;          /* a long has at least 32 bits */
{
  int   i; 
  LTYP t;

  for (i = 0; i < count; i++)
  {
    t = lar [0] & 0x1l;
    lar [1] >>= 1;
    lar [0] >>= 1;
    lar [1] |= (t << 31);
  }  
}

rplr64 (base, modr, nbits)      /* replace rightmost nbits of base */
LTYP    base[];                 /* (64-bit qty in 2-elmt long array) */
LTYP    modr[];                 /* with corresponding bits from modr */
int     nbits;
{       /* works on architectures where a long is 32 bits or more */
  LTYP  mask;
  LTYP  lmod;   /* local copy of modr word */

  mask = (nbits >= 32) ? 0xffffffffl : ((0x1l << nbits) - 1);
  base [1] &= ~mask;    /* wipe out existing low bits */
  lmod = modr [1] & mask;
  base [1] |= lmod;

  nbits -= 32;
  if (nbits <= 0) return;
  
  mask = (0x1l << nbits) - 1;
  base [0] &= ~mask;
  lmod = modr [0] & mask;
  base [0] |= lmod;
}

cpy64 (src, dest)       /* copy src 2-elmt long array to dest */
LTYP    src[];
LTYP    dest[];
{
  dest [0] = src [0];
  dest [1] = src [1];
}


#ifdef  MSDOS
int seq_nocase (str1, str2)
char    *str1;
char    *str2;
{
  if (0 == strcmpi (str1,str2)) 
    return (TRUE);
    else return (FALSE);
}
#else
/* seq_nocase: */
/* perform case-insensitive comparison of null-terminated ASCII strings */
/* return 0 if not equal, 1 if equal */
/* BUG: shows a match when one string terminates as a subset of another, */
/* but this doesn't affect usability in this context */
/* included here since different UNIX systems are widely variable in */
/* their availability of string library routines */

int seq_nocase (str1, str2)
char *str1, *str2;
{
  char cv1, cv2;

  for ( ; ((*str1 != '\0') && (*str2 != '\0')); str1++, str2++)
  {
    cv1 = ((*str1 >= 'a') && (*str1 <= 'z')) ?
      (0X7F & (*str1 - ('a' - 'A'))) : *str1;
    cv2 = ((*str2 >= 'a') && (*str2 <= 'z')) ?
      (0X7F & (*str2 - ('a' - 'A'))) : *str2;
    if (cv1 != cv2)
    {       /* chars unequal */
                  return (0);
    }
  }
  /* if we get here, all characters were equal */
  return (1);
}
#endif

/* table definitions follow */
/* tables to describe permutations, per NBS FIPS */

int pc1c [] =
        { 57, 49, 41, 33, 25, 17, 9,
          1, 58, 50, 42, 34, 26, 18,
          10, 2, 59, 51, 43, 35, 27,
          19, 11, 3, 60, 52, 44, 36 };

int pc1d [] =
        { 63, 55, 47, 39, 31, 23, 15,
          7, 62, 54, 46, 38, 30, 22,
          14, 6, 61, 53, 45, 37, 29,
          21, 13, 5, 28, 20, 12, 4 };

int shiftsked []=
        { 1, 1, 2, 2, 2, 2, 2, 2,
          1, 2, 2, 2, 2, 2, 2, 1 };

LTYP snop [8] [64] = {
0X808200,0X0,0X8000,0X808202,
0X808002,0X8202,0X2,0X8000,
0X200,0X808200,0X808202,0X200,
0X800202,0X808002,0X800000,0X2,
0X202,0X800200,0X800200,0X8200,
0X8200,0X808000,0X808000,0X800202,
0X8002,0X800002,0X800002,0X8002,
0X0,0X202,0X8202,0X800000,
0X8000,0X808202,0X2,0X808000,
0X808200,0X800000,0X800000,0X200,
0X808002,0X8000,0X8200,0X800002,
0X200,0X2,0X800202,0X8202,
0X808202,0X8002,0X808000,0X800202,
0X800002,0X202,0X8202,0X808200,
0X202,0X800200,0X800200,0X0,
0X8002,0X8200,0X0,0X808002,

0X104,0X4010100,0X0,0X4010004,
0X4000100,0X0,0X10104,0X4000100,
0X10004,0X4000004,0X4000004,0X10000,
0X4010104,0X10004,0X4010000,0X104,
0X4000000,0X4,0X4010100,0X100,
0X10100,0X4010000,0X4010004,0X10104,
0X4000104,0X10100,0X10000,0X4000104,
0X4,0X4010104,0X100,0X4000000,
0X4010100,0X4000000,0X10004,0X104,
0X10000,0X4010100,0X4000100,0X0,
0X100,0X10004,0X4010104,0X4000100,
0X4000004,0X100,0X0,0X4010004,
0X4000104,0X10000,0X4000000,0X4010104,
0X4,0X10104,0X10100,0X4000004,
0X4010000,0X4000104,0X104,0X4010000,
0X10104,0X4,0X4010004,0X10100,

0X80,0X1040080,0X1040000,0X21000080,
0X40000,0X80,0X20000000,0X1040000,
0X20040080,0X40000,0X1000080,0X20040080,
0X21000080,0X21040000,0X40080,0X20000000,
0X1000000,0X20040000,0X20040000,0X0,
0X20000080,0X21040080,0X21040080,0X1000080,
0X21040000,0X20000080,0X0,0X21000000,
0X1040080,0X1000000,0X21000000,0X40080,
0X40000,0X21000080,0X80,0X1000000,
0X20000000,0X1040000,0X21000080,0X20040080,
0X1000080,0X20000000,0X21040000,0X1040080,
0X20040080,0X80,0X1000000,0X21040000,
0X21040080,0X40080,0X21000000,0X21040080,
0X1040000,0X0,0X20040000,0X21000000,
0X40080,0X1000080,0X20000080,0X40000,
0X0,0X20040000,0X1040080,0X20000080,

0X100000,0X2100001,0X2000401,0X0,
0X400,0X2000401,0X100401,0X2100400,
0X2100401,0X100000,0X0,0X2000001,
0X1,0X2000000,0X2100001,0X401,
0X2000400,0X100401,0X100001,0X2000400,
0X2000001,0X2100000,0X2100400,0X100001,
0X2100000,0X400,0X401,0X2100401,
0X100400,0X1,0X2000000,0X100400,
0X2000000,0X100400,0X100000,0X2000401,
0X2000401,0X2100001,0X2100001,0X1,
0X100001,0X2000000,0X2000400,0X100000,
0X2100400,0X401,0X100401,0X2100400,
0X401,0X2000001,0X2100401,0X2100000,
0X100400,0X0,0X1,0X2100401,
0X0,0X100401,0X2100000,0X400,
0X2000001,0X2000400,0X400,0X100001,

0X40084010,0X40004000,0X4000,0X84010,
0X80000,0X10,0X40080010,0X40004010,
0X40000010,0X40084010,0X40084000,0X40000000,
0X40004000,0X80000,0X10,0X40080010,
0X84000,0X80010,0X40004010,0X0,
0X40000000,0X4000,0X84010,0X40080000,
0X80010,0X40000010,0X0,0X84000,
0X4010,0X40084000,0X40080000,0X4010,
0X0,0X84010,0X40080010,0X80000,
0X40004010,0X40080000,0X40084000,0X4000,
0X40080000,0X40004000,0X10,0X40084010,
0X84010,0X10,0X4000,0X40000000,
0X4010,0X40084000,0X80000,0X40000010,
0X80010,0X40004010,0X40000010,0X80010,
0X84000,0X0,0X40004000,0X4010,
0X40000000,0X40080010,0X40084010,0X84000,

0X80401000,0X80001040,0X80001040,0X40,
0X401040,0X80400040,0X80400000,0X80001000,
0X0,0X401000,0X401000,0X80401040,
0X80000040,0X0,0X400040,0X80400000,
0X80000000,0X1000,0X400000,0X80401000,
0X40,0X400000,0X80001000,0X1040,
0X80400040,0X80000000,0X1040,0X400040,
0X1000,0X401040,0X80401040,0X80000040,
0X400040,0X80400000,0X401000,0X80401040,
0X80000040,0X0,0X0,0X401000,
0X1040,0X400040,0X80400040,0X80000000,
0X80401000,0X80001040,0X80001040,0X40,
0X80401040,0X80000040,0X80000000,0X1000,
0X80400000,0X80001000,0X401040,0X80400040,
0X80001000,0X1040,0X400000,0X80401000,
0X40,0X400000,0X1000,0X401040,

0X10000008,0X10200000,0X2000,0X10202008,
0X10200000,0X8,0X10202008,0X200000,
0X10002000,0X202008,0X200000,0X10000008,
0X200008,0X10002000,0X10000000,0X2008,
0X0,0X200008,0X10002008,0X2000,
0X202000,0X10002008,0X8,0X10200008,
0X10200008,0X0,0X202008,0X10202000,
0X2008,0X202000,0X10202000,0X10000000,
0X10002000,0X8,0X10200008,0X202000,
0X10202008,0X200000,0X2008,0X10000008,
0X200000,0X10002000,0X10000000,0X2008,
0X10000008,0X10202008,0X202000,0X10200000,
0X202008,0X10202000,0X0,0X10200008,
0X8,0X2000,0X10200000,0X202008,
0X2000,0X200008,0X10002008,0X0,
0X10202000,0X10000000,0X200008,0X10002008,

0X8000820,0X800,0X20000,0X8020820,
0X8000000,0X8000820,0X20,0X8000000,
0X20020,0X8020000,0X8020820,0X20800,
0X8020800,0X20820,0X800,0X20,
0X8020000,0X8000020,0X8000800,0X820,
0X20800,0X20020,0X8020020,0X8020800,
0X820,0X0,0X0,0X8020020,
0X8000020,0X8000800,0X20820,0X20000,
0X20820,0X20000,0X8020800,0X800,
0X20,0X8020020,0X800,0X20820,
0X8000800,0X20,0X8000020,0X8020000,
0X8020020,0X8000000,0X20000,0X8000820,
0X0,0X8020820,0X20020,0X8000020,
0X8020000,0X8000800,0X8000820,0X0,
0X8020820,0X20800,0X20800,0X820,
0X820,0X20020,0X8000000,0X8020800
};

unsigned long pc2otab [8] [128] = {
0X0,0X10,0X4000,0X4010,0X40000,0X40010,0X44000,0X44010,
0X100,0X110,0X4100,0X4110,0X40100,0X40110,0X44100,0X44110,
0X20000,0X20010,0X24000,0X24010,0X60000,0X60010,0X64000,0X64010,
0X20100,0X20110,0X24100,0X24110,0X60100,0X60110,0X64100,0X64110,
0X1,0X11,0X4001,0X4011,0X40001,0X40011,0X44001,0X44011,
0X101,0X111,0X4101,0X4111,0X40101,0X40111,0X44101,0X44111,
0X20001,0X20011,0X24001,0X24011,0X60001,0X60011,0X64001,0X64011,
0X20101,0X20111,0X24101,0X24111,0X60101,0X60111,0X64101,0X64111,
0X80000,0X80010,0X84000,0X84010,0XC0000,0XC0010,0XC4000,0XC4010,
0X80100,0X80110,0X84100,0X84110,0XC0100,0XC0110,0XC4100,0XC4110,
0XA0000,0XA0010,0XA4000,0XA4010,0XE0000,0XE0010,0XE4000,0XE4010,
0XA0100,0XA0110,0XA4100,0XA4110,0XE0100,0XE0110,0XE4100,0XE4110,
0X80001,0X80011,0X84001,0X84011,0XC0001,0XC0011,0XC4001,0XC4011,
0X80101,0X80111,0X84101,0X84111,0XC0101,0XC0111,0XC4101,0XC4111,
0XA0001,0XA0011,0XA4001,0XA4011,0XE0001,0XE0011,0XE4001,0XE4011,
0XA0101,0XA0111,0XA4101,0XA4111,0XE0101,0XE0111,0XE4101,0XE4111,

0X0,0X800000,0X2,0X800002,0X200,0X800200,0X202,0X800202,
0X200000,0XA00000,0X200002,0XA00002,0X200200,0XA00200,0X200202,0XA00202,
0X1000,0X801000,0X1002,0X801002,0X1200,0X801200,0X1202,0X801202,
0X201000,0XA01000,0X201002,0XA01002,0X201200,0XA01200,0X201202,0XA01202,
0X0,0X800000,0X2,0X800002,0X200,0X800200,0X202,0X800202,
0X200000,0XA00000,0X200002,0XA00002,0X200200,0XA00200,0X200202,0XA00202,
0X1000,0X801000,0X1002,0X801002,0X1200,0X801200,0X1202,0X801202,
0X201000,0XA01000,0X201002,0XA01002,0X201200,0XA01200,0X201202,0XA01202,
0X40,0X800040,0X42,0X800042,0X240,0X800240,0X242,0X800242,
0X200040,0XA00040,0X200042,0XA00042,0X200240,0XA00240,0X200242,0XA00242,
0X1040,0X801040,0X1042,0X801042,0X1240,0X801240,0X1242,0X801242,
0X201040,0XA01040,0X201042,0XA01042,0X201240,0XA01240,0X201242,0XA01242,
0X40,0X800040,0X42,0X800042,0X240,0X800240,0X242,0X800242,
0X200040,0XA00040,0X200042,0XA00042,0X200240,0XA00240,0X200242,0XA00242,
0X1040,0X801040,0X1042,0X801042,0X1240,0X801240,0X1242,0X801242,
0X201040,0XA01040,0X201042,0XA01042,0X201240,0XA01240,0X201242,0XA01242,

0X0,0X2000,0X4,0X2004,0X400,0X2400,0X404,0X2404,
0X0,0X2000,0X4,0X2004,0X400,0X2400,0X404,0X2404,
0X400000,0X402000,0X400004,0X402004,0X400400,0X402400,0X400404,0X402404,
0X400000,0X402000,0X400004,0X402004,0X400400,0X402400,0X400404,0X402404,
0X20,0X2020,0X24,0X2024,0X420,0X2420,0X424,0X2424,
0X20,0X2020,0X24,0X2024,0X420,0X2420,0X424,0X2424,
0X400020,0X402020,0X400024,0X402024,0X400420,0X402420,0X400424,0X402424,
0X400020,0X402020,0X400024,0X402024,0X400420,0X402420,0X400424,0X402424,
0X8000,0XA000,0X8004,0XA004,0X8400,0XA400,0X8404,0XA404,
0X8000,0XA000,0X8004,0XA004,0X8400,0XA400,0X8404,0XA404,
0X408000,0X40A000,0X408004,0X40A004,0X408400,0X40A400,0X408404,0X40A404,
0X408000,0X40A000,0X408004,0X40A004,0X408400,0X40A400,0X408404,0X40A404,
0X8020,0XA020,0X8024,0XA024,0X8420,0XA420,0X8424,0XA424,
0X8020,0XA020,0X8024,0XA024,0X8420,0XA420,0X8424,0XA424,
0X408020,0X40A020,0X408024,0X40A024,0X408420,0X40A420,0X408424,0X40A424,
0X408020,0X40A020,0X408024,0X40A024,0X408420,0X40A420,0X408424,0X40A424,

0X0,0X10000,0X8,0X10008,0X80,0X10080,0X88,0X10088,
0X0,0X10000,0X8,0X10008,0X80,0X10080,0X88,0X10088,
0X100000,0X110000,0X100008,0X110008,0X100080,0X110080,0X100088,0X110088,
0X100000,0X110000,0X100008,0X110008,0X100080,0X110080,0X100088,0X110088,
0X800,0X10800,0X808,0X10808,0X880,0X10880,0X888,0X10888,
0X800,0X10800,0X808,0X10808,0X880,0X10880,0X888,0X10888,
0X100800,0X110800,0X100808,0X110808,0X100880,0X110880,0X100888,0X110888,
0X100800,0X110800,0X100808,0X110808,0X100880,0X110880,0X100888,0X110888,
0X0,0X10000,0X8,0X10008,0X80,0X10080,0X88,0X10088,
0X0,0X10000,0X8,0X10008,0X80,0X10080,0X88,0X10088,
0X100000,0X110000,0X100008,0X110008,0X100080,0X110080,0X100088,0X110088,
0X100000,0X110000,0X100008,0X110008,0X100080,0X110080,0X100088,0X110088,
0X800,0X10800,0X808,0X10808,0X880,0X10880,0X888,0X10888,
0X800,0X10800,0X808,0X10808,0X880,0X10880,0X888,0X10888,
0X100800,0X110800,0X100808,0X110808,0X100880,0X110880,0X100888,0X110888,
0X100800,0X110800,0X100808,0X110808,0X100880,0X110880,0X100888,0X110888,

0X0,0X0,0X80,0X80,0X2000,0X2000,0X2080,0X2080,
0X1,0X1,0X81,0X81,0X2001,0X2001,0X2081,0X2081,
0X200000,0X200000,0X200080,0X200080,0X202000,0X202000,0X202080,0X202080,
0X200001,0X200001,0X200081,0X200081,0X202001,0X202001,0X202081,0X202081,
0X20000,0X20000,0X20080,0X20080,0X22000,0X22000,0X22080,0X22080,
0X20001,0X20001,0X20081,0X20081,0X22001,0X22001,0X22081,0X22081,
0X220000,0X220000,0X220080,0X220080,0X222000,0X222000,0X222080,0X222080,
0X220001,0X220001,0X220081,0X220081,0X222001,0X222001,0X222081,0X222081,
0X2,0X2,0X82,0X82,0X2002,0X2002,0X2082,0X2082,
0X3,0X3,0X83,0X83,0X2003,0X2003,0X2083,0X2083,
0X200002,0X200002,0X200082,0X200082,0X202002,0X202002,0X202082,0X202082,
0X200003,0X200003,0X200083,0X200083,0X202003,0X202003,0X202083,0X202083,
0X20002,0X20002,0X20082,0X20082,0X22002,0X22002,0X22082,0X22082,
0X20003,0X20003,0X20083,0X20083,0X22003,0X22003,0X22083,0X22083,
0X220002,0X220002,0X220082,0X220082,0X222002,0X222002,0X222082,0X222082,
0X220003,0X220003,0X220083,0X220083,0X222003,0X222003,0X222083,0X222083,

0X0,0X10,0X800000,0X800010,0X10000,0X10010,0X810000,0X810010,
0X200,0X210,0X800200,0X800210,0X10200,0X10210,0X810200,0X810210,
0X0,0X10,0X800000,0X800010,0X10000,0X10010,0X810000,0X810010,
0X200,0X210,0X800200,0X800210,0X10200,0X10210,0X810200,0X810210,
0X100000,0X100010,0X900000,0X900010,0X110000,0X110010,0X910000,0X910010,
0X100200,0X100210,0X900200,0X900210,0X110200,0X110210,0X910200,0X910210,
0X100000,0X100010,0X900000,0X900010,0X110000,0X110010,0X910000,0X910010,
0X100200,0X100210,0X900200,0X900210,0X110200,0X110210,0X910200,0X910210,
0X4,0X14,0X800004,0X800014,0X10004,0X10014,0X810004,0X810014,
0X204,0X214,0X800204,0X800214,0X10204,0X10214,0X810204,0X810214,
0X4,0X14,0X800004,0X800014,0X10004,0X10014,0X810004,0X810014,
0X204,0X214,0X800204,0X800214,0X10204,0X10214,0X810204,0X810214,
0X100004,0X100014,0X900004,0X900014,0X110004,0X110014,0X910004,0X910014,
0X100204,0X100214,0X900204,0X900214,0X110204,0X110214,0X910204,0X910214,
0X100004,0X100014,0X900004,0X900014,0X110004,0X110014,0X910004,0X910014,
0X100204,0X100214,0X900204,0X900214,0X110204,0X110214,0X910204,0X910214,

0X0,0X400,0X1000,0X1400,0X80000,0X80400,0X81000,0X81400,
0X20,0X420,0X1020,0X1420,0X80020,0X80420,0X81020,0X81420,
0X4000,0X4400,0X5000,0X5400,0X84000,0X84400,0X85000,0X85400,
0X4020,0X4420,0X5020,0X5420,0X84020,0X84420,0X85020,0X85420,
0X800,0XC00,0X1800,0X1C00,0X80800,0X80C00,0X81800,0X81C00,
0X820,0XC20,0X1820,0X1C20,0X80820,0X80C20,0X81820,0X81C20,
0X4800,0X4C00,0X5800,0X5C00,0X84800,0X84C00,0X85800,0X85C00,
0X4820,0X4C20,0X5820,0X5C20,0X84820,0X84C20,0X85820,0X85C20,
0X0,0X400,0X1000,0X1400,0X80000,0X80400,0X81000,0X81400,
0X20,0X420,0X1020,0X1420,0X80020,0X80420,0X81020,0X81420,
0X4000,0X4400,0X5000,0X5400,0X84000,0X84400,0X85000,0X85400,
0X4020,0X4420,0X5020,0X5420,0X84020,0X84420,0X85020,0X85420,
0X800,0XC00,0X1800,0X1C00,0X80800,0X80C00,0X81800,0X81C00,
0X820,0XC20,0X1820,0X1C20,0X80820,0X80C20,0X81820,0X81C20,
0X4800,0X4C00,0X5800,0X5C00,0X84800,0X84C00,0X85800,0X85C00,
0X4820,0X4C20,0X5820,0X5C20,0X84820,0X84C20,0X85820,0X85C20,

0X0,0X100,0X40000,0X40100,0X0,0X100,0X40000,0X40100,
0X40,0X140,0X40040,0X40140,0X40,0X140,0X40040,0X40140,
0X400000,0X400100,0X440000,0X440100,0X400000,0X400100,0X440000,0X440100,
0X400040,0X400140,0X440040,0X440140,0X400040,0X400140,0X440040,0X440140,
0X8000,0X8100,0X48000,0X48100,0X8000,0X8100,0X48000,0X48100,
0X8040,0X8140,0X48040,0X48140,0X8040,0X8140,0X48040,0X48140,
0X408000,0X408100,0X448000,0X448100,0X408000,0X408100,0X448000,0X448100,
0X408040,0X408140,0X448040,0X448140,0X408040,0X408140,0X448040,0X448140,
0X8,0X108,0X40008,0X40108,0X8,0X108,0X40008,0X40108,
0X48,0X148,0X40048,0X40148,0X48,0X148,0X40048,0X40148,
0X400008,0X400108,0X440008,0X440108,0X400008,0X400108,0X440008,0X440108,
0X400048,0X400148,0X440048,0X440148,0X400048,0X400148,0X440048,0X440148,
0X8008,0X8108,0X48008,0X48108,0X8008,0X8108,0X48008,0X48108,
0X8048,0X8148,0X48048,0X48148,0X8048,0X8148,0X48048,0X48148,
0X408008,0X408108,0X448008,0X448108,0X408008,0X408108,0X448008,0X448108,
0X408048,0X408148,0X448048,0X448148,0X408048,0X408148,0X448048,0X448148
};
