/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 * encipher_key.c
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "crypto.h"
#include "util.h"

encipher_key(aid, key, pw, enciphered_key)
struct algid	*aid;
struct bbuf 	*key;
char		*pw;
struct bbuf 	**enciphered_key;
{
    int ret = NOTOK;
    struct bbuf *enckey = NULLBB;

    /* CHECK FUNCTION PARAMETERS */
    if (key == NULLBB || enciphered_key == (struct bbuf **)0) 
	goto cleanup;

    FREE_BBUF(*enciphered_key);

    /* SIMPLY DUP KEY IF NO PASSWORD PROVIDED */
    if ((pw == NULLCP) || (*pw == NULLC)) {
	ret = ((*enciphered_key = dup_bbuf(key)) != NULLBB) ? OK
	    : NOTOK;
	goto cleanup;
    }

    /* CONVERT PASSWORD TO KEY */
    if (str2key(aid, pw, &enckey) != OK)
	goto cleanup;

    /* SET KEY AS ENCRYPTION KEY */
    if (set_key(enckey) != OK)
        goto cleanup;

    /* ENCRYPT THE ENCODED KEY */
    ret = encipher(key, enciphered_key);

 cleanup:

    if (ret != OK)
	FREE_BBUF(*enciphered_key);
    FREE_BBUF(enckey);

    return(ret);
}

/****************************************************************************/
