/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * encode_key.c
 *---------------------------------------------------------------------------
 * ASN.1 encode key structure
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "crypto.h"
#include "key.h"
#include "util.h"

/*****************************************************************************
 * encode_key()
 *---------------------------------------------------------------------------
 * ASN.1 encode key structure by calling encode_key_data()
 *****************************************************************************/

int encode_key(dkey, ekey)
struct key *dkey;
struct bbuf **ekey;
{
    int ret;
    struct bbuf *bb= NULLBB, *bb2= NULLBB, *bb3= NULLBB;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (dkey == NULL_KEY || ekey == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*ekey);

    /* ENCODE THE KEY ALGID AS AN ALGORITHM IDENTIFIER */
    if (encode_algid(dkey->algid, &bb2) != OK)
	goto cleanup;

    /* ENCODE THE (ALREADY ENCODED) KEY DATA AS A BIT STRING AND APPEND */
    if (encode_bits(dkey->data, &bb) != OK)
	goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE & PREPEND LENGTH */
    if (encode_len(bb2->length, &bb) != OK)
	goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE & PREPEND SEQUENCE TAG */
    if (encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb) != OK) 
	goto cleanup;
    *ekey = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    ret = OK;

 cleanup:

    if (ret != OK)
	FREE_BBUF(*ekey);

    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    return(ret);
}

/*****************************************************************************/
