/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include <stdio.h>

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

int fgen_mic(alg, ekey, fp, mic)
int alg;
struct bbuf *ekey;
FILE *fp;
struct bbuf **mic;
{
    int r;
    struct algent *ae = NULL_ALGENT;
    struct ccbent *ce = NULL_CCBENT;
    struct key	  *key = NULL_KEY;
    
    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (fp == (FILE *)0 || mic == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*mic);

    /* GET ALGORITHM TABLE ENTRY */
    if ((ae = getalgcode(algorithms, alg, MIC|CIC|HASH)) == NULL_ALGENT) 
        return(NOTOK);

    /* GET CALLBACK TABLE ENTRY */
    if ((ce = getccbcode(callbacks, ae->code)) == NULL_CCBENT) 
        return(NOTOK);

    if (ce->fgen_Xmic == NULL_FUNC) 
        return(NOTOK);
    
    /* GENERATE MIC */
    if (ekey != NULLBB && decode_key(ekey, &key) != OK) 
        return(NOTOK);

    r = (*(ce->fgen_Xmic))(key, fp, mic);

    FREE_KEY(key);

    return(r);
}
