/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "new.h"

static int do_file();

del_key(user, pw, key)
char        **user;		/* user record */
struct bbuf  *pw;		/* password data according to access */
struct bbuf  *key;		/* ASN.1 encoded private key */
{
    char **av_key, **av_access, **av_pkey;

    if (user == NULLVP)
	return NOTOK;

    /* to delete a key the user must have access to it */

    switch (get_key(user, pw, (struct bbuf **)0)) {
    case OK:
	break;

    default:
	return NOTOK;
    }

    if ((av_access = tag_user(user, "private-key-access")) == NULLVP)
	return NOTOK;

    if ((av_pkey = tag_user(user, "public-key")) == NULLVP)
	return NOTOK;

    av_key = tag_user(user, "private-key");

    if (!strcasecmp(*(av_access+1), "file")) {
	if (av_key == NULLVP || *(av_key+1) == NULLCP || **(av_key+1) == NULLC)
	    return NOTOK;
	return do_file(*(av_pkey+1), *(av_key+1), pw, key);
    }
    else
	return NOTOK;
}

static do_file(pkey, file, pw, key)
char         *pkey;
char         *file;
struct bbuf  *pw;
struct bbuf **key;
{
    if (key != (struct bbuf **)0)
	FREE_BBUF(*key);

    return unlink(file);
}
