/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "dname.h"
#include "new.h"
#include "util.h"

pem_init(argc, argv, localopts)
int argc;
char **argv;
char ***localopts;
{
    char *cp;
    int ret = NOTOK;
    char **opts = NULLVP;
    char **av   = NULLVP;
    char *dnstr = NULLCP;
    struct bbuf *dnbb = NULLBB;

    /* check args */

    if (argc == 0 || argv == NULLVP || localopts == (char ***)0)
	goto cleanup;
    FREE_AV(*localopts);

    /* get the invocation name */

    if ((cp = RINDEX(*argv, '/')) == NULLCP)
	myname = *argv;
    else
	myname = ++cp;

    /* process tailor file */

    if ((ret = pem_tailor()) != OK)
	goto cleanup;

    /* update user_tailor with command line args and return local opts */
    
    opts = update_user(user_tailor, argv+1);
    
    /* set database */

    if ((ret = set_db()) != OK)
	goto cleanup;

    /* canonicalize user friendly distinguisged names */

    for (av = opts; av != NULLVP && *av != NULLCP && *(av+1) != NULLCP; av+=2)
	if (!strcasecmp(*av,"subject-name")||!strcasecmp(*av,"issuer-name")) {
	    if ((dnbb = str2dn(*(av+1))) == NULLBB)
		goto cleanup;
	    if ((dnstr = dn2str(dnbb)) == NULLCP)
		goto cleanup;
	    FREE(*(av+1));
	    *(av+1) = dnstr;
	    dnstr = NULLCP;
	    FREE_BBUF(dnbb);
	}

    /* set errmsg global -- not currently used */

    *errmsg = NULLC;

    /* That's all */

    *localopts = opts;
    opts = NULLVP;
    ret = OK;

 cleanup:

    FREE(dnstr);
    FREE_BBUF(dnbb);
    FREE_AV(opts);

    return ret;
}
