/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 *  tailor file processing
 ****************************************************************************/

#include "config.h"

#include <ctype.h>
#include <stdio.h>

#include "general.h"

#include "init.h"
#include "new.h"
#include "util.h"

#define	QUOTE	'\\'

static char *_tailor_value(s)
char   *s;
{
    int   i, r;
    char *bp;
    char  buffer[BUFSIZ];

    for (bp = buffer; *s != NULLC; bp++, s++)
	if (*s != QUOTE)
	    *bp = *s;
	else
	    switch (*++s) {
	    case '0':
		*bp = '\0';
		break;
	    case 'b':
		*bp = '\b';
		break;
	    case 'f':
		*bp = '\f';
		break;
	    case 'n':
		*bp = '\n';
		break;
	    case 'r':
		*bp = '\r';
		break;
	    case 't':
		*bp = '\t';
		break;

	    case NULLC: s--;
	    case QUOTE: 
		*bp = QUOTE;
		break;

	    default: 
		if (!isdigit(*s)) {
		    *bp++ = QUOTE;
		    *bp = *s;
		    break;
		}
		r = *s != '0' ? 10 : 8;
		for (i = 0; isdigit(*s); s++)
		    i = i * r + *s - '0';
		s--;
		*bp = toascii(i);
		break;
	    }
    *bp = NULLC;

    if ((bp = alloc_char(strlen(buffer) + 1)) != NULLCP)
	(void) strcpy(bp, buffer);

    return(bp);
}

int pem_tailor()
{
    FILE *fp = (FILE *)0;

    char  *file = NULLCP;
    char  *line = NULLCP;
    char  *cp, *var, *val;
    char **av = NULLVP;

    /* copy default values to user record */

    user_tailor = merge_user(user_tailor, default_tailor);

    if ((file = tailor_file()) == NULLCP)
	return OK;

    if ((fp = fopen(file, "r")) == (FILE *)0)
	goto cleanup;

    while ((var = line = getline(fp)) != NULLCP) {
	while (isspace(*var))
	    var++;

	if (*var == '#' || *var == NULLC) {
	    FREE(line);
	    continue;
	}

	if ((val = INDEX(line, ':')) == NULLCP)
	    goto nulladd;

	for (cp = val - 1; cp >= var; cp--)
	    if (isspace(*cp))
		*cp = NULLC;
	    else
		break;
	

	*val++ = NULLC;

	while (isspace(*val))
	    *val++ = NULLC;

	if ((val = _tailor_value(val)) != NULLCP)
	    goto add;

    nulladd:
	val = add2cp(NULLCP, "");

    add:
	av = add2av(av, add2cp(NULLCP, var));
	av = add2av(av, val);

	FREE(line);
    }

    user_tailor = merge_user(user_tailor, av);

 cleanup:

    FREE(file);
    FREE(line);

    FREE_AV(av);

    if (fp != (FILE *)0)
	(void) fclose(fp);

    return OK;
}
