/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/* update_user - replace the value of tags in user that match tags in av;
 * the replacement is inplace; return the tag/values not found in user
 *
 * ADDITION IS NOT PERFORMED
 *
 * this routine knows that only the tag "alias" may appear more than
 * once in a user record and such tags in av are NOT added
 */

#include "config.h"
#include "general.h"

#include "new.h"
#include "util.h"

char **update_user(user, av)
char **user, **av;
{
    char **avp, **rav = NULLVP;

    if (av == NULLVP)
	return rav;

    for ( ; *av != NULLCP && *(av+1) != NULLCP; av += 2) {

	/* if this tag/value is already present skip to next */
	if (tagval_user(user, *av, *(av+1)) != NULLVP)
	    continue;

	/* if this tag exists and is not allowed multiple times replace it */
	if (strcasecmp(*av, "alias")
	    && (avp = tag_user(user, *av)) != NULLVP) {
	    avp++;
	    FREE(*avp);
	    *avp = add2cp(NULLCP, *(av+1));
	    continue;
	}

	/* add this tag/value to the list to be returned */
	rav = add2av(rav, add2cp(NULLCP, *av));
	rav = add2av(rav, add2cp(NULLCP, *(av+1)));
    }

    return rav;
}
