/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "dname.h"
#include "oid.h"
#include "x500.h"
#include "util.h"

#define OID_FIELD_LEN	MAX_LABEL_LEN + 6
#define INDENT		"+ "

disp_dn(dn, out)
struct bbuf *dn;
char	    ***out;
{
    struct bbuf *rptr= NULLBB, *rdns= NULLBB;
    struct bbuf *aptr= NULLBB, *avas= NULLBB;
    struct bbuf *val= NULLBB;
    struct OIDentifier *oid= NULLOID;
    int j, dummy= 0;
    long u;
    char *str= NULLCP, *s= NULLCP, *oidstr= NULLCP;

    if (out == (char ***)0) 
        return(NOTOK);

    if ((dn == NULLBB) || (dn->data == NULLUCP)) {
	*out = add2av(*out, add2cp(NULLCP, "NULL_DNAME"));
        return(OK);
    }

    if (rdns_dname(dn, &rdns, READ) != OK) 
	return(NOTOK);


    for (rptr=rdns; rptr!=NULLBB; rptr=rptr->next) {
        if (avas_rdn(rptr, &avas, READ) != OK) 
	    return(NOTOK);
        for (aptr=avas; aptr!=NULLBB; aptr=aptr->next) {
	    if (decode_ava(aptr, &oid, &val) != OK) {
                *out = add2av(*out, add2cp(NULLCP, "MALFORMED AVA"));
	        continue;
	    }

            /* print the object identifier */
            str = alloc_char(OID_FIELD_LEN+1);
	    if ((oidstr=vallookup(label_attribute,
				  strlookup(oidstr_attribute,
					    sprintoid(oid)))) == NULLCP)
		oidstr = sprintoid(oid);

	    if (aptr == avas)
	        (void) sprintf(str, "%-*s: ", MAX_LABEL_LEN, oidstr);
	    else		/* Multi attribute rdn */
	        (void) sprintf(str, "%s%-*s: ", INDENT,
			       MAX_LABEL_LEN-strlen(INDENT), oidstr);

	    /* Print the value */
            switch (val->data[0] & TAG_MASK) {
	    case DEFN_PRTS:
	        if (decode_prts(val, &s, &dummy) != OK)
		    str = add2cp(str, "unable to decode string");
	        else
		    str = add2cp(str, s);
	        *out = add2av(*out, str);
	        str = NULLCP;
	        break;

	    case PRIM_INT:
	        if (decode_int(val, &j, &dummy) != OK)
		    str = add2cp(str, "unable to decode integer");
	        else
		    str = addint2cp(str, j);
	        *out = add2av(*out, str);
	        str = NULLCP;
	        break;

	    case DEFN_T61S:
	        if (decode_t61s(val, &s, &dummy) != OK)
		    str = add2cp(str, "unable to decode string");
	        else {
		    str = add2cp(str, s);
		    str = add2cp(str, " : ");
		    str = add2cp(str, vallookup(label_charset, DEFN_T61S));
	        }
	        *out = add2av(*out, str);
	        str = NULLCP;
	        break;

	    case DEFN_UTCT:
	        if (decode_utct(val, &u, &dummy) != OK)
		    str = add2cp(str, "unable to decode utct");
	        else
		    str = addlong2cp(str, u);
	        *out = add2av(*out, str);
	        str = NULLCP;
	        break;

	    default:
	        str = addhex2cp(str, val->data, val->length);
	        *out = add2av(*out, str);
	        str = NULLCP;
            }
        }
    }

    FREE_BBUFS(avas);
    FREE_BBUFS(rdns);

    return(OK);
}

int fdisp_dn(fp, dn)
FILE *fp;
struct bbuf *dn;
{
    int ret;
    char **av = NULLVP;
    char **tav = NULLVP;

    if ((ret = disp_dn(dn, &av)) != OK)
	return(ret);
    if ((tav = av) != NULLVP) {
	while (*tav != NULLCP)
	    (void) fprintf(fp, "%s\n", *tav++);
	FREE_AV(av);
    }
    return(OK);
}
