/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "cryptocb.h"
#include "new.h"
#include "user_list.h"
#include "util.h"


static int encipher_dek(key, dek, edek)
struct bbuf *key;
struct bbuf *dek;
struct bbuf **edek;
{
    int ret = NOTOK;
    struct bbuf *dekbb = NULLBB;

    if (dekdata2bbuf(dek, &dekbb) != OK)
	return(ret);

    /* Set public key */

    if (set_key(key) != OK)
        goto cleanup;

    /* Encipher DEK with public key */

    if (encipher(dekbb, edek) != OK)
        goto cleanup;

    ret = OK;

 cleanup:
    FREE_BBUF(dekbb);

    return(ret);
}


int pem_encrypt(recip_users, confalg, iocbs)
struct user_list *recip_users;
int confalg;
struct cbstruct *iocbs;
{

    struct bbuf *dekbb = NULLBB;
    struct bbuf *edek = NULLBB;
    struct bbuf *eedek = NULLBB;

    struct user_list *recip_user = NULLUL;
    
    struct bbuf *recip_key = NULLBB;
    struct bbuf enckey;

    struct algid *sig_aid = NULL_ALGID;
    struct algent *dek_ae = NULL_ALGENT;
    struct algent *ik_ae = NULL_ALGENT;

    char *dekstring = NULLCP;
    char *idstring = NULLCP;
    char *pubkey = NULLCP;

    int ret = NOTOK;

    /* Check args */

    if (recip_users == NULLUL || iocbs == NULL_IOCBS
	|| iocbs->in_data == NULL_INCB || iocbs->out_hdrs == NULL_OUTCB) 
	goto cleanup;

    if ((dek_ae = getalgcode(algorithms, confalg & (CRYPTO_MASK|MODE_MASK),
			     DEK)) == NULL_ALGENT) {
	(void) cp2cb(iocbs->out_errs, "Unsupported encryption algorithm");
	goto cleanup;
    }

    /* Output Version header */

    (void) cp2cb(iocbs->out_hdrs, "Version: 5\n");

    /* Generate DEK-Info header */

    if (gen_key(dek_ae->code, 0, &dekbb, (struct bbuf **)0) != OK) {
	(void) cp2cb(iocbs->out_errs, "Unable to generate DEK");
	goto cleanup;
    }
    (void) cp2cb(iocbs->out_hdrs, "DEK-Info: ");
    (void) cp2cb(iocbs->out_hdrs, dek_ae->hdrstr);
    if (adddekparms2cp(dekbb, &dekstring)) {
	(void) cp2cb(iocbs->out_errs, "Unable to construct DEK parameters");
	goto cleanup;
    }
    (void) cp2cb(iocbs->out_hdrs, dekstring);
    (void) cp2cb(iocbs->out_hdrs, "\n");
	 
    /* Generate Recipient-ID & Key-Info: headers */

    for (recip_user = recip_users; recip_user != NULLUL;
	 recip_user = recip_user->next) {

	/* Extract information from user record */

        if ((pubkey = key_user(recip_user->user)) == NULLCP)  {
	    (void) cp2cb(iocbs->out_errs, "Public key unavailable");
	    goto cleanup;
	}
	enckey.data = (unsigned char *)pubkey;
	enckey.length = strlen(pubkey);
	bdecode(&enckey, &recip_key);
	algid_key(&recip_key, &sig_aid, READ);
	FREE(pubkey);

	/* Generate Recipient-ID header */

	(void) cp2cb(iocbs->out_hdrs, "Recipient-ID: ");
	idstring = id_user(recip_user->user, 0, 0);
	(void) cp2cb(iocbs->out_hdrs, idstring);
	(void) cp2cb(iocbs->out_hdrs, "\n");
	FREE(idstring);
    
	/* Encrypt DEK for recipient */

	if ((ik_ae = getalgcode(algorithms, sig_aid->alg, IK))
	    == NULL_ALGENT) {
	    (void) cp2cb(iocbs->out_errs,
			 "Unsupported recipient public key algorithm");
	    goto cleanup;
	}
	if (encipher_dek(recip_key, dekbb, &edek)) {
	    (void) cp2cb(iocbs->out_errs,
			 "Unable to encrypt DEK for recipient");
	    goto cleanup;
	}

	/* Generate Key-Info header */
    
	(void) cp2cb(iocbs->out_hdrs, "Key-Info: ");
	(void) cp2cb(iocbs->out_hdrs, ik_ae->hdrstr);
	(void) cp2cb(iocbs->out_hdrs, ",");
	(void) bencode(edek, &eedek);
	(void) iocbs->out_hdrs(eedek);
	(void) cp2cb(iocbs->out_hdrs, "\n");
    }

    /* Encrypt data */

    if (set_key(dekbb) != OK) {
	(void) cp2cb(iocbs->out_errs, "Unable to use DEK for encryption");
	goto cleanup;
    }

/*  if (cbencipher(iocbs->in_data, iocbs->out_data) != OK) */
    if (cbencipher_des(iocbs->in_data, iocbs->out_data) != OK) {
	(void) cp2cb(iocbs->out_errs, "Unable to encrypt data");
	goto cleanup;
    }

    ret = OK;

 cleanup:

    FREE_BBUF(dekbb);
    FREE_BBUF(edek);
    FREE_BBUF(eedek);
    FREE_BBUF(recip_key);

    FREE(pubkey);
    FREE_ALGID(sig_aid);
    FREE(dekstring);

    return(ret);
}
