/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "new.h"
#include "util.h"

pem_keysign(signer, signee, serial, iocbs)
char **signer, ***signee;
char *serial;
struct cbstruct *iocbs;
{
    int ret = NOTOK;
    int signcert;
    char *signerpub = NULLCP;
    char *trustedv = NULLCP;
    char **trustedp = NULLVP;
    char **signercert = NULLVP;
    char **signeecert = NULLVP;
    char **validopt = NULLVP;
    char **exploded = NULLVP;
    char **alias = NULLVP;
    long begin = 0L;
    long end = 0L;
    long valid = 0L;
    struct bbuf *signerbb = NULLBB;
    struct bbuf *signeebb = NULLBB;
    struct bbuf *privkey = NULLBB;
    struct bbuf *pw = NULLBB;
    struct bbuf *serialbb = NULLBB;
    struct bbuf *dname = NULLBB;
    struct bbuf *trustedbb = NULLBB;
    struct bbuf bb;
    struct bbuf *mic = NULLBB;
    struct bbuf *emic = NULLBB;
    struct bbuf *smic = NULLBB;
    struct algid *mic_aid = NULL_ALGID;
    struct algent *mic_ae = NULL_ALGENT;
    struct algent *sig_ae = NULL_ALGENT;

    /* quick arg check */

    if (iocbs == NULL_IOCBS || signer == NULLVP
	|| signee == (char ***)0 || *signee == NULLVP)
	goto cleanup;

    /* now make sure we really have what we need */

    signcert = serial != NULLCP;

    if (signcert) {
	if ((signercert = tag_user(signer, "certificate")) == NULLVP
	    || (signeecert = tag_user(*signee, "certificate")) == NULLVP) {
	    (void) cp2cb(iocbs->out_errs,
			 "missing signer and/or signee certificate.\n");
	    goto cleanup;
	}
    }
    else {
	if ((signerpub = key_user(signer)) == NULLCP) {
	    (void)cp2cb(iocbs->out_errs, "missing signer public key.\n");
	    goto cleanup;
	}
    }

    /* check status of signer's private key */

    /* Make sure we have access to the signer's private key */

 pwagain:
    switch (get_key(signer, pw, &privkey)) {
    case OK:
	/* great, no problems */
	break;

    case EINVAL:
	/* okay, we need password; can we get it */
	if ((pw = get_password(iocbs, 0)) == NULLBB)
	    goto cleanup;
	goto pwagain;

    case NOTOK:
	/* who knows; the signer loses */
	cp2cb(iocbs->out_user, "Unable to access signer's private key.\n");
	goto cleanup;
    }
    if (set_key(privkey) != OK) {
	cp2cb(iocbs->out_user, "Unable to use signer's private key.\n");
	goto cleanup;
    }

    /* do cert-specific procecessing */

    if (signcert) {

	/*  Decode certificates */

	bb.data = (unsigned char *) *(signercert+1);
	bb.length = strlen(bb.data);
	if (bdecode(&bb, &signerbb) != OK) {
	    (void)cp2cb(iocbs->out_errs,
			"Unable to decode signer's certificate.\n");
	    goto cleanup;
	}
	
	bb.data = (unsigned char *) *(signeecert+1);
	bb.length = strlen(bb.data);
	if (bdecode(&bb, &signeebb) != OK) {
	    (void)cp2cb(iocbs->out_errs,
			"Unable to decode certificate to be signed.\n");
	    goto cleanup;
	}

	/* Signer's subject name becomes signed's issuer name */

	if ((subject_cert(&signerbb, &dname, READ)) != OK) {
            (void)cp2cb(iocbs->out_errs,
                        "Unable to read signer's subject name.\n");
            goto cleanup;
        }
	if ((issuer_cert(&signeebb, &dname, WRITE)) != OK) {
            (void)cp2cb(iocbs->out_errs,
                        "Unable to insert issuer name in certificate.\n");
            goto cleanup;
        }

	/* Insert new serial number */

	if ((serialbb = hex2bin(serial)) == NULLBB) {
	    (void)cp2cb(iocbs->out_errs,
                        "Unable to convert hex serial number to binary.\n");
            goto cleanup;
	}
	if (serial_cert(&signeebb, &serialbb, WRITE) != OK) {
            (void)cp2cb(iocbs->out_errs,
                        "Unable to insert serial number in certificate.\n");
            goto cleanup;
        }

	/* Insert new validity period */
	
	begin = TIME();
	if ((validopt = tag_user(user_tailor, "cert-period")) != NULLVP)
	    valid = str2valid(*(validopt+1));
	end = begin + valid;
        if (valid_cert(&signeebb, &begin, &end, WRITE) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "unable to insert validity period in certificate\n");
            goto cleanup;
        }

    }

    /* Perform the signature & update user record */

    if (signcert) {

	/* sign_cert() takes care of the work */

	if (sign_cert(&signeebb, privkey) != OK) {
	    (void) cp2cb(iocbs->out_errs, "Unable to sign certificate.\n");
            goto cleanup;
	}

	/* printably encode new cert and replace old in user record */

	FREE(*(signeecert+1));
	if ((*(signeecert+1) = addencbb2cp(NULLCP, signeebb)) == NULLCP) {
            (void) cp2cb(iocbs->out_errs, 
			 "Unable to encode new certificate.\n");
            goto cleanup;
        }

	/* for completeness and consistency, explode certificate and merge 
	   components into user record */

	if ((exploded = explode_cert(*(signeecert+1))) == NULLVP) {
            (void) cp2cb(iocbs->out_errs, 
			 "Unable to explode the new certificate.\n");
            goto cleanup;
	}
	if ((*signee = merge_user(*signee, exploded)) == NULLVP) {
            (void) cp2cb(iocbs->out_errs, 
			 "Unable to update user record with certificate.\n");
            goto cleanup;
	}

    }
    else {

	/* Place all tag-value pairs except trusted in sorted order in bbuf */

	trustedbb = trustbb_user(*signee);

	/* Hash (MD5) the printably encoded public key */

	if ((mic_ae = getalgcode(algorithms, MD5, MIC)) == NULL_ALGENT) {
	    (void) cp2cb(iocbs->out_errs, 
			 "Unsupported hash algorithm");
	    goto cleanup;
	}

	gen_md5(NULL_KEY, trustedbb, &mic);
	
	/* ASN.1 encode the MIC and MIC algid */
	
	mic_aid = alloc_algid();
	mic_aid->alg = mic_ae->code;
	if (encode_mic(mic, mic_aid, &emic) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "Unable to encode MIC of user record.\n");
	    goto cleanup;
	}
	FREE_ALGID(mic_aid);
	FREE_BBUF(mic);

	bb.data = (unsigned char *) signerpub;
	bb.length = strlen (bb.data);
	bdecode(&bb, &signerbb);
	
	if (algid_key(&signerbb, &mic_aid, READ) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "Unable to decode signer's public key");
	    goto cleanup;
	}
	sig_ae = getalgcode(algorithms, mic_aid->alg, ANY);

	/* Encrypt the MIC to produce the signature */
	
	if (sign(emic, &smic) != OK) {
            (void)cp2cb(iocbs->out_errs, "Unable to sign user record.\n");
	    goto cleanup;
	}
	

	/* Create & merge trusted value */

	if ((alias = tag_user (signer, "alias")) == NULLVP) {
	}
	trustedv = add2cp(NULLCP, *(alias+1));
	trustedv = add2cp(trustedv, ",");
	trustedv = add2cp(trustedv, mic_ae->hdrstr);
	trustedv = add2cp(trustedv, ",");
	trustedv = add2cp(trustedv, sig_ae->hdrstr);
	trustedv = add2cp(trustedv, ",");
	trustedv = addencbb2cp(trustedv, smic);
	trustedp = add2av(NULLVP, add2cp(NULLCP, "trusted"));
	trustedp = add2av(trustedp, trustedv);
	trustedv = NULLCP;
	if ((*signee = merge_user(*signee, trustedp)) == NULLVP) {
            (void)cp2cb(iocbs->out_errs,
			"Unable to update user record with signature.\n");
            goto cleanup;
	}
    }

    ret = OK;

 cleanup:

    FREE(signerpub);

    FREE_AV(trustedp);

    FREE_BBUF(trustedbb);
    FREE_BBUF(privkey);
    FREE_BBUF(dname);
    FREE_BBUF(serialbb);
    FREE_BBUF(signerbb);
    FREE_BBUF(signeebb);

    return ret;
}
