/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "util.h"

bbufinc(bbuf)
struct bbuf *bbuf;
{
    unsigned char *ptr;

    if (bbuf == NULLBB) 
	return(NOTOK);

    if (bbuf->length == 0) {
	bbuf->data = alloc_uchar(sizeof(unsigned char));
	bbuf->length = sizeof(unsigned char);
    }

    for (ptr = &bbuf->data[bbuf->length-1]; ; ptr--) {
	(*ptr)++;
	if (*ptr != 0x00)
	    break;
	if (ptr == bbuf->data) {
	    if (_extend(bbuf) != OK)
		return(NOTOK);
    	    bbuf->data[0] = 0x01;
	    break;
	}
    }

    if (bbuf->data[0] > 0x7F && _extend(bbuf) != OK)
	return(NOTOK);

    return(OK);
}

static int _extend(bbuf)
struct bbuf *bbuf;
{
    unsigned char *tmp= NULLUCP;

    tmp=alloc_uchar(bbuf->length+sizeof(unsigned char));
    if (bbuf->length > sizeof(unsigned char))
        BCOPY(bbuf->data, tmp+sizeof(unsigned char), bbuf->length);
    bbuf->length += sizeof(unsigned char);
    FREE_UCHAR(bbuf->data);
    bbuf->data = tmp;
    return(OK);
}
