/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "util.h"

char **fold(str, len, pre)
char *str;
int len;
char *pre;
{
    register char *cp, c, **av = NULLVP, *string;
    register int s_len, p_len = 0;

    if (str == NULLCP)
	return(NULLVP);

    if (*str == NULLC)
	return(add2av(av, add2cp(NULLCP, str)));

    if (len > (s_len = strlen(str)))
	return(add2av(av, add2cp(NULLCP, str)));

    /* pre may very well be NULLCP or a NULLC */

    if (pre != NULLCP)
	p_len = strlen(pre);
    else
	pre = "";		/* makes the code below cleaner */

    for ( ; len < s_len + p_len; s_len = strlen(str = cp)) {
	if (av != NULLVP)
	    cp = str + len - p_len;
	else
	    cp = str + len;
	while (p_len && !strncmp(cp, pre, p_len)) {
	    if ((cp -= p_len) <= str) {
		if (av != NULLVP) {
		    string = add2cp((string = NULLCP), pre);
		    string = add2cp(string, str);
		}
		else
		    string = add2cp(NULLCP, str);
		av = add2av(av, string);
		return(av);
	    }
	}
	c = *cp;
	*cp = NULLC;
	if (av != NULLVP) {
	    string = add2cp((string = NULLCP), pre);
	    string = add2cp(string, str);
	}
	else
	    string = add2cp(NULLCP, str);
	av = add2av(av, string);
	*cp = c;
    }

    if (s_len <= 0)
	return(av);

    if (av != NULLVP) {
	string = add2cp((string = NULLCP), pre);
	string = add2cp(string, str);
    }
    else
	string = add2cp(NULLCP, str);
    av = add2av(av, string);

    return(av);
}
