  if __cpu
; --------------------------------------------------------------------------
; CPU testing added v0.3.5 - Note this only tests for presence of 386, since
; we do	not use	486 or latter instructions.

; A different CPU testing routine should be used if and	when 486- or 586-
; specific code	is added to the	driver...

; RDTSC	Caveat:	Allegedly some 486s support timestamp counter while some
;	586s may not.  If implementing RDTSC (0Fh 31h),	first try to set
;	bit 21 of EFLAGS. If it	sets, processor	supports CPUID instruction
;	(some latter 386 and 486s support this).  Set eax to 1,	then do	a
;	CPUID... bit 4 of edx should indicate if timestamp counter.

;cpuid	 MACRO		 ; for older assmeblers	w/out .586 instructs
;	 DB 0Fh, A2h
;cpuid	 ENDM

TestCPU		proc	near	; rewritten v0.3.6 by Colin Plumb
		push	sp
		pop	ax
		sub	ax, sp
		jne	SHORT error

		mov	al, 4
		shl	al, 1	; Expected to produce ac = 0 on	a '286
		lahf
		shl	al, 1	; Expected to produce ac = 1 on	a '286
		mov	al, ah
		lahf
		xor	al, ah	; Xor the flags	together to detect the difference
		mov	ah, al	; Clear	ah if al is clear, leave Z flag	alone
		jz	SHORT noerror
  error:
		Printf	<__cpu OFFSET CPUError>
		mov	ax, -1	; make sure ax != 0
  noerror:
		ret
TestCPU		endp

; --------------------------------------------------------------------------
CPUError LABEL	BYTE
	DB '%d86 or later processor is required!', CR, LF, 0
  endif
