#include <sys/socket.h>
#include <sys/un.h>

#ifndef HAVE_DAEMON
int daemon(int nochdir, int noclose);
#endif

typedef struct {
  double rate;
  unsigned int badness;
  unsigned int sticky_badness;
  char *path;
  char *args[5];
  char *cmdstring;
} entropy_source_t;

extern int randsavefd;
extern int debug;
extern int devnull;

void parse_configfile(const char *cmdpath, entropy_source_t **entropy_source);

void main_loop(int service_socket, struct sockaddr_un sockun,
	       time_t seed_stat_interval, time_t seed_ext_interval,
	       entropy_source_t *entropy_source, int max_gatherer_bytes);

void close_seedfile(void);

void seed_internal(void);
void seed_stat(void);

void rand_add(void *buf, int num, double entropy);
int rand_bytes(unsigned char *buf, int num);
int rand_pool(void);
