
#ifdef LINUX2
#define HAVE_DAEMON
#define HAVE_GETRUSAGE
#define PATH_TMP	"/tmp"
#define PATH_VAR_TMP	"/var/tmp"
#define PATH_PASSWD	"/etc/passwd"
#define PATH_WTMP	"/var/log/wtmp"
#define PATH_UTMP	"/var/run/utmp"
#define PATH_SYSLOG	"/var/log/messages"
#define PATH_MAILLOG	"/var/log/mail"
#endif

#ifdef HPUX10
#define HAVE_GETRUSAGE
#define PATH_TMP	"/tmp"
#define PATH_VAR_TMP	"/var/tmp"
#define PATH_PASSWD	"/etc/passwd"
#define PATH_WTMP	"/var/adm/wtmp"
#define PATH_UTMP	"/etc/utmp"
#define PATH_SYSLOG	"/var/adm/syslog/syslog.log"
#define PATH_MAILLOG	"/var/adm/syslog/mail.log"
#endif

#ifdef TRU64
#define HAVE_GETRUSAGE
#define SIZEOF_IS_LONG_INT
#define PATH_TMP	"/tmp"
#define PATH_VAR_TMP	"/var/tmp"
#define PATH_PASSWD	"/etc/passwd"
#define PATH_WTMP	"/var/adm/wtmp"
#define PATH_UTMP	"/var/adm/utmp"
#define PATH_SYSLOG	"/var/adm/syslog.dated/current/daemon.log"
#define PATH_MAILLOG	"/var/adm/syslog.dated/current/mail.log"
#endif

#ifdef SUNOS
#define HAVE_GETRUSAGE
#define PID_T_IS_LONG_INT
#define PATH_TMP        "/tmp"
#define PATH_VAR_TMP    "/var/tmp"
#define PATH_PASSWD     "/etc/passwd"
#define PATH_WTMP       "/var/adm/wtmp"
#define PATH_UTMP       "/etc/utmp"
#define PATH_SYSLOG     "/var/log/syslog"
#endif

#ifdef NEXTSTEP3
/* not supported */
#define SA_RESTART 0
#define O_RSYNC 0
/* select, ftruncate, fchmod */
#include <libc.h>
/* in ansi string.h but undefined in -posix */
#define bzero(b,len) memset(b,0,len)
#define SIZEOF_IS_LONG_INT
#define HAVE_GETRUSAGE
#define PATH_TMP        "/private/tmp"
#define PATH_PASSWD     "/etc/passwd"
#define PATH_WTMP       "/private/adm/wtmp"
#define PATH_UTMP       "/private/etc/utmp"
#define PATH_SYSLOG     "/private/adm/messages"
#endif

#ifdef IRIX62
#define HAVE_GETRUSAGE
#define PID_T_IS_LONG_INT
#define PATH_TMP        "/tmp"
#define PATH_VAR_TMP	"/var/tmp"
#define PATH_PASSWD     "/etc/passwd"
#define PATH_WTMP       "/var/adm/wtmpx"
#define PATH_UTMP       "/var/adm/utmpx"
#define PATH_SYSLOG     "/var/adm/SYSLOG"
#endif

#ifdef UNIXWARE7
#define HAVE_GETRUSAGE
#define O_RSYNC		0
#define PATH_TMP        "/tmp"
#define PATH_VAR_TMP    "/var/tmp"
#define PATH_PASSWD     "/etc/passwd"
#define PATH_WTMP       "/var/adm/wtmp"
#define PATH_UTMP       "/etc/utmp"
#define PATH_SYSLOG     "/var/adm/syslog"
#endif

#ifndef RANDSAVENAME
#define RANDSAVENAME	"/etc/prngd-seed"
#endif
#ifndef CONFIGFILE
#define CONFIGFILE	"/etc/prngd.conf"
#endif

/*
 * If not available, we cannot perform the check and will always succeed.
 */
#ifndef S_ISSOCK
#define S_ISSOCK(m)	(1)
#endif

/*
 * Some platforms don't have the SHUT_* macros
 */
#ifndef SHUT_RDWR
#define SHUT_RDWR	2
#endif

/*
 * The pool size of the OpenSSL PRNG
 */
#define PRNGD_STATE_SIZE	1024

#ifndef SEED_STAT_INTERVAL
#define SEED_STAT_INTERVAL	17
#endif
#ifndef SEED_EXT_INTERVAL
#define SEED_EXT_INTERVAL	49
#endif

#define MAX_GATHERER_BYTES	100000

#define ENTROPY_NEEDED		20

/*
 * Define the minimum of entropy we want to have in the pool on a regular
 * basis. If we come below this threshold, the gatherer processes are fired
 * up continously until we come back over the threshold.
 */
#ifndef THRESHOLD
#define THRESHOLD		4
#endif
#define ENTROPY_THRESHOLD	(ENTROPY_NEEDED * 8 * THRESHOLD)
