#include <stdlib.h>
#include <fcntl.h>
#include "prngd.h"

/*
 * Set or remove "non_blocking" flag for file descriptor.'
 * Inspired by non_blocking() function in Wietse Venema's Postfix.
 * On failure, there is nothing left what we can do.
 */
#ifdef FNDELAY
#define PATTERN FNDELAY
#else
#define PATTERN O_NONBLOCK
#endif

void non_blocking(int fd, int on)
{
  int flags;

  if ((flags = fcntl(fd, F_GETFL, 0)) == -1)
    abort();
  if (fcntl(fd, F_SETFL, on ? flags | PATTERN : flags & ~PATTERN) == -1)
    abort();
}
