/*
 * STAN - Stream Analyser
 * Copyright (c) 2001 Konrad Rieck <kr@r0q.cx>
 * The Roqefellaz, http://www.r0q.cx/stan
 *
 * This file handles all things that deal with bit analysis. Those functions
 * are needed if we measure the power of a pseudo random number generator.
 * $Id: bits.c,v 1.4 2001/03/01 00:15:40 kr Exp $
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include <stan.h>
#include <data.h>
#include <stats.h>
#include <bintree.h>

size_t run = 1;
int bit = -1;

extern bnode_t *bintree;

double sum_false, sum_true, bits_ratio;

int get_bit(byte_t b, int pos)
{
    if (b & (int) pow(2, pos))
	return 1;
    return 0;
}

void analyse_byte(byte_t b)
{
    int i;
    for (i = 7; i >= 0; i--) {
	if (bit < 0) {
	    bit = get_bit(b, i);
	    run = 1;
	} else if (bit == get_bit(b, i))
	    run++;
	else {
	    binsert(&bintree, run, bit);
	    run = 1;
	    bit = get_bit(b, i);
	}
    }
}

void calc_sum_bits(bnode_t *bnode) {
   sum_true+=bnode->count_true*bnode->run;
   sum_false+=bnode->count_false*bnode->run;
}

void print_runs_ratios() {
   bnode_t **bnode, **succ;
   double sum_bnode, sum_succ;
   int i;
   
   printf("\n   Ratio of runs of a length to the next length.\n");
   
   printf("   Length: ");
   bnode=bmin(&bintree);
   succ=bsuccessor(bnode);
   for(i=0; i<8 && *bnode && *succ ; i++) {
      printf("%2d ->%2d ",(*bnode)->run,(*succ)->run);
       bnode=succ;
       succ=bsuccessor(bnode);
   }   
   
   
   printf("\n   Ratio:  ");      
   bnode=bmin(&bintree);
   succ=bsuccessor(bnode);
   for(i=0; i<8 && *bnode && *succ ; i++) {
      sum_bnode=(*bnode)->count_true+(*bnode)->count_false;
      sum_succ=(*succ)->count_true+(*succ)->count_false;
      printf(" %2.2f   ",sum_bnode/sum_succ);       
      bnode=succ;
      succ=bsuccessor(bnode);      
   }
   
   printf("\n\n");
   printf("   Ratio of 1/0 runs for each length.\n");

   printf("   Length: ");
   bnode=bmin(&bintree);   
   for(i=0; i<8 && *bnode; i++) {
      printf(" %d      ",(*bnode)->run);
      bnode=bsuccessor(bnode);
   }   
      
   printf("\n   Ratio:  "); 
   bnode=bmin(&bintree);     
   for(i=0; i<8 && *bnode ; i++) {
      printf(" %2.2f   ",(double)(*bnode)->count_true/(*bnode)->count_false);       
      bnode=bsuccessor(bnode);      
   }
   
   printf("\n");
   
}

void calc_bit_ratio() {
   sum_true=0;
   sum_false=0;
   
   btraverse(&bintree,calc_sum_bits,inorder);
   bits_ratio=sum_true/sum_false;
}

void print_bits_stats() {
   printf("Bit statistics for the stream, bytes %d, bits %d\n", size_data(),
          size_data()*8);

   printf("   Total runs %d(1)/%d(0), different runs %d(1)/"
          "%d(0)\n", 
          bsize_total(&bintree,1),bsize_total(&bintree,0),
          bsize_bnodes(&bintree,1),bsize_bnodes(&bintree,0));
          

   printf("   Shortest run: ");
   print_double((*bmin(&bintree))->run);
   printf("\n");
   printf("   Longest run:  ");
   print_double((*bmax(&bintree))->run);
   printf("\n");

   calc_bit_ratio();
   printf("   Bit ratio:    ");
   print_double(bits_ratio);
   printf(" = %d(1)/%d(0) ",(int)sum_true, (int)sum_false);  
   printf("\n");

   print_runs_ratios();
}
