/*
 * STAN - Stream Analyser
 * Copyright (c) 2001 Konrad Rieck <kr@r0q.cx>
 * The Roqefellaz, http://www.r0q.cx/stan
 *
 * This file handles everything dealing with the analysed pattern. Initialy
 * it was much better, but most functions could be removed. 
 * $Id: pattern.c,v 1.2 2001/02/28 16:30:25 kr Exp $
 */

#include <stdio.h>
#include <ctype.h>

#include <stan.h>
#include <treap.h>
#include <pattern.h>
#include <config.h>

void print_pattern(tnode_t * n, size_t patlen)
{
    if (!n || !n->pattern || !n->count)
	return;
    print_byte(n->pattern, patlen);
    printf(": 0x%.8x", n->count);
}

void print_byte(byte_t * b, size_t patlen)
{
    size_t i;

    if (!b)
	return;

    printf("0x");

    for (i = 0; i < patlen; i++)
	printf("%.2x", b[i]);

    printf("(");

    for (i = 0; i < patlen; i++)
	printf("%c", isprint(b[i]) ? b[i] : ' ');

    printf(")");
}
