/* rcrypt.c
 *
 * jojo@farm9.com -- file encryption using Rijndael, 256 bit key
 *
 *   Handles odd file sizes using padding, creates a header that
 *   has file size and some random numbers.  Why?  Encryption blocks
 *   are 16 bytes, so resulting file size always a multiple of 16
 *   bytes.  Weird side effect of header -- encrypting same
 *   file with same key results in totally different output.
 *
 *   Hardcoded CBC mode with 256 bit key.  
 *
 *  6 Apr 2001 -- added features suggested by Mike Cronnelly, allowing
 *    input from stdin (so you can pipe input)
 */
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/stat.h>

#ifdef WIN32
#include <fcntl.h>
#include <io.h>
#endif

#include "rijndael-api-fst.h"


// 
// taken directly from rijndaeltest-fst.c
//
void rand_init(void)
{
    srand(time(NULL));
}

word32 rand_word32(void)
{
    return
        ((word32)(rand() >> 7) << 24) | 
        ((word32)(rand() >> 7) << 16) | 
        ((word32)(rand() >> 7) << 8) | 
        (word32)(rand() >> 7);
}


// 
// jojo@farm9.com -- OK, someone else probably did this already,
//   but I couldn't find it...
//

static void usage() {
  printf( "To encrypt a file:\n" );
  printf( "       rcrypt -e <key> [<infile> [<outfile>]]\n" );
  printf( "To decrypt a file:\n" );
  printf( "       rcrypt -d <key> [<infile> [<outfile>]]\n" );
  printf( "To use Rijndael to generate a password of <n> characters:\n" );
  printf( "       rcrypt -k <key> <infile> <n>\n" );
}

static BYTE convertKey( char k ) {
  int kval = k % 16;
  if ( kval < 10 ) {
    return( '0' + kval );
  } else {
    return( kval - 10 + 'A' );
  }
}

static void populateKeyMaterial( char* text, BYTE* key ) {
  char* textscanner = text;
  int i;
  for ( i = 0; i < MAX_KEY_SIZE; i++ ) {
    *key++ = convertKey( *textscanner );
    textscanner++;
    if ( *textscanner == 0 ) {
      textscanner = text;
    }
  }
  *key = 0;
}



char* pwchars = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+^#$()&@%=_[]{}<>|01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+^#$()&@%=_[]{}<>|01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+^#$()&@%=_[]{}<>|01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV";
int main ( int argc, char* argv[] ) {
  int r;
  BYTE block[4*4];
  BYTE prevblock[4*4];
  int hasprevblock = 0;
  BYTE prevblock1[4*4];
  int hasprevblock1 = 0;
  BYTE keyMaterial[320];
  keyInstance keyInst;
  cipherInstance cipherInst;
  BYTE direction;
  BYTE header[100];
  FILE* fpin = stdin;
  FILE* fpout = stdout;
  int size = 0;
  int prevsize = 0;
  int fsize;
  int writesize;
  int genpw = 0;
  int ii;
#ifdef WIN32
  struct _stat statbuf;
  int result;
#else
  struct stat statbuf;
#endif

  if ((argc != 3) && ( argc != 4 ) && ( argc != 5 )) {
    usage();
    exit(1);
  }
  if ( strcmp( argv[1], "-e" ) == 0 ) {
    direction = DIR_ENCRYPT;
  } else if ( strcmp( argv[1], "-d" ) == 0 ) {
    direction = DIR_DECRYPT;
  } else if ( strcmp( argv[1], "-k" ) == 0 ) {
    direction = DIR_ENCRYPT;
    genpw = atoi(argv[4]);
  } else {
    usage();
    exit(1);
  }
  if ( argc > 3 ) {
    fpin = fopen( argv[3], "rb" );
    if ( fpin == NULL ) {
      printf("Hey! can't read input file\n" );
    }
#ifdef WIN32
  } else {
	  result = _setmode( _fileno( stdin ), _O_BINARY );
#endif
  }
  if (!genpw ) {
	  if ( argc == 5 ) {
		  fpout = fopen( argv[4], "wb" );
		  if ( fpout == NULL ) {
			  printf( "** ERROR, cannot open output file '%s'\n", argv[4] );
			  exit(1);
		  }
#ifdef WIN32
	  } else {
		  result = _setmode( _fileno( stdout ), O_BINARY );
#endif
	  }
  }

  populateKeyMaterial( argv[2], &keyMaterial[0] );

  r = makeKey(&keyInst, direction, 256, keyMaterial);
  if ( r != TRUE ) {
    printf( "** ERROR on makeKey: %d\n", r );
    exit(1);
  }
  r = cipherInit (&cipherInst, MODE_CBC, NULL);
  if ( r != TRUE ) {
    printf( "** ERROR on cipherInit: %d\n", r );
    exit(1);
  }

  if ( direction == DIR_ENCRYPT ) {
    // make header <file size> <random number>
    memset( block, 0, 16 );
    rand_init();
    if (( argc > 3 ) && 
#ifdef WIN32
        (( _stat( argv[3], &statbuf ) == -1 ) || ( fpin == NULL ))) {
#else
        (( stat( argv[3], &statbuf ) == -1 ) || ( fpin == NULL ))) {
#endif
        printf( "** ERROR, file '%s' not found **\n", argv[3] );
        exit(1);
    } else if ( argc > 3 ) {
        sprintf( header, "%d %d %d %d", 
           (int)statbuf.st_size, rand_word32(), rand_word32(), rand_word32() );
    } else {
        sprintf( header, "zzz %d %d %d", 
           rand_word32(), rand_word32(), rand_word32() );
    }
    memcpy( &block[0], &header[0], 16 );
    r = blockEncrypt(&cipherInst, &keyInst, block, 128, block);
    if ( genpw ) {
        printf( "Password: " );
        for ( ii = 0; ii < genpw; ii++ ) {
          printf("%c", *(pwchars + block[ii] ));
        }
        printf("\n");
        exit(1);
    }
    if ( fwrite( block, 16, 1, fpout ) != 1 ) {
        printf( "** ERROR writing output header\n" );
        exit(1);
    }
    // now we have that header out of the way, 
    // read in 16 byte blocks, encrypt each one
    while ( 1 ) {
        memset( block, 0, 16 );
        size = fread( block, 1, 16, fpin );
        if ( size > 0 ) {
            prevsize = size;
            blockEncrypt( &cipherInst, &keyInst, block, 128, block );
            if ( fwrite( block, 16, 1, fpout ) != 1 ) {
                printf( "** ERROR writing data\n" );
                exit( 1 );
            }
        } else {
            break;
        }
    }
    if ( argc > 3 ) {
        fclose( fpin );
    } else {
        memset(block, 0, 16);
        sprintf(block, "%d ", prevsize);
        blockEncrypt(&cipherInst, &keyInst, block, 128, block);
        if ( fwrite( block, 16, 1, fpout ) != 1 ) {
            printf( "** ERROR writing data\n" );
            exit( 1 );
        }
    }
    if ( argc > 4 ) {
        fclose( fpout );
    }
  } else {
    // decrypt header which is <file size> <random number>
    if ( fread( block, 16, 1, fpin ) != 1 ) {
        printf( "** ERROR reading input\n");
        exit(1);
    }
    r = blockDecrypt(&cipherInst, &keyInst, block, 128, block);
    fsize = atoi( block );
    block[15] = 0;
    // now we have that header out of the way, 
    // read in 16 byte blocks, encrypt each one
    // If fsize is zero, that means the file may have been
    // encrypted from a command line pipe, where we did not
    // know the size initially.  In that case we ignore the
    // fsize of zero, and rely on the last block to tell us
    // the actual size of the file (see above)
    if ( fsize == 0 ) {
        while (1) {
            memset( block, 0, 16 );
            size = fread( block, 1, 16, fpin );
            if ( size == 16 ) {
                blockDecrypt( &cipherInst, &keyInst, block, 128, block );
                if ( hasprevblock1 ) {
                    if ( fwrite( prevblock1, 16, 1, fpout ) != 1 ) {
                        printf( "** ERROR writing data\n" );
                        exit( 1 );
                    }
                }
                if ( hasprevblock ) {
                    memcpy( prevblock1, prevblock, 16 );
                    hasprevblock1 = 1;
                }
                memcpy( prevblock, block, 16 );
                hasprevblock = 1;
            } else {
                blockDecrypt( &cipherInst, &keyInst, block, 128, block );
                size = atoi( prevblock );
                if ( hasprevblock1 ) {
                    if ( fwrite( prevblock1, size, 1, fpout ) != 1 ) {
                        printf( "** ERROR writing data\n" );
                        exit( 1 );
                    }
                }
                break;
            }
        }
    } else {
        while ( fsize > 0 ) {
            memset( block, 0, 16 );
            size = fread( block, 1, 16, fpin );
            if ( size > 0 ) {
                blockDecrypt( &cipherInst, &keyInst, block, 128, block );
                if ( fsize > 16 ) {
                    writesize = 16;
                } else {
                    writesize = fsize;
                }
                if ( fwrite( block, writesize, 1, fpout ) != 1 ) {
                    printf( "** ERROR writing data\n" );
                    exit( 1 );
                }
                if ( writesize != 16 ) {
                    break;
                }
                fsize -= size;
            } else {
                break;
            }
        }
    }
    if ( argc > 3 ) {
        fclose( fpin );
    }
    if ( argc > 4 ) {
        fclose( fpout );
    }
  }
  return 0;
}
