/*
 * bc_export_ui.c
 *
 * Copyright (C) 2004, 2005 J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "bc_export_ui.h"

extern void bc_dialog(gchar *message,GtkMessageType type,GtkWidget *parent_window);
GtkWidget *export_window = NULL;
GtkWidget *export_id_combo_entry = NULL;
GList *s_idnames_list = NULL;
GList *s_idfp_list = NULL;
GtkWidget *title_entry = NULL;
GtkWidget *export_dialog = NULL;

GtkWidget *create_export_window() {
  GtkWidget *export_window;
  GtkWidget *fixed1;
  GtkWidget *hbuttonbox1;
  GtkWidget *ok_button;
  GtkWidget *alignment1;
  GtkWidget *hbox1;
  GtkWidget *image1;
  GtkWidget *label8;
  GtkWidget *cancel_button;
  GtkWidget *alignment2;
  GtkWidget *hbox2;
  GtkWidget *image2;
  GtkWidget *label9;
  GtkWidget *id_select_frame;
  GtkWidget *vbox1;
  GtkWidget *label2;
  GtkWidget *id_combo;
  GtkWidget *label4;
  GtkWidget *title_frame;
  GtkWidget *vbox2;
  GtkWidget *label3;
  GtkWidget *label6;
  GtkWidget *label1;

  export_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (export_window), _("Export Keys"));
  gtk_window_set_position (GTK_WINDOW (export_window), GTK_WIN_POS_CENTER);

  fixed1 = gtk_fixed_new ();
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (export_window), fixed1);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox1);
  gtk_fixed_put (GTK_FIXED (fixed1), hbuttonbox1, 56, 408);
  gtk_widget_set_size_request (hbuttonbox1, 280, 64);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox1), 6);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox1), 40);

  ok_button = gtk_button_new ();
  gtk_widget_show (ok_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), ok_button);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (ok_button), alignment1);

  hbox1 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox1);

  image1 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (hbox1), image1, FALSE, FALSE, 0);

  label8 = gtk_label_new_with_mnemonic (_("OK"));
  gtk_widget_show (label8);
  gtk_box_pack_start (GTK_BOX (hbox1), label8, FALSE, FALSE, 0);

  cancel_button = gtk_button_new ();
  gtk_widget_show (cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), cancel_button);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment2);
  gtk_container_add (GTK_CONTAINER (cancel_button), alignment2);

  hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (alignment2), hbox2);

  image2 = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image2);
  gtk_box_pack_start (GTK_BOX (hbox2), image2, FALSE, FALSE, 0);

  label9 = gtk_label_new_with_mnemonic (_("Cancel"));
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (hbox2), label9, FALSE, FALSE, 0);

  id_select_frame = gtk_frame_new (NULL);
  gtk_widget_show (id_select_frame);
  gtk_fixed_put (GTK_FIXED (fixed1), id_select_frame, 32, 200);
  gtk_widget_set_size_request (id_select_frame, 344, 90);

  vbox1 = gtk_vbox_new (FALSE, 10);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (id_select_frame), vbox1);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 6);

  label2 = gtk_label_new (_("Step 1:  Select an identity to export."));
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);

  id_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (id_combo)->popwin),
                     "GladeParentKey", id_combo);
  gtk_widget_show (id_combo);
  gtk_box_pack_start (GTK_BOX (vbox1), id_combo, FALSE, FALSE, 0);

  export_id_combo_entry = GTK_COMBO (id_combo)->entry;
  gtk_entry_set_editable(GTK_ENTRY(export_id_combo_entry), FALSE);
  gtk_widget_show (export_id_combo_entry);

  label4 = gtk_label_new ("");
  gtk_widget_show (label4);
  gtk_frame_set_label_widget (GTK_FRAME (id_select_frame), label4);

  title_frame = gtk_frame_new (NULL);
  gtk_widget_show (title_frame);
  gtk_fixed_put (GTK_FIXED (fixed1), title_frame, 32, 296);
  gtk_widget_set_size_request (title_frame, 344, 104);

  vbox2 = gtk_vbox_new (FALSE, 10);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (title_frame), vbox2);
  gtk_container_set_border_width (GTK_CONTAINER (vbox2), 6);

  label3 = gtk_label_new (_("Step 2:  Choose a title for this key.  You may use your real name, or you may leave this blank."));
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (vbox2), label3, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_CENTER);
  gtk_label_set_line_wrap (GTK_LABEL (label3), TRUE);

  title_entry = gtk_entry_new ();
  gtk_widget_show (title_entry);
  gtk_box_pack_start (GTK_BOX (vbox2), title_entry, FALSE, FALSE, 0);

  label6 = gtk_label_new ("");
  gtk_widget_show (label6);
  gtk_frame_set_label_widget (GTK_FRAME (title_frame), label6);

  label1 = gtk_label_new (_("You may use this feature to export the encryption key of your identity to a file.  The exported key can then be transported on disk (or other medium) to another computer running this software and imported.\n\nNote that the exported key file does not need to stay secret, but it does need to be protected from unauthorized modification.  You can store this key file on a public web server as long as you are very confident that the server is secure from attack."));
  gtk_widget_show (label1);
  gtk_fixed_put (GTK_FIXED (fixed1), label1, 16, 16);
  gtk_widget_set_size_request (label1, 368, 184);
  gtk_label_set_line_wrap (GTK_LABEL (label1), TRUE);

  gtk_combo_set_popdown_strings(GTK_COMBO(id_combo), s_idnames_list);


  g_signal_connect(GTK_OBJECT(ok_button), "clicked",
                   (GtkSignalFunc) export_win_ok_button_clicked, NULL);
  g_signal_connect(GTK_OBJECT(cancel_button), "clicked",
                   (GtkSignalFunc) export_win_cancel_button_clicked, NULL);
  /*g_signal_connect(GTK_OBJECT(export_window), "close",
    (GtkSignalFunc) export_win_closed, NULL);*/
  g_signal_connect(G_OBJECT(export_window), "delete_event",
		   G_CALLBACK(export_win_closed), NULL);
  return export_window;
}


void export_win_closed(GtkWidget *widget, GdkEvent *event, void *nothing) {
  /*printf("EXPORT WIN CLOSED!\n");*/
  gtk_main_quit();
}


void show_export_window(GList *idnames_list, GList *idfp_list) {
  s_idnames_list = idnames_list;
  s_idfp_list = idfp_list;

  export_window = create_export_window();
  gtk_widget_show(export_window);
  gtk_main();
}


void export_win_ok_button_clicked(GtkWidget *widget, gpointer data) {



  export_dialog = gtk_file_selection_new("Enter filename to export key to.");
  g_signal_connect(
		 GTK_OBJECT(GTK_FILE_SELECTION(export_dialog)->ok_button),
		 "clicked", (GtkSignalFunc)export_dialog_ok_button_clicked,
		 export_dialog);

  g_signal_connect(
		 GTK_OBJECT(GTK_FILE_SELECTION(export_dialog)->cancel_button),
		 "clicked", (GtkSignalFunc)export_dialog_cancel_button_clicked,
		 export_dialog);


  gtk_window_set_modal(GTK_WINDOW(export_dialog), TRUE);
  gtk_widget_show(export_dialog);
}

void export_win_cancel_button_clicked(GtkWidget *widget, gpointer data) {
  gtk_widget_destroy(export_window);
  gtk_main_quit();
}

void export_dialog_ok_button_clicked(GtkWidget *widget, gpointer data) {

  GtkWidget *export_dialog = (GtkWidget *)data;
  gchar *file_path = (gchar *)gtk_file_selection_get_filename(GTK_FILE_SELECTION(export_dialog));

  FILE *hFile = NULL;
  gchar *idfp = NULL;
  unsigned int i = 0;
  unsigned int found = 0;

  /*printf("file path: [%s]\n", file_path);*/

  

  gchar *id_to_export = (gchar *)gtk_entry_get_text(GTK_ENTRY(export_id_combo_entry));

  for (i = 0; (i < g_list_length(s_idnames_list)) && (found == 0); i++) {
    if (strcmp(g_list_nth_data(s_idnames_list, i), id_to_export) == 0) {
      idfp = g_list_nth_data(s_idfp_list, i);
      found = 1;
    }
  }

  if (found == 0) {
    bc_dialog("Internal error while exporting Identity!: fingerprint could not be found.", GTK_MESSAGE_ERROR, NULL);
  } else {
    GString *string = NULL;
    gchar *title = (gchar *)gtk_entry_get_text(GTK_ENTRY(title_entry));

    /* If the user did not enter a title, set it to the same value as the
     * id name. */
    if (strcmp(title, "") == 0)
      title = id_to_export;

    if (!(hFile = fopen(file_path, "w+"))) {
      string = g_string_new("Error while exporting identity to ");
      g_string_append_printf(string, "'%s'!", file_path);
      bc_dialog(string->str, GTK_MESSAGE_ERROR, NULL);
      g_string_free(string, TRUE);  string = NULL;
    } else {
      fwrite(id_to_export, sizeof(gchar), strlen(id_to_export), hFile);
      fwrite("|", sizeof(char), 1, hFile);
      fwrite(title, sizeof(gchar), strlen(title), hFile);
      fwrite("|", sizeof(char), 1, hFile);
      fwrite(idfp, sizeof(gchar), strlen(idfp), hFile);
      fclose(hFile);

      string = g_string_new(NULL);
      g_string_append_printf(string, "Identity '%s' has been successfully exported to '%s'.", id_to_export, file_path);
      bc_dialog(string->str, GTK_MESSAGE_INFO, NULL);
      g_string_free(string, TRUE);  string = NULL;
    }

  }

  gtk_widget_destroy(export_dialog);
  gtk_widget_destroy(export_window);
  gtk_main_quit();
}

void export_dialog_cancel_button_clicked(GtkWidget *widget, gpointer data) {
  gtk_widget_destroy(export_window);
  gtk_main_quit();
}
