/**
 * bc_prefs.c
 *
 * Copyright (C) 2005 J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "bc_prefs.h"

gchar prefs_path[ 256 ] = {'\0'};
GHashTable *prefs_table = NULL;


#define BC_PREFS_FILENAME "bc_prefs.txt"

int bc_prefs_load(char *dir) {
  int ret = 0;

  if (prefs_table != NULL) {
    g_hash_table_destroy(prefs_table);  prefs_table = NULL;
  }

  prefs_table = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);

  g_strlcpy(prefs_path, dir, sizeof(prefs_path));

#ifdef _WIN32
  g_strlcat(prefs_path, "\\", sizeof(prefs_path));
#else
  g_strlcat(prefs_path, "/", sizeof(prefs_path));
#endif

  g_strlcat(prefs_path, BC_PREFS_FILENAME, sizeof(prefs_path));


  /* Regardless of what's in the file, we set all the values to their defaults.
   * code below will override certain values as necessary. */
  bc_prefs_set(BC_PREFS_TOR_ENABLED,
	       BC_PREFS_TOR_ENABLED_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_PORT,
	       BC_PREFS_TOR_PORT_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_USE_BUILTIN,
	       BC_PREFS_TOR_USE_BUILTIN_DEFAULT);
  bc_prefs_set(BC_PREFS_CHECK_UPDATE_FREQ,
	       BC_PREFS_CHECK_UPDATE_FREQ_DEFAULT);
  bc_prefs_set(BC_PREFS_SEND_TYPING_WHILE_CRYPTED,
	       BC_PREFS_SEND_TYPING_WHILE_CRYPTED_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_USE_OUTGOING_PORTS,
	       BC_PREFS_TOR_USE_OUTGOING_PORTS_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_OUTGOING_PORTS,
	       BC_PREFS_TOR_OUTGOING_PORTS_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_USE_PROXY,
	       BC_PREFS_TOR_USE_PROXY_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_PROXY_USE_HTTP,
	       BC_PREFS_TOR_PROXY_USE_HTTP_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_PROXY_USE_HTTPS,
	       BC_PREFS_TOR_PROXY_USE_HTTPS_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_PROXY_HOST,
	       BC_PREFS_TOR_PROXY_HOST_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_PROXY_PORT,
	       BC_PREFS_TOR_PROXY_PORT_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_PROXY_USERNAME,
	       BC_PREFS_TOR_PROXY_USERNAME_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_PROXY_PASSWORD,
	       BC_PREFS_TOR_PROXY_PASSWORD_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_USE_CUSTOM_SETTINGS,
	       BC_PREFS_TOR_USE_CUSTOM_SETTINGS_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_CUSTOM_SETTINGS_DATA,
	       BC_PREFS_TOR_CUSTOM_SETTINGS_DATA_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_SAVED_PROXY,
               BC_PREFS_TOR_SAVED_PROXY_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_SAVED_PROXY_TYPE,
	       BC_PREFS_TOR_SAVED_PROXY_TYPE_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_SAVED_PROXY_HOST,
	       BC_PREFS_TOR_SAVED_PROXY_HOST_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_SAVED_PROXY_PORT,
	       BC_PREFS_TOR_SAVED_PROXY_PORT_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_SAVED_PROXY_USERNAME,
	       BC_PREFS_TOR_SAVED_PROXY_USERNAME_DEFAULT);
  bc_prefs_set(BC_PREFS_TOR_SAVED_PROXY_PASSWORD,
	       BC_PREFS_TOR_SAVED_PROXY_PASSWORD_DEFAULT);

  ret = bc_is_regular_file(prefs_path);
  if (ret == 0) {
    /*if (lstat(prefs_path, &s) < 0) {*/
    /* If the prefs file doesn't exist, then save all the defaults. */
    bc_prefs_save();
  } else if (ret > 0) {
    /* Parse the file and replace the defaults with their set values. */
#ifdef _WIN32
    DWORD read_len = 0;
    HANDLE hFile = NULL;
#else
    FILE *hFile = NULL;
#endif
    gchar *prefs_data = NULL;
    char *newline = NULL;
    unsigned int prefs_data_size = 0;
    char *equals_pos = NULL;
    char *key = NULL;
    char *value = NULL;
    unsigned int file_size = 0;

    file_size = bc_get_filesize(prefs_path);

    prefs_data_size = sizeof(gchar) * file_size;
    prefs_data = g_malloc0(prefs_data_size + 16);

#ifdef _WIN32
  hFile = CreateFile(prefs_path, GENERIC_READ, FILE_SHARE_READ, NULL,
                     OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if (hFile != INVALID_HANDLE_VALUE) {
    
    if (!ReadFile(hFile, prefs_data, prefs_data_size, &read_len, NULL))
      return -1;

    CloseHandle(hFile);  hFile = NULL;
  } else
    return -1;
#else
    hFile = fopen(prefs_path, "r");
    fread(prefs_data, file_size, sizeof(gchar), hFile);
    fclose(hFile);  hFile = NULL;
#endif

    newline = strstr(prefs_data, "\r\n");
    while(newline != NULL) {
#ifdef _WIN32
      /* Anybody know why this is necessary?  This makes my brain hurt... */
      if (newline > prefs_data)
        *(newline - 1) = '\0';
#else
      *newline = '\0';
#endif


      equals_pos = strchr(prefs_data, '=');
      if (equals_pos != NULL) {
	*equals_pos = '\0';
	key = prefs_data;
	value = equals_pos + 1;


	if ((strlen(key) > 0) && (strlen(value) > 0)) {
	  gaim_debug(GAIM_DEBUG_INFO, "bleh", "key: [%s]; value: [%s]\n", key, value);
	  bc_prefs_set(key, value);
	}
      }

      g_strlcpy(prefs_data, newline + strlen("\r\n"), prefs_data_size);
      newline = strstr(prefs_data, "\r\n");
    }

  } else
    return -1;

  return 1;
}

int bc_prefs_save(void) {
  FILE *hFile = NULL;


  if (strlen(prefs_path) == 0)
    return -1;

  hFile = fopen(prefs_path, "w");
  g_hash_table_foreach(prefs_table, table_enum_save, hFile);
  fclose(hFile);  hFile = NULL;
  return 1;
}

int bc_prefs_get(char *key, char *buffer, size_t buf_size) {
  gpointer value = g_hash_table_lookup(prefs_table, key);

  if (value == NULL) {
    if (buf_size > 0) {  buffer[ 0 ] = '\0';  }
    return -1;
  } else {
    GString *buf = g_string_new(value);
    unsigned int pos = 0;
    char *ptr = NULL;

    while ((ptr = strstr(buf->str, "<BR>")) != NULL) {
      pos = ptr - buf->str;
      g_string_erase(buf, pos, 4);
      g_string_insert(buf, pos, "\r\n");
    } 


    g_strlcpy(buffer, buf->str, buf_size);
    g_string_free(buf, TRUE);  buf = NULL;
    return 1;
  }
}

int bc_prefs_set(char *key, char *buffer) {
  if ((strcmp(key, BC_PREFS_TOR_ENABLED) == 0) ||
      (strcmp(key, BC_PREFS_TOR_PORT) == 0) ||
      (strcmp(key, BC_PREFS_TOR_USE_BUILTIN) == 0) ||
      (strcmp(key, BC_PREFS_CHECK_UPDATE_FREQ) == 0) ||
      (strcmp(key, BC_PREFS_SEND_TYPING_WHILE_CRYPTED) == 0) ||
      (strcmp(key, BC_PREFS_TOR_USE_OUTGOING_PORTS) == 0) ||
      (strcmp(key, BC_PREFS_TOR_OUTGOING_PORTS) == 0) ||
      (strcmp(key, BC_PREFS_TOR_USE_PROXY) == 0) ||
      (strcmp(key, BC_PREFS_TOR_PROXY_USE_HTTP) == 0) ||
      (strcmp(key, BC_PREFS_TOR_PROXY_USE_HTTPS) == 0) ||
      (strcmp(key, BC_PREFS_TOR_PROXY_HOST) == 0) ||
      (strcmp(key, BC_PREFS_TOR_PROXY_PORT) == 0) ||
      (strcmp(key, BC_PREFS_TOR_PROXY_USERNAME) == 0) ||
      (strcmp(key, BC_PREFS_TOR_PROXY_PASSWORD) == 0) ||
      (strcmp(key, BC_PREFS_TOR_USE_CUSTOM_SETTINGS) == 0) ||
      (strcmp(key, BC_PREFS_TOR_CUSTOM_SETTINGS_DATA) == 0) ||
      (strcmp(key, BC_PREFS_TOR_SAVED_PROXY_TYPE) == 0) ||
      (strcmp(key, BC_PREFS_TOR_SAVED_PROXY_HOST) == 0) ||
      (strcmp(key, BC_PREFS_TOR_SAVED_PROXY_PORT) == 0) ||
      (strcmp(key, BC_PREFS_TOR_SAVED_PROXY_USERNAME) == 0) ||
      (strcmp(key, BC_PREFS_TOR_SAVED_PROXY_PASSWORD) == 0) ||
      (strcmp(key, BC_PREFS_TOR_SAVED_PROXY) == 0)) {
    GString *buf = g_string_new(buffer);
    unsigned int pos = 0;
    char *ptr = NULL;

    while ((ptr = strstr(buf->str, "\r\n")) != NULL) {
      pos = ptr - buf->str;
      g_string_erase(buf, pos, strlen("\r\n"));
      g_string_insert(buf, pos, "<BR>");
    }

    while ((ptr = strstr(buf->str, "\n")) != NULL) {
      pos = ptr - buf->str;
      g_string_erase(buf, pos, strlen("\n"));
      g_string_insert(buf, pos, "<BR>");
    } 

    g_hash_table_insert(prefs_table, g_strdup(key), g_strdup(buf->str));
    g_string_free(buf, TRUE); buf = NULL;
    return 1;
  } else {
    gaim_debug(GAIM_DEBUG_ERROR, "bc_prefs.c", "NOT SETTING: [%s]=[%s]\n", key, buffer);
    return 0;
  }
}

void table_enum_save(gpointer key, gpointer value, gpointer data) {
  FILE *hFile = (FILE *)data;

  gchar line[ 256 ];

  memset(line, 0, sizeof(line));

  g_strlcpy(line, key, sizeof(line));
  g_strlcat(line, "=", sizeof(line));
  g_strlcat(line, value, sizeof(line));
  g_strlcat(line, "\r\n", sizeof(line));

  fwrite(line, strlen(line), sizeof(gchar), hFile);
}

int bc_prefs_is_yes(char *key) {
  char buffer[ 16 ];

  memset(buffer, 0, sizeof(buffer));

  bc_prefs_get(key, buffer, sizeof(buffer) - 8);
  if (strcmp(buffer, BC_PREFS_YES) == 0)
    return 1;
  else
    return 0;
}
