/**
 * bc_prefs.h
 *
 * Copyright (C) 2005 J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef BC_PREFS_H
#define BC_PREFS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "debug.h"

#include "bc_utils.h"


#define BC_PREFS_TOR_ENABLED "tor_enabled"
#define BC_PREFS_TOR_ENABLED_DEFAULT BC_PREFS_NO

#define BC_PREFS_TOR_PORT "tor_port"
#define BC_PREFS_TOR_PORT_DEFAULT "9050"

#define BC_PREFS_TOR_USE_BUILTIN "tor_use_builtin"
#define BC_PREFS_TOR_USE_BUILTIN_DEFAULT BC_PREFS_NO


#define BC_PREFS_CHECK_UPDATE_FREQ "check_for_updates"
#define BC_PREFS_CHECK_UPDATE_FREQ_DEFAULT "0"

#define BC_PREFS_SEND_TYPING_WHILE_CRYPTED "send_typing_while_crypted"
#define BC_PREFS_SEND_TYPING_WHILE_CRYPTED_DEFAULT BC_PREFS_NO

#define BC_PREFS_TOR_USE_OUTGOING_PORTS "tor_use_outgoing_ports"
#define BC_PREFS_TOR_USE_OUTGOING_PORTS_DEFAULT BC_PREFS_NO

#define BC_PREFS_TOR_OUTGOING_PORTS "tor_outgoing_ports"
#define BC_PREFS_TOR_OUTGOING_PORTS_DEFAULT "80, 443"

#define BC_PREFS_TOR_USE_PROXY "tor_use_proxy"
#define BC_PREFS_TOR_USE_PROXY_DEFAULT BC_PREFS_NO

#define BC_PREFS_TOR_PROXY_USE_HTTP "tor_proxy_use_http"
#define BC_PREFS_TOR_PROXY_USE_HTTP_DEFAULT BC_PREFS_YES

#define BC_PREFS_TOR_PROXY_USE_HTTPS "tor_proxy_use_https"
#define BC_PREFS_TOR_PROXY_USE_HTTPS_DEFAULT BC_PREFS_NO

#define BC_PREFS_TOR_PROXY_HOST "tor_proxy_host"
#define BC_PREFS_TOR_PROXY_HOST_DEFAULT ""

#define BC_PREFS_TOR_PROXY_PORT "tor_proxy_port"
#define BC_PREFS_TOR_PROXY_PORT_DEFAULT "80"

#define BC_PREFS_TOR_PROXY_USERNAME "tor_proxy_username"
#define BC_PREFS_TOR_PROXY_USERNAME_DEFAULT ""

#define BC_PREFS_TOR_PROXY_PASSWORD "tor_proxy_password"
#define BC_PREFS_TOR_PROXY_PASSWORD_DEFAULT ""

#define BC_PREFS_TOR_USE_CUSTOM_SETTINGS "tor_use_custom_settings"
#define BC_PREFS_TOR_USE_CUSTOM_SETTINGS_DEFAULT BC_PREFS_NO

#define BC_PREFS_TOR_CUSTOM_SETTINGS_DATA "tor_custom_settings"
#define BC_PREFS_TOR_CUSTOM_SETTINGS_DATA_DEFAULT \
        "DataDirectory $datadir<BR>" \
        "ClientOnly 1<BR>SOCKSPort " BC_PREFS_TOR_PORT_DEFAULT "<BR>" \
        "RunAsDaemon 1"

/* Saved gaim proxy settings. */
#define BC_PREFS_TOR_SAVED_PROXY "tor_saved_proxy"
#define BC_PREFS_TOR_SAVED_PROXY_DEFAULT BC_PREFS_NO

#define BC_PREFS_TOR_SAVED_PROXY_TYPE "tor_saved_proxy_type"
#define BC_PREFS_TOR_SAVED_PROXY_TYPE_DEFAULT "0"

#define BC_PREFS_TOR_SAVED_PROXY_HOST "tor_saved_proxy_host"
#define BC_PREFS_TOR_SAVED_PROXY_HOST_DEFAULT ""

#define BC_PREFS_TOR_SAVED_PROXY_PORT "tor_saved_proxy_port"
#define BC_PREFS_TOR_SAVED_PROXY_PORT_DEFAULT ""

#define BC_PREFS_TOR_SAVED_PROXY_USERNAME "tor_saved_proxy_username"
#define BC_PREFS_TOR_SAVED_PROXY_USERNAME_DEFAULT ""

#define BC_PREFS_TOR_SAVED_PROXY_PASSWORD "tor_saved_proxy_password"
#define BC_PREFS_TOR_SAVED_PROXY_PASSWORD_DEFAULT ""

#define BC_PREFS_YES "yes"
#define BC_PREFS_NO "no"



int bc_prefs_load(char *dir);
int bc_prefs_save(void);
int bc_prefs_get(char *key, char *buffer, size_t buf_size);
int bc_prefs_set(char *key, char *buffer);
void table_enum_save(gpointer key, gpointer value, gpointer data);
int bc_prefs_is_yes(char *key);

#endif
