/**
 * bc_ui_state.c
 *
 * Copyright (C) 2004-2005, J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "bc_ui_state.h"

static gchar encrypt_state_key[] = "bc_encrypt_state";

static gchar encrypt_state_encrypted[] = "ENCRYPTED";
static gchar encrypt_state_transition_1[] = "TRANSITION_1";
static gchar encrypt_state_transition_2[] = "TRANSITION_2";
static gchar encrypt_state_plaintext[] = "PLAINTEXT";


gchar *bc_get_encryption_state(GaimConversation *c) {
  return (gchar *)g_hash_table_lookup(c->data, encrypt_state_key);
}


void bc_set_state_plaintext(GaimConversation *c) {
  gchar *state = NULL;
  GtkWidget *button_greenlock = g_hash_table_lookup(c->data,
						    "bc_button_greenlock");
  GtkWidget *button_redlock = g_hash_table_lookup(c->data,
						  "bc_button_redlock");
  GtkWidget *button_yellowlock_1 = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_1");
  GtkWidget *button_yellowlock_2 = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_2");

  gtk_widget_show(button_redlock);
  gtk_widget_hide(button_yellowlock_1);
  gtk_widget_hide(button_yellowlock_2);
  gtk_widget_hide(button_greenlock);

  state = bc_get_encryption_state(c);
  g_strlcpy(state, encrypt_state_plaintext, 32);
}


void bc_set_state_transition1(GaimConversation *c) {
  gchar *state = NULL;
  GtkWidget *button_greenlock = g_hash_table_lookup(c->data,
						    "bc_button_greenlock");
  GtkWidget *button_redlock = g_hash_table_lookup(c->data,
						  "bc_button_redlock");
  GtkWidget *button_yellowlock_1 = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_1");
  GtkWidget *button_yellowlock_2 = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_2");

  gtk_widget_hide(button_redlock);
  gtk_widget_show(button_yellowlock_1);
  gtk_widget_hide(button_yellowlock_2);
  gtk_widget_hide(button_greenlock);

  state = bc_get_encryption_state(c);
  g_strlcpy(state, encrypt_state_transition_1, 32);
}


void bc_set_state_transition2(GaimConversation *c) {
  gchar *state = NULL;

  GtkWidget *button_greenlock = g_hash_table_lookup(c->data,
						    "bc_button_greenlock");
  GtkWidget *button_redlock = g_hash_table_lookup(c->data,
						  "bc_button_redlock");
  GtkWidget *button_yellowlock_1 = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_1");
  GtkWidget *button_yellowlock_2 = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_2");

  gtk_widget_hide(button_redlock);
  gtk_widget_hide(button_yellowlock_1);
  gtk_widget_show(button_yellowlock_2);
  gtk_widget_hide(button_greenlock);
  state = bc_get_encryption_state(c);
  g_strlcpy(state, encrypt_state_transition_2, 32);
}


void bc_set_state_encrypted(GaimConversation *c) {
  gchar *state = NULL;
  GtkWidget *button_greenlock = g_hash_table_lookup(c->data,
						    "bc_button_greenlock");
  GtkWidget *button_redlock = g_hash_table_lookup(c->data,
						  "bc_button_redlock");
  GtkWidget *button_yellowlock_1 = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_1");
  GtkWidget *button_yellowlock_2 = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_2");

  gtk_widget_hide(button_redlock);
  gtk_widget_hide(button_yellowlock_1);
  gtk_widget_hide(button_yellowlock_2);
  gtk_widget_show(button_greenlock);

  state = bc_get_encryption_state(c);
  g_strlcpy(state, encrypt_state_encrypted, 32);
}


unsigned int bc_is_state_encrypted(GaimConversation *c) {
  gchar *encrypt_state = bc_get_encryption_state(c);

  if (g_ascii_strncasecmp((gchar *)encrypt_state, encrypt_state_encrypted, strlen(encrypt_state_encrypted)) == 0)
    return 1;
  else {
    bc_ensure_state_valid(c);
    return 0;
  }
}


unsigned int bc_is_state_plaintext(GaimConversation *c) {
  gchar *encrypt_state = bc_get_encryption_state(c);

  if (g_ascii_strncasecmp((gchar *)encrypt_state, encrypt_state_plaintext, strlen(encrypt_state_plaintext)) == 0)
    return 1;
  else {
    bc_ensure_state_valid(c);
    return 0;
  }
}


void bc_ensure_state_valid(GaimConversation *c) {
  //  gchar *encrypt_state = (gchar *)g_hash_table_lookup(c->data,
  //						      encrypt_state_key);
  gchar *encrypt_state = bc_get_encryption_state(c);

  if (encrypt_state == NULL) {
    bc_dialog("Critical error in bc_is_state_valid!",
	      GTK_MESSAGE_ERROR, NULL);
    exit(1);
  }

  if ((g_ascii_strncasecmp(encrypt_state, encrypt_state_encrypted, strlen(encrypt_state_encrypted)) == 0) ||
      (g_ascii_strncasecmp(encrypt_state, encrypt_state_plaintext, strlen(encrypt_state_plaintext)) == 0) ||
      (g_ascii_strncasecmp((gchar *)encrypt_state, encrypt_state_transition_1, strlen(encrypt_state_transition_1)) == 0) ||
      (g_ascii_strncasecmp((gchar *)encrypt_state, encrypt_state_transition_2, strlen(encrypt_state_transition_2)) == 0)) {
    return;
  } else {
    /*printf("bc_ensure_state_valid(): FAILURE!: [%s]\n", encrypt_state);*/
    exit(1);
  }

}


/*unsigned int bc_is_state_plaintext(GaimConversation *c) {
  gchar *encrypt_state = (gchar *)g_hash_table_lookup(c->data,
						      encrypt_state_key);
  if (g_ascii_strncasecmp((gchar *)encrypt_state, _("TRUE"), 4) == 0)
    return 0;
  else if (g_ascii_strncasecmp((gchar *)encrypt_state, _("FALSE"), 5) == 0)
    return 1;
  else if (g_ascii_strncasecmp((gchar *)encrypt_state, _("TRANSITION_1"), 12) == 0)
    return 0;
  else if (g_ascii_strncasecmp((gchar *)encrypt_state, _("TRANSITION_2"), 12) == 0)
    return 0;
  else {
    bc_dialog("Critical error in bc_is_state_unencrypted()!",
	      GTK_MESSAGE_ERROR, NULL);
    exit(1);
    }
}*/

/*void bc_enable_encryption_state(GaimConversation *c) {
  if (!bc_is_state_encrypted(c)) {
    GtkWidget *button_greenlock = g_hash_table_lookup(c->data,
						      "bc_button_greenlock");
    GtkWidget *button_redlock = g_hash_table_lookup(c->data,
						    "bc_button_redlock");

    gtk_widget_hide(button_redlock);
    gtk_widget_show(button_greenlock);

    g_hash_table_insert(c->data, g_strdup(encrypt_state_key), encrypt_state_true);
  }
}

void bc_disable_encryption_state(GaimConversation *c) {
  if (bc_is_state_encrypted(c)) {
    GtkWidget *button_greenlock = g_hash_table_lookup(c->data,
						      "bc_button_greenlock");
    GtkWidget *button_redlock = g_hash_table_lookup(c->data,
						    "bc_button_redlock");

    gtk_widget_hide(button_greenlock);
    gtk_widget_show(button_redlock);

    g_hash_table_insert(c->data, g_strdup(encrypt_state_key),
			encrypt_state_false);
  }
}
*/
