/**
 * bc_utils.h
 *
 * Copyright (C) 2003-2005, J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef BC_UTILS_H
#define BC_UTILS_H

#include <glib.h>
#ifndef _WIN32
#include <pwd.h>
#else
#include <windows.h>
#include <shlobj.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include "conversation.h"
#include "bc_main.h"

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef _WIN32
   #define SLASH_CHAR "\\"
#else
   #define SLASH_CHAR "/"
#endif

#define BUDDY_RESET                 0
#define SENT_PUBKEYS                1
#define SENT_SESSION_KEY            2
#define AWAITING_PUBKEYS_1          4
#define AWAITING_PUBKEYS_2          8
#define AWAITING_SESSION_KEY       16
#define SIGNKEY_FINGERPRINT_VALID  32
#define ENCRYPTKEY_VALID           64
#define SESSION_KEY_VALID         128
#define CONNECTED                 256
#define TIMEDOUT                  512
#define REPLAY_IMMUNE            1024


int bc_autoencrypt(char *who, gboolean which);

int bc_check_new_version(char *buf, size_t len);

void bc_create_dir(char *dir);

int bc_delete_file(char *file);

int bc_does_dir_exist(char *dir);

GaimConversation *bc_find_conversation(char *name);

gchar *bc_get_debugging_file(char *path);

unsigned int bc_get_default_dir(char *buffer, size_t buffer_size);

unsigned int bc_get_filesize(char *path);

unsigned int bc_get_home_directory(char *buffer, size_t buffer_size);

void bc_get_temporary_filename(char *tempfile, size_t tempfile_size);

unsigned int bc_is_char_hexidecimal(char a_char);

unsigned int bc_is_key_fingerprint_valid(char *fp);

int bc_is_regular_file(char *path);

int bc_is_secure_channel_established(char *who, GaimAccount *acct);

char *bc_parse_state_into_text(unsigned int state);

int bc_parse_stderr_line(char *line, char *screenname, size_t screenname_size, char *umid, size_t umid_size, unsigned int *operation, unsigned int *oldstate, unsigned int *newstate);

int bc_parse_version(char *version, int *major, int *minor, int *revision);

void bc_remove_dir(char *dir);

int bc_strcmp_null(char *s1, char *s2);

char *get_status(char *who, GaimAccount *acct);




#endif

