/*
 * bc_proghandler.h
 *
 * Copyright (C) 2004-2005, J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _BC_PROGHANDLER_H
#define _BC_PROGHANDLER_H



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#ifndef _WIN32
#include <sys/socket.h>
#include <signal.h>
#else
#include <windows.h>
#include <tlhelp32.h>
#endif
#include <sys/types.h>
#include <unistd.h>



int bc_spawn_tor(void);
int bc_spawn_crypto_module(void);
int get_sizes(size_t *size_array, size_t size_array_len);
void mod_kill(void);
void mod_lock(void);
void mod_unlock(void);
void mod_quit(void);
int mod_readdata(char *buffer, size_t buffer_len, size_t bytes_to_read);
int mod_readline(char *buffer, size_t buffer_len);
int mod_stderr_readline(char *buffer, size_t buffer_len);
void mod_write(char *string);
void mod_writeln(char *string);
int parseOK(char *line, unsigned int *type, unsigned int *num_results);
void sync_stderr(void);
void tor_kill(void);
void trim_crlf(char *buffer);
void write_tor_config(gchar *config);



#endif
