/**
 * bc_ui.c
 *
 * Copyright (C) 2003-2005 J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef USING_ENCRYPTION
#include "bc_ui.h"

/*extern int bc_generate_key(const char *id, unsigned char *fingerprint_buffer,
			   gchar *id_pw, size_t fingerprint_buffer_len);
			   extern char *get_status(char *who, GaimAccount *acct);*/

extern GHashTable *pending_messages;
extern GMutex *pending_messages_mutex;

static gchar encrypted_button_text_encrypted[] = "> Encrypted <";
static gchar encrypted_button_text_notencrypted[] = "Not Encrypted";
static gchar encrypted_button_text_transition1[] = "To Encrypt";
static gchar encrypted_button_text_transition2[] =  "Handshaking";

int selected_id_index = -1;
GList *idnames_list = NULL;
GList *idfp_list = NULL;
GList *buddynames_list = NULL;
GList *buddyfp_list = NULL;
GtkWidget *my_tree_view = NULL;

GtkWidget *um_init_window = NULL;
GtkWidget *um_fingerprint_window = NULL;
GtkWidget *directory_entry = NULL;
GtkWidget *id_combo_entry = NULL;
GtkWidget *generate_button = NULL;
GtkWidget *id_combo = NULL;
GtkWidget *id_fingerprint = NULL;
GList *combo_box_list = NULL;
GtkWidget *ok_button = NULL;
GtkWidget *frame_buttonbox = NULL;

GtkWidget *entUMID = NULL;
GtkWidget *btnGenerateForReal = NULL;
GtkWidget *lblKeyGenLabel = NULL;
GtkWidget *prgGenerateBar = NULL;
GtkWidget *um_keygen_win =  NULL;
GtkWidget *new_entry_window = NULL;
GtkWidget *select_button = NULL;
GtkWidget *pw_entry = NULL;

GMutex *keygen_mutex = NULL;

unsigned int progress_bar_continue = 0;

GtkListStore *database_list_store = NULL;
GtkTreeIter database_tree_iter;
GtkWidget *entNewUMID = NULL;
GtkWidget *entNewFingerprint = NULL;
GtkWidget *key_frame = NULL;
GtkWidget *tree_viewport = NULL;
GtkWidget *bottom_buttonbox = NULL;
GtkWidget *fixed_main = NULL;
GtkWidget *delete_id_button = NULL;
GtkWidget *import_dialog = NULL;
GtkWidget *key_pw_entry_1 = NULL;
GtkWidget *key_pw_entry_2 = NULL;
GtkWidget *debug_menu = NULL;

extern gchar *debug_file;

static gchar encrypt_state_key[] = "bc_encrypt_state";

/* Displays a dialog box with a message, title, and 'OK' button.  The
 * 'parent_window' argument is the window that owns the dialog (in
 * terms of modality); NULL may be used. */
/*void um_dialog(gchar *message, gchar *title, GtkWidget *parent_window) {
  GtkWidget *dialog = NULL;
  GtkWidget *label = NULL;
  GtkWindow *p_window = NULL;
  gint flags = 0;

  if (parent_window != NULL) {
    p_window = GTK_WINDOW(parent_window);
    flags = GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL;
  }

  dialog = gtk_dialog_new_with_buttons(title, p_window,
                      flags,
                      GTK_STOCK_OK, GTK_RESPONSE_NONE, NULL);
  label = gtk_label_new(message);

  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), label);
  gtk_widget_show(label);
  gtk_dialog_run(GTK_DIALOG (dialog));

  gtk_widget_destroy(dialog);  dialog = NULL;
  return;
  }*/


/* Displays a dialog box with a message, title, and 'OK' button.  The
 * 'parent_window' argument is the window that owns the dialog (in
 * terms of modality); NULL may be used. */
void bc_dialog(gchar *message, GtkMessageType type, GtkWidget *parent_window) {
#ifdef _WIN32
   char *title = NULL;
   int mb_type = MB_OK;

   if (type == GTK_MESSAGE_ERROR) {
      mb_type |= MB_ICONERROR;
      title = "Error";
   } else if (type == GTK_MESSAGE_INFO) {
      mb_type |= MB_ICONINFORMATION;
      title = "Information";
   }

   MessageBox(NULL, message, title, mb_type);
#else
  GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(parent_window),
		      GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
		      type, GTK_BUTTONS_OK, "%s", message);

  /*g_signal_connect_swapped(dialog, "response",
			   G_CALLBACK(gtk_widget_destroy),
			   dialog);*/

  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);
#endif
}


GtkWidget *create_fingerprint_window(struct NEW_FP_STRUCT *new_fp_struct) {
  GtkWidget *frame1;
  GtkWidget *fixed1;
  GtkWidget *frame3;
  GtkWidget *label10;
  GtkWidget *frame2;
  GtkWidget *entFingerprint;
  GtkWidget *label2;
  GtkWidget *lblTop;
  GtkWidget *lblBottom;
  GtkWidget *btnReject;
  GtkWidget *alignment3;
  GtkWidget *hbox3;
  GtkWidget *image3;
  GtkWidget *label5;
  GtkWidget *btnAccept;
  GtkWidget *alignment4;
  GtkWidget *hbox4;
  GtkWidget *image4;
  GtkWidget *label6;
  GtkWidget *btnHelp;
  GtkWidget *alignment5;
  GtkWidget *hbox5;
  GtkWidget *image5;
  GtkWidget *label7;
  GtkWidget *label1;


  char message[ 128 ];

  memset(message, 0, sizeof(message));

  um_fingerprint_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (um_fingerprint_window), _("New Key Fingerprint Detected"));
  gtk_window_set_position (GTK_WINDOW (um_fingerprint_window), GTK_WIN_POS_CENTER);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_container_add (GTK_CONTAINER (um_fingerprint_window), frame1);
  gtk_widget_set_usize (frame1, 610, 185);


  fixed1 = gtk_fixed_new ();
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (frame1), fixed1);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_show (frame3);
  gtk_fixed_put (GTK_FIXED (fixed1), frame3, 448, 56);
  gtk_widget_set_usize (frame3, 150, 48);

  entUMID = GTK_WIDGET(gtk_entry_new_with_max_length (16));
  gtk_widget_show (entUMID);
  gtk_container_add (GTK_CONTAINER (frame3), entUMID);

  label10 = gtk_label_new (_("Alternative ID"));
  gtk_widget_show (label10);
  gtk_frame_set_label_widget (GTK_FRAME (frame3), label10);
  gtk_label_set_justify (GTK_LABEL (label10), GTK_JUSTIFY_LEFT);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_show (frame2);
  gtk_fixed_put (GTK_FIXED (fixed1), frame2, 8, 56);
  gtk_widget_set_usize (frame2, 438, 48);

  entFingerprint = gtk_entry_new ();
  gtk_widget_show (entFingerprint);
  gtk_container_add (GTK_CONTAINER (frame2), entFingerprint);
  gtk_entry_set_editable (GTK_ENTRY (entFingerprint), FALSE);

  label2 = gtk_label_new (_("Fingerprint"));
  gtk_widget_show (label2);
  gtk_frame_set_label_widget (GTK_FRAME (frame2), label2);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);

  lblTop = gtk_label_new (_(""));
  gtk_widget_show (lblTop);
  gtk_fixed_put (GTK_FIXED (fixed1), lblTop, 8, 0);
  gtk_widget_set_usize (lblTop, 590, 16);
  gtk_label_set_justify (GTK_LABEL (lblTop), GTK_JUSTIFY_LEFT);

  lblBottom = gtk_label_new (_("This user's public key is not in your key database."));
  gtk_widget_show (lblBottom);
  gtk_fixed_put (GTK_FIXED (fixed1), lblBottom, 0, 16);
  gtk_widget_set_usize (lblBottom, 598, 40);

  btnReject = gtk_button_new ();
  gtk_widget_show (btnReject);
  gtk_fixed_put (GTK_FIXED (fixed1), btnReject, 216, 120);
  gtk_widget_set_usize (btnReject, 150, 40);

  alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (btnReject), alignment3);

  hbox3 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox3);
  gtk_container_add (GTK_CONTAINER (alignment3), hbox3);

  image3 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image3);
  gtk_box_pack_start (GTK_BOX (hbox3), image3, FALSE, FALSE, 0);

  label5 = gtk_label_new_with_mnemonic (_("Reject Key"));
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (hbox3), label5, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);

  btnAccept = gtk_button_new ();
  gtk_widget_show (btnAccept);
  gtk_fixed_put (GTK_FIXED (fixed1), btnAccept, 400, 120);
  gtk_widget_set_usize (btnAccept, 152, 40);

  alignment4 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment4);
  gtk_container_add (GTK_CONTAINER (btnAccept), alignment4);

  hbox4 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox4);
  gtk_container_add (GTK_CONTAINER (alignment4), hbox4);

  image4 = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image4);
  gtk_box_pack_start (GTK_BOX (hbox4), image4, FALSE, FALSE, 0);

  label6 = gtk_label_new_with_mnemonic (_("Accept Key"));
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (hbox4), label6, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);

  btnHelp = gtk_button_new ();
  gtk_widget_show (btnHelp);
  gtk_fixed_put (GTK_FIXED (fixed1), btnHelp, 24, 120);
  gtk_widget_set_usize (btnHelp, 150, 40);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (btnHelp), alignment5);

  hbox5 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox5);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox5);

  image5 = gtk_image_new_from_stock ("gtk-help", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image5);
  gtk_box_pack_start (GTK_BOX (hbox5), image5, FALSE, FALSE, 0);

  label7 = gtk_label_new_with_mnemonic (_("Help"));
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox5), label7, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);

  label1 = gtk_label_new ("");
  gtk_widget_show (label1);
  gtk_frame_set_label_widget (GTK_FRAME (frame1), label1);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);


  g_snprintf(message, sizeof(message) - 8, "User '%s' is attempting to establish a new secure channel with you over the %s protocol.", new_fp_struct->umid, new_fp_struct->protocol);


  gtk_label_set_text(GTK_LABEL(lblTop), message);

  gtk_entry_set_text(GTK_ENTRY(entUMID), new_fp_struct->umid);
  gtk_entry_set_text(GTK_ENTRY(entFingerprint), new_fp_struct->fingerprint);

  new_fp_struct->ent_umid = entUMID;
  new_fp_struct->ent_fingerprint = entFingerprint;

  new_fp_struct->fp_window = um_fingerprint_window;
  new_fp_struct->trigger = 1;

  /*pipe(new_fp_struct->the_pipe);*/

  /*#ifdef _WIN32
  new_fp_struct->channel = g_io_channel_unix_new(new_fp_struct->the_pipe[ 0 ]);
  new_fp_struct->event_source_id = g_io_add_watch(new_fp_struct->channel, G_IO_IN|G_IO_PRI, key_timeout_io_watch, new_fp_struct);
  #else*/
  /*new_fp_struct->event_source_id = gaim_input_add(new_fp_struct->the_pipe[ 0 ], GAIM_INPUT_READ, key_timeout_io_watch, new_fp_struct);*/
  /*#endif*/

  new_fp_struct->source_id = g_timeout_add(45000, timeout_func, new_fp_struct);

  /*new_fp_struct->thread = g_thread_create(&keyfp_thread, new_fp_struct,
    TRUE, NULL);*/
  g_signal_connect(GTK_OBJECT(btnAccept), "clicked",
                   (GtkSignalFunc) accept_button_clicked, new_fp_struct);
  g_signal_connect(GTK_OBJECT(btnReject), "clicked",
                   (GtkSignalFunc) reject_button_clicked, new_fp_struct);
  g_signal_connect(GTK_OBJECT(btnHelp), "clicked",
                   (GtkSignalFunc) um_fp_help_button_clicked, NULL);

  return um_fingerprint_window;
}


void um_fp_help_button_clicked(GtkWidget *widget, gpointer data) {

  char *message1 = "Apparently, someone is trying to send you an\n"
                  "encrypted message for the first time.  However, before\n"
                  "you may communicate with this person, you must first\n"
                  "verify his/her identity.  This can be done by examining\n"
                  "the key fingerprint shown to you in the wide textbox.\n"
                  "Ideally, you already received this person's key\n"
                  "fingerprint through another more trusted medium like the\n"
                  "telephone, or in person.  If so, then simply compare the\n"
                  "two sequences of letters and numbers together.  Accept\n"
                  "the key if they match; reject the key if they do not.";
  char *message2 = "If you've never received this person's key\n"
                "fingerprint until now, you must proceed VERY carefully:\n\n\t"
                "If you are even remotely suspicious of this person, then\n"
                "reject the key immediately.\n\n\t"
                "If you are familiar with this screen name, and were\n"
                "expecting him/her to contact you, then cautiously accept\n"
                "the key, and verify the key fingerprint as soon as\n"
                "possible using a more trusted medium (ie:  NOT the\n"
                "encrypted session you just set up, since you cannot fully\n"
                "trust its authenticity yet).  To verify the key\n"
                "fingerprint manually, you must compare the correct line\n"
                "within the 'um_keycache' file in your Load/Save directory\n"
                "with your buddy's key.";
  char *message3 = "The Ultramagnetic ID is a special feature that\n"
                "allows you to bind a custom name to an encryption key.\n\n\t"
                "For example, suppose your friend uses the screen name\n"
		"'SweetPrincess69' on AOL Instant Messanger.  After you've\n"
                "properly verified her key fingerprint, you can specify her\n"
                "Ultramagnetic ID as 'Stacy'.  From that point on, when\n"
                "you talk to her, the name 'Stacy' will appear in the IM\n"
                "window instead of her screen name.  But that's not all!\n"
                "If you both were to sign onto another IM service (like\n"
                "Yahoo!, for example), the name 'Stacy' will still appear\n"
                "as long as she uses the same key.\n\n\t"
                "So essentially, Ultramagnetic IDs allow you to not only\n"
                "customize the screen name display, but it also adds\n"
                "a layer of abstraction that blurs the gaps between different\n"
                "IM services.  Though anyone can take advantage of it, it\n"
                "was specifically designed for super-paranoid people who do\n"
                "not want to continually use the same screen names &\n"
                "services.\n\n\t";
  bc_dialog(message1, GTK_MESSAGE_INFO, um_fingerprint_window);
  bc_dialog(message2, GTK_MESSAGE_INFO, um_fingerprint_window);
  bc_dialog(message3, GTK_MESSAGE_INFO, um_fingerprint_window);
}


GtkWidget* create_um_init_window ( void ) {
  /*GtkWidget *help_button;*/
  GtkWidget *fixed5;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *hbuttonbox1;
  GtkWidget *add_button;
  GtkWidget *edit_button;
  GtkWidget *delete_button;
  GtkWidget *id_frame;
  GtkWidget *vbox1;
  GtkWidget *hbox4;
  GtkWidget *directory_frame;
  GtkWidget *menubar;
  GtkWidget *tree_scrolled;
  GtkCellRenderer *renderer1, *renderer2;
  GtkTreeViewColumn *column_umid, *column_fingerprint;
  GtkWidget *default_checkbox;
  GtkWidget *table;
  GtkWidget *menuitem1_menu;
  GtkWidget *import_buddy_key_1;
  GtkWidget *export_buddy_key_1;
  GtkWidget *tor_menu;

  GtkWidget *separator2;
  GtkWidget *separator3;
  GtkWidget *separator4;
  GtkWidget *check_for_newer_version1;
  /*GtkWidget *separator1;
  GtkWidget *set_password_on_encryption_ids1;
  GtkWidget *change_password_on_encryption_ids1;*/
  GtkWidget *help1;
  GtkWidget *help1_menu;
  GtkWidget *what_is_the__load_save_directory__1;
  GtkWidget *what_is_an__encryption_id__1;
  GtkWidget *what_is_the__buddy_id_database__1;
  GtkWidget *menuitem1;
  GtkWidget *keydb_button;

  char default_dir[ 256 ];

  memset(default_dir, 0, sizeof(default_dir));


  um_init_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  /*gtk_object_set_data (GTK_OBJECT (um_init_window), "um_init_window", um_init_window);*/

#ifndef _WIN32
  gtk_window_set_resizable(GTK_WINDOW(um_init_window), FALSE);
#endif

  g_object_set_data ((GObject *)um_init_window, "um_init_window", um_init_window);
  gtk_widget_set_size_request (GTK_WIDGET(um_init_window), 445, 280);
  gtk_window_set_title (GTK_WINDOW (um_init_window), "Encryption Initialization Window");
  gtk_window_set_position (GTK_WINDOW (um_init_window), GTK_WIN_POS_CENTER_ALWAYS);
  /*gtk_window_set_modal (GTK_WINDOW (um_init_window), TRUE);*/

  fixed_main = gtk_fixed_new ();
  gtk_widget_ref (fixed_main);
  g_object_set_data_full ((GObject *)um_init_window, "fixed_main", fixed_main,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fixed_main);
  gtk_container_add (GTK_CONTAINER (um_init_window), fixed_main);

  frame_buttonbox = gtk_frame_new (NULL);
  gtk_widget_ref (frame_buttonbox);
  g_object_set_data_full ((GObject *)um_init_window, "frame_buttonbox",
			  frame_buttonbox,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_buttonbox);
  gtk_fixed_put (GTK_FIXED (fixed_main), frame_buttonbox, 16, 220);


  menubar = gtk_menu_bar_new();
  gtk_widget_show(menubar);
  gtk_fixed_put(GTK_FIXED(fixed_main), menubar, 0, 0);

  gtk_widget_set_size_request (menubar, 445, 24);

  menuitem1 = gtk_menu_item_new_with_mnemonic (_("_Options"));
  gtk_widget_show(menuitem1);
  gtk_container_add(GTK_CONTAINER(menubar), menuitem1);


  menuitem1_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem1), menuitem1_menu);

  import_buddy_key_1 = gtk_menu_item_new_with_mnemonic (_("Import Buddy Key ..."));
  gtk_widget_show (import_buddy_key_1);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), import_buddy_key_1);

  export_buddy_key_1 = gtk_menu_item_new_with_mnemonic (_("Export Buddy Key ..."));
  gtk_widget_show (export_buddy_key_1);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), export_buddy_key_1);



  separator2 = gtk_menu_item_new ();
  gtk_widget_show (separator2);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), separator2);
  gtk_widget_set_sensitive (separator2, FALSE);


  tor_menu = gtk_menu_item_new_with_mnemonic(_("Configure Tor..."));
  gtk_widget_show(tor_menu);
  gtk_container_add(GTK_CONTAINER(menuitem1_menu), tor_menu);

  separator3 = gtk_menu_item_new ();
  gtk_widget_show (separator3);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), separator3);
  gtk_widget_set_sensitive (separator3, FALSE);


  debug_menu = gtk_check_menu_item_new_with_label(_("Enable Debugging"));
  gtk_widget_show(debug_menu);
  gtk_container_add(GTK_CONTAINER(menuitem1_menu), debug_menu);

  separator4 = gtk_menu_item_new ();
  gtk_widget_show (separator4);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), separator4);
  gtk_widget_set_sensitive (separator4, FALSE);


  check_for_newer_version1 = gtk_menu_item_new_with_mnemonic (_("Check for newer version"));
  gtk_widget_show (check_for_newer_version1);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), check_for_newer_version1);

  /*separator1 = gtk_menu_item_new ();
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), separator1);
  gtk_widget_set_sensitive (separator1, FALSE);*/

  /*set_password_on_encryption_ids1 = gtk_menu_item_new_with_mnemonic (_("Set password on Encryption IDs"));
  gtk_widget_show (set_password_on_encryption_ids1);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), set_password_on_encryption_ids1);

  change_password_on_encryption_ids1 = gtk_menu_item_new_with_mnemonic (_("Change password on Encryption IDs"));
  gtk_widget_show (change_password_on_encryption_ids1);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), change_password_on_encryption_ids1);*/

  help1 = gtk_menu_item_new_with_mnemonic (_("Help"));
  gtk_widget_show (help1);
  gtk_container_add (GTK_CONTAINER (menubar), help1);

  help1_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help1), help1_menu);

  what_is_the__load_save_directory__1 = gtk_menu_item_new_with_mnemonic (_("What is the 'Load/Save Directory'?"));
  gtk_widget_show (what_is_the__load_save_directory__1);
  gtk_container_add (GTK_CONTAINER (help1_menu), what_is_the__load_save_directory__1);

  what_is_an__encryption_id__1 = gtk_menu_item_new_with_mnemonic (_("What is an 'Encryption ID'?"));
  gtk_widget_show (what_is_an__encryption_id__1);
  gtk_container_add (GTK_CONTAINER (help1_menu), what_is_an__encryption_id__1);

  what_is_the__buddy_id_database__1 = gtk_menu_item_new_with_mnemonic (_("What is the 'Public Key Hash Database'?"));
  gtk_widget_show (what_is_the__buddy_id_database__1);
  gtk_container_add (GTK_CONTAINER (help1_menu), what_is_the__buddy_id_database__1);


  /* IS THIS EVEN NEEDED? */
  /*gtk_widget_set_uposition (frame6, 16, 408);*/
  gtk_widget_set_size_request (frame_buttonbox, 415, 50);

  bottom_buttonbox = gtk_hbutton_box_new ();
  gtk_widget_ref (bottom_buttonbox);
  g_object_set_data_full ((GObject *)um_init_window, "bottom_buttonbox", bottom_buttonbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (bottom_buttonbox);
  gtk_container_add (GTK_CONTAINER (frame_buttonbox), bottom_buttonbox);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (bottom_buttonbox), GTK_BUTTONBOX_SPREAD);

  keydb_button = gtk_button_new_with_label ("[+] Show Database");
  gtk_widget_ref (keydb_button);
  g_object_set_data_full ((GObject *)um_init_window, "keydb_button", keydb_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (keydb_button);
  gtk_container_add (GTK_CONTAINER (bottom_buttonbox), keydb_button);
  GTK_WIDGET_SET_FLAGS (keydb_button, GTK_CAN_DEFAULT);



  /*help_button = gtk_button_new_from_stock (GTK_STOCK_HELP);
  gtk_widget_ref (help_button);
  g_object_set_data_full ((GObject *)um_init_window, "help_button", help_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (help_button);
  gtk_container_add (GTK_CONTAINER (bottom_buttonbox), help_button);
  GTK_WIDGET_SET_FLAGS (help_button, GTK_CAN_DEFAULT);*/

  ok_button = gtk_button_new_from_stock (GTK_STOCK_OK);

  gtk_widget_ref (ok_button);
  g_object_set_data_full ((GObject *)um_init_window, "ok_button", ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ok_button);
  gtk_container_add (GTK_CONTAINER (bottom_buttonbox), ok_button);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

  key_frame = gtk_frame_new ("Public Key Hash Database");
  gtk_widget_ref (key_frame);
  g_object_set_data_full ((GObject *)um_init_window, "key_frame", key_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  /*gtk_widget_show (key_frame);*/

  gtk_fixed_put (GTK_FIXED (fixed_main), key_frame, 16, 225);
  /*gtk_widget_set_uposition (key_frame, 16, 168);*/
  /*gtk_widget_set_size_request (key_frame, 376, 232);*/

  gtk_widget_set_size_request (key_frame, 415, 232);

  /*my_label = gtk_label_new("XXX!");
  gtk_widget_show(my_label);
  gtk_fixed_put(GTK_FIXED(fixed_main), my_label, 20, 200);
  */


  tree_viewport = gtk_viewport_new (NULL, NULL);
  gtk_fixed_put(GTK_FIXED(fixed_main), tree_viewport, 20, 245);
  gtk_widget_set_usize(tree_viewport, 405, 160);

  tree_scrolled = gtk_scrolled_window_new(NULL, NULL);
  /*gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(tree_scrolled),
    GTK_POLICY_NEVER, GTK_POLICY_NEVER);*/
  gtk_widget_show(tree_scrolled);
  gtk_container_add(GTK_CONTAINER(tree_viewport), tree_scrolled);

  database_list_store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
  my_tree_view = gtk_tree_view_new_with_model(GTK_TREE_MODEL(database_list_store));
  gtk_widget_show(my_tree_view);
  gtk_container_add(GTK_CONTAINER(tree_scrolled), my_tree_view);
  /*  gtk_fixed_put(GTK_FIXED(fixed_main), my_tree_view, 20, 200);
      gtk_widget_set_usize(my_tree_view, 100, 100);*/
  renderer1 = gtk_cell_renderer_text_new();
  renderer2 = gtk_cell_renderer_text_new();
  column_umid = gtk_tree_view_column_new_with_attributes("UM ID", renderer1,
							 "text",
							 0,
							 /*"foreground",
							   COLOR_COLUMN,*/
							 NULL);
  column_fingerprint = gtk_tree_view_column_new_with_attributes("Fingerprint",
								renderer2,
								"text",
								1,
								/*"foreground",
								  COLOR_COLUMN,*/
								NULL);
  /*gtk_tree_view_column_set_visible(column_umid, TRUE);
    gtk_tree_view_column_set_visible(column_fingerprint, TRUE);*/
  gtk_tree_view_append_column(GTK_TREE_VIEW(my_tree_view), GTK_TREE_VIEW_COLUMN(column_umid));
  gtk_tree_view_append_column(GTK_TREE_VIEW(my_tree_view), GTK_TREE_VIEW_COLUMN(column_fingerprint));
  /*gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(my_tree_view), TRUE);*/




  fixed5 = gtk_fixed_new ();
  gtk_widget_ref (fixed5);
  g_object_set_data_full ((GObject *)um_init_window, "fixed5", fixed5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fixed5);
  gtk_container_add (GTK_CONTAINER (key_frame), fixed5);

  /*clist1 = gtk_clist_new (2);
  gtk_widget_ref (clist1);
  gtk_object_set_data_full (GTK_OBJECT (um_init_window), "clist1", clist1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (clist1);
  gtk_fixed_put (GTK_FIXED (fixed5), clist1, 8, 8);
  gtk_widget_set_uposition (clist1, 8, 8);
  gtk_widget_set_usize (clist1, 352, 160);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
  gtk_clist_column_titles_show (GTK_CLIST (clist1));*/

  label4 = gtk_label_new ("UM ID");
  gtk_widget_ref (label4);
  g_object_set_data_full ((GObject *)um_init_window, "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  /*gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label4);*/

  label5 = gtk_label_new ("Fingerprint");
  gtk_widget_ref (label5);
  g_object_set_data_full ((GObject *)um_init_window, "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  /*gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label5);*/

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox1);
  g_object_set_data_full ((GObject *)um_init_window, "hbuttonbox1", hbuttonbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox1);
  gtk_fixed_put (GTK_FIXED (fixed5), hbuttonbox1, 8, 176);
  /*gtk_widget_set_uposition (hbuttonbox1, 8, 176);*/
  gtk_widget_set_size_request (hbuttonbox1, 352, 32);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_SPREAD);

  add_button = gtk_button_new_with_label ("Add ...");
  gtk_widget_ref (add_button);
  g_object_set_data_full ((GObject *)um_init_window, "add_button", add_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (add_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), add_button);
  GTK_WIDGET_SET_FLAGS (add_button, GTK_CAN_DEFAULT);

  edit_button = gtk_button_new_with_label ("Edit ...");
  gtk_widget_ref (edit_button);
  g_object_set_data_full ((GObject *)um_init_window, "edit_button", edit_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), edit_button);
  GTK_WIDGET_SET_FLAGS (edit_button, GTK_CAN_DEFAULT);

  delete_button = gtk_button_new_with_label ("Delete");
  gtk_widget_ref (delete_button);
  g_object_set_data_full ((GObject *)um_init_window, "delete_button", delete_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (delete_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), delete_button);
  GTK_WIDGET_SET_FLAGS (delete_button, GTK_CAN_DEFAULT);

  id_frame = gtk_frame_new ("Choose An Identity");
  gtk_widget_ref (id_frame);
  g_object_set_data_full ((GObject *)um_init_window, "id_frame", id_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id_frame);
  gtk_fixed_put (GTK_FIXED (fixed_main), id_frame, 16, 135);
  /*gtk_widget_set_uposition (id_frame, 16, 88);*/
  gtk_widget_set_size_request (id_frame, 415, 77);

  vbox1 = gtk_vbox_new (FALSE, 3);
  gtk_widget_ref (vbox1);
  g_object_set_data_full ((GObject *)um_init_window, "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (id_frame), vbox1);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 3);

  hbox4 = gtk_hbox_new (FALSE, 5);
  gtk_widget_ref (hbox4);
  g_object_set_data_full ((GObject *)um_init_window, "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox4, TRUE, TRUE, 0);

  id_combo = gtk_combo_new ();
  gtk_widget_ref (id_combo);
  g_object_set_data_full ((GObject *)um_init_window, "id_combo", id_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id_combo);
  gtk_box_pack_start (GTK_BOX (hbox4), id_combo, TRUE, TRUE, 0);

  id_combo_entry = GTK_COMBO (id_combo)->entry;
  gtk_widget_ref (id_combo_entry);
  g_object_set_data_full ((GObject *)um_init_window, "id_combo_entry", id_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id_combo_entry);

  delete_id_button = gtk_button_new_with_label(" Delete ");
  gtk_widget_show(delete_id_button);
  gtk_box_pack_start(GTK_BOX(hbox4), delete_id_button, FALSE, FALSE, 0);

  generate_button = gtk_button_new_with_label ("Generate ...");
  gtk_widget_ref (generate_button);
  g_object_set_data_full ((GObject *)um_init_window, "generate_button", generate_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (generate_button);
  gtk_box_pack_start (GTK_BOX (hbox4), generate_button, FALSE, FALSE, 0);
  /*gtk_container_set_border_width (GTK_CONTAINER (generate_button), 2);*/

  id_fingerprint = gtk_entry_new ();
  gtk_widget_ref (id_fingerprint);
  g_object_set_data_full ((GObject *)um_init_window, "id_fingerprint", id_fingerprint,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id_fingerprint);
  gtk_box_pack_start (GTK_BOX (vbox1), id_fingerprint, FALSE, FALSE, 0);

  directory_frame = gtk_frame_new ("Select Load/Save Directory");
  gtk_widget_ref (directory_frame);
  g_object_set_data_full ((GObject *)um_init_window, "directory_frame", directory_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (directory_frame);
  gtk_fixed_put (GTK_FIXED (fixed_main), directory_frame, 16, 35);
  /*gtk_widget_set_uposition (directory_frame, 16, 32);*/
  gtk_widget_set_size_request (directory_frame, 415, 90);

  table = gtk_table_new (2, 2, FALSE);
  /*hbox3 = gtk_hbox_new (FALSE, 3);*/
  gtk_widget_ref (table);
  g_object_set_data_full ((GObject *)um_init_window, "table", table,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table);

  gtk_container_add (GTK_CONTAINER (directory_frame), table);


  default_checkbox = gtk_check_button_new_with_mnemonic("Use the default load/save directory");
  gtk_widget_ref (default_checkbox);
  g_object_set_data_full ((GObject *)um_init_window, "default_checkbox",
			 default_checkbox, (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(default_checkbox);
  /*gtk_table_attach_defaults(GTK_TABLE(table), default_checkbox, 0, 1, 1, 2);*/
  gtk_table_attach_defaults(GTK_TABLE(table), default_checkbox, 0, 1, 0, 1);


  directory_entry = gtk_entry_new ();
  gtk_widget_ref (directory_entry);
  g_object_set_data_full ((GObject *)um_init_window, "directory_entry", directory_entry,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_size_request (directory_entry, 280, 25);
  gtk_widget_show (directory_entry);
  /*gtk_table_attach_defaults(GTK_TABLE(table), directory_entry, 0, 1, 0, 1);*/
  gtk_table_attach_defaults(GTK_TABLE(table), directory_entry, 0, 1, 1, 2);

  select_button = gtk_button_new_with_label ("Select ...");
  gtk_widget_ref (select_button);
  g_object_set_data_full ((GObject *)um_init_window, "select_button", select_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_set_size_request (select_button, 50, 35);
  gtk_widget_show (select_button);
  /*gtk_table_attach_defaults(GTK_TABLE(table), select_button, 1, 2, 0, 1);*/
  gtk_table_attach_defaults(GTK_TABLE(table), select_button, 1, 2, 1, 2);
  gtk_container_set_border_width (GTK_CONTAINER (select_button), 5);



  g_signal_connect(GTK_OBJECT(um_init_window), "destroy",
                      (GtkSignalFunc)um_init_window_destroyed, um_init_window);

  g_signal_connect(GTK_OBJECT( select_button ), "clicked",
                     (GtkSignalFunc) select_button_clicked, NULL);

  g_signal_connect(GTK_OBJECT(default_checkbox), "toggled",
		   (GtkSignalFunc) default_checkbox_clicked,
		   directory_entry);


  g_signal_connect(GTK_OBJECT( generate_button ), "clicked",
                     (GtkSignalFunc) fake_generate_button_clicked, NULL);

  g_signal_connect(GTK_OBJECT( add_button ), "clicked",
                     (GtkSignalFunc) add_button_clicked, NULL);

  g_signal_connect(GTK_OBJECT( edit_button ), "clicked",
                     (GtkSignalFunc) edit_button_clicked, NULL);


  g_signal_connect(GTK_OBJECT( delete_button ), "clicked",
                     (GtkSignalFunc) delete_button_clicked, NULL);

  g_signal_connect(GTK_OBJECT(delete_id_button), "clicked",
                     (GtkSignalFunc)delete_id_button_clicked, NULL);

  g_signal_connect(GTK_OBJECT( id_combo_entry ), "changed",
                      (GtkSignalFunc) combo_entry_changed, NULL);

  g_signal_connect(GTK_OBJECT( ok_button ), "clicked",
                      (GtkSignalFunc)ok_button_clicked, NULL);

  /*g_signal_connect(GTK_OBJECT( help_button ), "clicked",
    (GtkSignalFunc)um_enc_help_button_clicked, NULL);*/

  g_signal_connect(GTK_OBJECT(keydb_button), "clicked",
                     (GtkSignalFunc)keydb_button_clicked, NULL);

  g_signal_connect(GTK_OBJECT(check_for_newer_version1), "activate",
                     (GtkSignalFunc)check_newer_clicked, NULL);

  g_signal_connect(GTK_OBJECT(export_buddy_key_1), "activate",
                     (GtkSignalFunc)export_buddy_key_clicked, NULL);

  g_signal_connect(GTK_OBJECT(import_buddy_key_1), "activate",
                     (GtkSignalFunc)import_buddy_key_clicked, NULL);

  g_signal_connect(GTK_OBJECT(what_is_the__load_save_directory__1), "activate",
                     (GtkSignalFunc)what_is_load_save_clicked, NULL);

  g_signal_connect(GTK_OBJECT(what_is_an__encryption_id__1), "activate",
                     (GtkSignalFunc)what_is_id_clicked, NULL);

  g_signal_connect(GTK_OBJECT(what_is_the__buddy_id_database__1), "activate",
                     (GtkSignalFunc)what_is_buddy_id_db_clicked, NULL);

  g_signal_connect(GTK_OBJECT(debug_menu), "activate",
                     (GtkSignalFunc)enable_debug_clicked, NULL);

  g_signal_connect(GTK_OBJECT(tor_menu), "activate",
                     (GtkSignalFunc)tor_menu_clicked, NULL);


  gtk_editable_set_editable( GTK_EDITABLE( directory_entry ), FALSE );
  gtk_editable_set_editable( GTK_EDITABLE( id_fingerprint ), FALSE );

  gtk_widget_set_sensitive( generate_button, FALSE );
  gtk_widget_set_sensitive( id_combo, FALSE );
  gtk_widget_set_sensitive( id_fingerprint, FALSE );
  gtk_widget_set_sensitive( ok_button, FALSE );


  if (!bc_get_default_dir(default_dir, sizeof(default_dir))) {
    bc_dialog("Could not get default directory!", GTK_MESSAGE_ERROR, NULL);
    gtk_widget_set_sensitive(default_checkbox, FALSE);
  } else if (bc_does_dir_exist(default_dir) == 1)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(default_checkbox), TRUE);


  /* If the default directory is known, put it on the checkbox text. IE:
  * 'Use the default load/save directory (/home/jdog/.blackchatgaim)' */
  if (strcmp(default_dir, "") != 0) {
    GtkTooltips *tips = gtk_tooltips_new();
    gtk_tooltips_set_tip(tips, default_checkbox, default_dir, NULL);
  }
  return um_init_window;
}

void um_init_window_destroyed(GtkWidget *widget, gpointer data) {
  exit(666);
}


void tor_menu_clicked(GtkWidget *widget, gpointer data) {
  show_torui();
}

void enable_debug_clicked(GtkWidget *widget, gpointer data) {
  /*GtkWidget *dialog = NULL;*/
  /*GtkCheckMenuItem *debug_enabled = (GtkCheckMenuItem *)data;*/
  unsigned int state = (unsigned int)gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(debug_menu));
  const gchar *load_save_dir = (gchar *)gtk_entry_get_text(GTK_ENTRY(directory_entry));
  GString *string = g_string_new(load_save_dir);
  g_string_append_printf(string, "%s%s", SLASH_CHAR, "enable_debugging");
  int fd = 0;

  if (g_strcasecmp(load_save_dir, _("")) == 0) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(debug_menu), FALSE);
    bc_dialog("You must set the load/save directory first!",
	      GTK_MESSAGE_ERROR, NULL);
    g_string_free(string, TRUE);  string = NULL;
    return;
  }

  if (state == 1) {

    if (bc_is_regular_file(string->str) != 0) {
      g_string_free(string, TRUE);  string = NULL;
      return;
    } else {
      fd = creat(string->str, S_IREAD | S_IWRITE);
      if (fd < 0) {
	bc_dialog("Error while creating debug flag!", GTK_MESSAGE_ERROR, NULL);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(debug_menu), FALSE);
      } else {
	close(fd);  fd = 0;
	g_string_free(string, TRUE);  string = NULL;
	
	string = g_string_new("Log messages will be sent to \"");
	g_string_append_printf(string, "%s%s%s\"",
			       load_save_dir, SLASH_CHAR, "log.txt");
	
	bc_dialog(string->str, GTK_MESSAGE_INFO, NULL);
	bc_dialog("You must restart Scatter Chat so that the changes take effect.  Scatter Chat will now exit.", GTK_MESSAGE_INFO, NULL);
	exit(0);
      }
    }

  } else {

    
      GtkWidget *dialog = NULL;
      gint response = 0;

    /* Under Windows, open files can't be deleted, so kill the module now.  We
     * call exit() below, so this isn't a big deal. */
    mod_quit();

      /* Kill the 'enable_debugging' file so that logging is no longer done
       * (effective after module is restarted). */
    bc_delete_file(string->str);

      g_string_free(string, TRUE);  string = NULL;

      /* If a log file exists there already, prompt the user to see if it
       * should be deleted. */
      string = g_string_new(load_save_dir);
      g_string_append_printf(string, "%s%s", SLASH_CHAR, "log.txt");

      if (bc_is_regular_file(string->str) == 1) {
	dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "A log file exists in your load/save directory.  Would you like to remove it?");
	response = gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);  dialog = NULL;

	if (response == GTK_RESPONSE_YES)
        bc_delete_file(string->str);

	g_string_free(string, TRUE);  string = NULL;
      }

      bc_dialog("You must restart Scatter Chat so that the changes take effect.  Scatter Chat will now exit.", GTK_MESSAGE_INFO, NULL);
      exit(0);
    }

  g_string_free(string, TRUE);  string = NULL;

    //g_string_new();

    /*int response = 0;

    dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "Debug mode is an advanced feature, and should only be enabled by experienced users.  If you are not careful with it, you may expose sensitive information.  Are you sure you would like to enable debugging mode?");
    response = gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);

    if (response == GTK_RESPONSE_YES) {
      GtkWidget *log_dialog = gtk_file_selection_new("Enter a location to place the debugging log file:");
      g_signal_connect(
		 GTK_OBJECT(GTK_FILE_SELECTION(log_dialog)->ok_button),
		 "clicked", (GtkSignalFunc)log_dialog_ok_button_clicked,
		 log_dialog);

      g_signal_connect(
		 GTK_OBJECT(GTK_FILE_SELECTION(log_dialog)->cancel_button),
		 "clicked", (GtkSignalFunc)gtk_widget_destroy,
		 log_dialog);


      *gtk_window_set_modal(GTK_WINDOW(log_dialog), TRUE);*
      gtk_widget_show(log_dialog);
    } else {
      gtk_check_menu_item_set_active(debug_enabled, FALSE);
    }*/
}

/*void log_dialog_ok_button_clicked(GtkWidget *widget, gpointer data) {
  int ret = 0;
  GtkWidget *log_dialog = (GtkWidget *)data;
  gchar *log_path = (gchar *)gtk_file_selection_get_filename(GTK_FILE_SELECTION(log_dialog));

  char buffer[ 256 ];

  memset(buffer, 0, sizeof(buffer));

  mod_quit();
  ret = bc_spawnprog(log_path);
  if (ret == 0) {
     bc_dialog("Error while loading encryption module!  Program terminating...", GTK_MESSAGE_ERROR, NULL);
     exit(666);
  }

  * Read in the mod version & API version and discard it. *
  mod_readline(buffer, sizeof(buffer) - 8);
  mod_readline(buffer, sizeof(buffer) - 8);

  *reset_crypto_init_ui();*
  if (load_save_dir_selected((char *)gtk_entry_get_text(GTK_ENTRY(directory_entry))) < 0) {
      bc_dialog("Error while loading default load/save directory!",
		GTK_MESSAGE_ERROR, NULL);
      exit(666);
  }

  gtk_widget_destroy(log_dialog);
}*/

void export_buddy_key_clicked(GtkWidget *widget, gpointer data) {
  /*gtk_window_set_modal(GTK_WINDOW(um_init_window), FALSE);*/
  show_export_window(idnames_list, idfp_list);
  /*gtk_window_set_modal(GTK_WINDOW(um_init_window), TRUE);*/
}


void import_buddy_key_clicked(GtkWidget *widget, gpointer data) {
  import_dialog = gtk_file_selection_new("Enter the key file to import.");
  g_signal_connect(
		 GTK_OBJECT(GTK_FILE_SELECTION(import_dialog)->ok_button),
		 "clicked", (GtkSignalFunc)import_dialog_ok_button_clicked,
		 import_dialog);

  g_signal_connect(
		 GTK_OBJECT(GTK_FILE_SELECTION(import_dialog)->cancel_button),
		 "clicked", (GtkSignalFunc)import_dialog_cancel_button_clicked,
		 import_dialog);


  gtk_window_set_modal(GTK_WINDOW(import_dialog), TRUE);
  gtk_widget_show(import_dialog);
}

void import_dialog_ok_button_clicked(GtkWidget *widget, gpointer data) {
  GString *string = NULL;
  FILE *hFile = NULL;
  gchar *file_path = (gchar *)gtk_file_selection_get_filename(GTK_FILE_SELECTION(import_dialog));

  if (!(hFile = fopen(file_path, "r"))) {
    string = g_string_new(NULL);
    g_string_append_printf(string, "Could not open '%s' for reading!",
			   file_path);
    bc_dialog(string->str, GTK_MESSAGE_ERROR, NULL);
    g_string_free(string, TRUE);  string = NULL;
  } else {
    char *id = NULL;
    char *title = NULL;
    char *fp = NULL;
    char *ptr = NULL;

    char buffer[ 256 ];

    memset(buffer, 0, sizeof(buffer));

    fread(buffer, sizeof(char), sizeof(buffer) - 8, hFile);

    id = buffer;
    ptr = strchr(id, '|');
    if (ptr != NULL) {
      *ptr = '\0';

      title = ptr + 1;
      ptr = strchr(title, '|');
      if (ptr != NULL) {
	*ptr = '\0';
	fp = ptr + 1;
      }

    }

    if ((title != NULL) && (fp != NULL) &&
	bc_is_key_fingerprint_valid(fp) &&
	(strcmp(title, "") != 0)) {
      GtkWidget *dialog = NULL;
      int response = 0;

      string = g_string_new(NULL);
      g_string_append_printf(string, "This key file claims to belong to '%s'.  If you are confident that this key file has not been modified since it was created, then it is safe to import.  Are you sure you would like to import this key?", title);

      dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL,
				      GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO,
				      string->str);
      response = gtk_dialog_run(GTK_DIALOG(dialog));
      gtk_widget_destroy(dialog);
      g_string_free(string, TRUE); string = NULL;


      if (response == GTK_RESPONSE_YES) {
	
	mod_write("ADD_KEY ");
	mod_write(title);
	mod_write("|");
	mod_writeln(fp);

	mod_readline(buffer, strlen(buffer) - 1);
	if (strstr(buffer, "OK") != buffer)
	  bc_dialog(buffer, GTK_MESSAGE_ERROR, NULL);
	else {
	  buddynames_list = g_list_append(buddynames_list, g_strdup(title));
	  buddyfp_list = g_list_append(buddyfp_list, g_strdup(fp));
	  load_key_database_into_ui();
	  bc_dialog("Key imported successfully!", GTK_MESSAGE_INFO, NULL);
	}


      } else {
	bc_dialog("Key import cancelled.", GTK_MESSAGE_ERROR, NULL);
      }

    } else {
      bc_dialog("This key file is corrupt and will not be loaded.", GTK_MESSAGE_ERROR, NULL);
    }

  }

  gtk_widget_destroy(import_dialog);
}

void import_dialog_cancel_button_clicked(GtkWidget *widget, gpointer data) {
  gtk_widget_destroy(import_dialog);
}



void default_checkbox_clicked(GtkWidget *widget, gpointer data) {

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))) {
    char default_dir[ 256 ];

    memset(default_dir, 0, sizeof(default_dir));

    if (!bc_get_default_dir(default_dir, sizeof(default_dir))) {
      bc_dialog("Could not get default directory!", GTK_MESSAGE_ERROR, NULL);
      return;
    }

    reset_crypto_init_ui();

    if (bc_does_dir_exist(default_dir) == 0)
      bc_create_dir(default_dir);

    gtk_widget_set_sensitive(select_button, FALSE);

    if (load_save_dir_selected(default_dir) < 0) {
      bc_dialog("Error while loading default load/save directory!",
		GTK_MESSAGE_ERROR, NULL);
      reset_crypto_init_ui();
    }
  } else {
    bc_remove_dir((char *)gtk_entry_get_text(GTK_ENTRY((GtkWidget *)data)));
    reset_crypto_init_ui();
    /*
    gtk_entry_set_text(GTK_ENTRY((GtkWidget *)data), "");
    gtk_widget_set_sensitive(select_button, TRUE);*/
  }

}


void window_destroy(GtkWidget *widget, gpointer data) {
  um_init_window = NULL;
  gtk_main_quit();
}


void combo_entry_changed(GtkWidget *widget, gpointer data) {
  unsigned int found = 0;
  unsigned int i = 0;
  char *id_name = (char *)gtk_entry_get_text(GTK_ENTRY(id_combo_entry));

  selected_id_index = -1;

  /* If the user removed all the text in the ID combo entry, then disable
   * the 'Generate' button since we need at least _some_ text to generate the
   * key's filename with. */
  if (strcmp(id_name, "") == 0) {
    gtk_entry_set_text(GTK_ENTRY(id_fingerprint), "");
    gtk_widget_set_sensitive(generate_button, FALSE);
    gtk_widget_set_sensitive(delete_id_button, FALSE);
    gtk_widget_set_sensitive(ok_button, FALSE);
    return;
  }


  for (i = 0; (i < g_list_length(idnames_list)) && (found == 0); i++) {
    if (strcmp(g_list_nth_data(idnames_list, i), id_name) == 0) {
      gtk_entry_set_text(GTK_ENTRY(id_fingerprint), 
			 g_list_nth_data(idfp_list, i));
      gtk_widget_set_sensitive(generate_button, FALSE);
      gtk_widget_set_sensitive(ok_button, TRUE);
      gtk_widget_set_sensitive(delete_id_button, TRUE);

      selected_id_index = i;
      found = 1;
    }
  }

  if (found == 0) {
    gtk_entry_set_text(GTK_ENTRY(id_fingerprint), "");
    gtk_widget_set_sensitive(generate_button, TRUE);
    gtk_widget_set_sensitive(ok_button, FALSE);
    gtk_widget_set_sensitive(delete_id_button, FALSE);
  }

}



void keydb_button_clicked(GtkWidget *widget, gpointer data) {
  G_CONST_RETURN gchar *label_text = gtk_button_get_label(GTK_BUTTON(widget));
  if (strstr(label_text, "[+]") != NULL) {
    gtk_button_set_label(GTK_BUTTON(widget),
			 _("[-] Hide Database"));
    gtk_widget_show(GTK_WIDGET(key_frame));
    gtk_widget_show(GTK_WIDGET(tree_viewport));

    gtk_fixed_move(GTK_FIXED(fixed_main), frame_buttonbox, 16, 465);

    gtk_widget_hide(um_init_window);

#ifndef _WIN32
    gtk_window_set_resizable(GTK_WINDOW(um_init_window), TRUE);
    gtk_widget_set_size_request(um_init_window, 445, 525);
#endif

    gtk_window_resize(GTK_WINDOW(um_init_window), 445, 525);

#ifndef _WIN32
    gtk_window_set_resizable(GTK_WINDOW (um_init_window), FALSE);
#endif

    gtk_widget_show(um_init_window);

    gtk_window_set_position (GTK_WINDOW (um_init_window), GTK_WIN_POS_CENTER);

    /*gtk_widget_hide(um_init_window);
    gtk_window_set_position (GTK_WINDOW (um_init_window), GTK_WIN_POS_CENTER);
    gtk_widget_show(um_init_window);*/

  } else {
    gtk_button_set_label(GTK_BUTTON(widget),
			 _("[+] Show Database"));
    gtk_widget_hide(GTK_WIDGET(key_frame));
    gtk_widget_hide(GTK_WIDGET(tree_viewport));
    gtk_fixed_move(GTK_FIXED (fixed_main), frame_buttonbox, 16, 220);

    gtk_widget_hide(um_init_window);


#ifndef _WIN32
    gtk_window_set_resizable(GTK_WINDOW(um_init_window), TRUE);
    gtk_widget_set_size_request(um_init_window, 445, 280);
#endif

    gtk_window_resize(GTK_WINDOW(um_init_window), 445, 280);

#ifndef _WIN32
    gtk_window_set_resizable(GTK_WINDOW (um_init_window), FALSE);
#endif

    gtk_window_set_position (GTK_WINDOW (um_init_window), GTK_WIN_POS_CENTER);
    gtk_widget_show(um_init_window);

  }

}


void ok_button_clicked(GtkWidget *widget, gpointer data) {
  char *id = NULL;

  char buffer[ 256 ];
  char pwbuf[ 256 ];

  memset(buffer, 0, sizeof(buffer));
  memset(pwbuf, 0, sizeof(pwbuf));

  id = (char *)gtk_entry_get_text(GTK_ENTRY(id_combo_entry));
  get_id_pw(pwbuf, sizeof(pwbuf) - 8);

  if (strlen(pwbuf) == 0)
    return;

  /*printf("Password entered was [%s]\n", pwbuf);*/

  mod_write("SELECT_USER ");
  mod_write(id);
  mod_write("|");
  mod_writeln(pwbuf);

  mod_readline(buffer, sizeof(buffer) - 1);
  if (strstr(buffer, "OK") != buffer) {
    /*printf("[%s]\n", buffer);*/
    bc_dialog("Error while loading identity.  This is probably caused by an invalid password.", GTK_MESSAGE_ERROR, NULL);
    return;
  }

  if (bc_do_tor_stuff() < 0)
    return;

  gtk_widget_hide(um_init_window);
  gtk_main_quit();

  return;
}



void um_enc_help_button_clicked(GtkWidget *widget, gpointer data) {


  char message[ 1024 ];
 
  memset(message, 0, sizeof(message));

  
  g_strlcat(message, "Select Load/Save Directory:\n\n\t", sizeof(message));
  g_strlcat(message, "This specifies the directory where you want to load and\n\t", sizeof(message));
  g_strlcat(message, "save your encryption keys (*.um) and key database\n\t", sizeof(message));
  g_strlcat(message, "(um_keycache).  If this is your first time running\n\t", sizeof(message));
  g_strlcat(message, "Ultramagnetic, then you can use any empty directory where\n\t", sizeof(message));
  g_strlcat(message, "you have full read and write access to.  However, do NOT\n\t", sizeof(message));
  g_strlcat(message, "use a shared directory (like '/tmp' on UNIX) since these\n\t", sizeof(message));
  g_strlcat(message, "files are extremely sensitive.\n\n\t", sizeof(message));
  g_strlcat(message, "To choose a directory, click on the 'Select' button, then\n\t", sizeof(message));
  g_strlcat(message, "navigate into the directory of choice, and click 'OK'.\n\t", sizeof(message));
  g_strlcat(message, "You do not need to double click any particular file.", sizeof(message));

  bc_dialog(message, GTK_MESSAGE_INFO, um_init_window);

  memset(message, 0, sizeof(message));

  g_strlcat(message, "Choose An Identity:\n\n\t", sizeof(message));
  g_strlcat(message, "If this is your first time running Ultramagnetic:\n\n\t", sizeof(message));
  g_strlcat(message, "After selecting the Load/Save directory, the edit box\n\t", sizeof(message));
  g_strlcat(message, "will become enabled and the drop-down box will be empty.\n\t ", sizeof(message));
  g_strlcat(message, "In the edit box, type a short name, then click 'Generate'.\n\t", sizeof(message));
  g_strlcat(message, "Ultramagnetic will then begin generating your encryption\n\t", sizeof(message));
  g_strlcat(message, "key.  This may take a minute or two and the interface may\n\t", sizeof(message));
  g_strlcat(message, "appear frozen during this time.  After it is generated,\n\t", sizeof(message));
  g_strlcat(message, "the key will be written to the Load/Save directory that\n\t", sizeof(message));
  g_strlcat(message, "you chose before.\n\n\t", sizeof(message));
  g_strlcat(message, "Now that you have a key generated, you may now proceed to\n\t", sizeof(message));
  g_strlcat(message, "sign on to an instant messaging service just like you\n\t", sizeof(message));
  g_strlcat(message, "normally would.\n\t", sizeof(message));

  bc_dialog(message, GTK_MESSAGE_INFO, um_init_window);

  memset(message, 0, sizeof(message));
  g_strlcat(message, "Choose An Identity:\n\n\t", sizeof(message));
  g_strlcat(message, "If you've already generated a key with Ultramagnetic:\n\n\t", sizeof(message));
  g_strlcat(message, "After selecting the Load/Save directory, the drop-down box\n\t", sizeof(message));
  g_strlcat(message, "will be filled with the name you chose for your key during\n\t", sizeof(message));
  g_strlcat(message, "the generation process.  At this point, you may proceed to\n\t", sizeof(message));
  g_strlcat(message, "log onto an instant messaging service.\n\n\t", sizeof(message));
  g_strlcat(message, "Optionally, you can also generate more keys.  Each new key\n\t", sizeof(message));
  g_strlcat(message, "that you generate will be saved in the Load/Save directory\n\t", sizeof(message));
  g_strlcat(message, "and added to the drop-down list.\n", sizeof(message));

  bc_dialog(message, GTK_MESSAGE_INFO, um_init_window);

  return;
}


void add_button_clicked(GtkWidget *widget, gpointer data) {
  struct DATABASE_ENTRY database_entry;
  char buffer[ 256 ];

  memset(&database_entry, 0, sizeof(struct DATABASE_ENTRY));
  memset(buffer, 0, sizeof(buffer));

  new_entry_window = create_new_entry_window(&database_entry);
  gtk_widget_show(new_entry_window);
  gtk_main();

  if ((strcmp(database_entry.umid, "") != 0) &&
      (strcmp(database_entry.fingerprint, "") != 0)) {
    /*printf("KEY_DATABASE_ADD!\n");*/
    /*key_database_add(database_entry.umid, database_entry.fingerprint,
		     temp_database_path);
		     load_key_database_into_ui(temp_database_path);*/
    mod_write("ADD_KEY ");
    mod_write(database_entry.umid);
    mod_write("|");
    mod_writeln(database_entry.fingerprint);

    mod_readline(buffer, strlen(buffer) - 1);
    if (strstr(buffer, "OK") != buffer)
      bc_dialog(buffer, GTK_MESSAGE_ERROR, NULL);
    else {

      /* Add the new name and fingerprint to the internal list, then add them
       * to the UI. */
      buddynames_list =
	g_list_append(buddynames_list, g_strdup(database_entry.umid));
      buddyfp_list =
	g_list_append(buddyfp_list, g_strdup(database_entry.fingerprint));
      
      load_key_database_into_ui();

    }
  }

}


void edit_button_clicked(GtkWidget *widget, gpointer data) {
  GtkTreeSelection *selection = NULL;
  gboolean b = FALSE;
  unsigned int i = 0;
  unsigned int found = 0;

  struct DATABASE_ENTRY database_entry;
  GtkTreeIter iter;
  char buffer[ 256 ];

  memset(&database_entry, 0, sizeof(struct DATABASE_ENTRY));
  memset(&iter, 0, sizeof(GtkTreeIter));
  memset(buffer, 0, sizeof(buffer));

  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(my_tree_view));

  b = gtk_tree_selection_get_selected(selection, NULL, &iter);
  if (b == TRUE) {
    gchar *umid = NULL;
    gchar *fingerprint = NULL;
    gtk_tree_model_get(GTK_TREE_MODEL(database_list_store), &iter,
		       0, &umid, 1, &fingerprint, -1);

    g_strlcpy(database_entry.umid, umid, sizeof(database_entry.umid));
    g_strlcpy(database_entry.fingerprint, fingerprint,
	      sizeof(database_entry.fingerprint));

    new_entry_window = create_new_entry_window(&database_entry);
    gtk_widget_show(new_entry_window);
    gtk_main();

    if ((strcmp(database_entry.umid, "") != 0) &&
	(strcmp(database_entry.fingerprint, "") != 0)) {

      mod_write("DEL_KEY ");
      mod_write(umid);
      mod_write("|");
      mod_writeln(fingerprint);

      mod_readline(buffer, sizeof(buffer) - 1);
      if (strstr(buffer, "OK") != buffer) {
	/*printf("poop0rz: [%s]\n", buffer);*/
	bc_dialog(buffer, GTK_MESSAGE_ERROR, NULL);
	return;
      }

      /* Remove the UMID and fingerprint from the lists, then update the UI. */
      for (i = 0; (i < g_list_length(buddynames_list)) && (found == 0); i++) {
	if ((strcmp(g_list_nth_data(buddynames_list, i), umid) == 0) &&
	    (strcmp(g_list_nth_data(buddyfp_list, i), fingerprint) == 0)) {
	  gchar *name = (gchar *)g_list_nth_data(buddynames_list, i);
	  gchar *fp = (gchar *)g_list_nth_data(buddyfp_list, i);
	  buddynames_list = g_list_remove(buddynames_list, name);
	  buddyfp_list = g_list_remove(buddyfp_list, fp);

	  g_free(name);  name = NULL;
	  g_free(fp);  fp = NULL;

	  found = 1;
	}
      }

      mod_write("ADD_KEY ");
      mod_write(database_entry.umid);
      mod_write("|");
      mod_writeln(database_entry.fingerprint);

      mod_readline(buffer, sizeof(buffer) - 1);
      if (strstr(buffer, "OK") != buffer) {
	bc_dialog(buffer, GTK_MESSAGE_ERROR, NULL);
      } else {

	/* Add the new name and fingerprint to the internal list, then add them
	 * to the UI. */
	buddynames_list =
	  g_list_append(buddynames_list, g_strdup(database_entry.umid));
	buddyfp_list =
	  g_list_append(buddyfp_list, g_strdup(database_entry.fingerprint));
      

      }

      load_key_database_into_ui();

    }

    g_free(umid);  umid = NULL;
    g_free(fingerprint);  fingerprint = NULL;
  }



}


void check_newer_clicked(GtkWidget *widget, gpointer data) {
  GtkWidget *dialog = NULL;
  char buffer[ 16 ];

  memset(buffer, 0, sizeof(buffer));


  dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL,
				  GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO,
				  "Note!: By checking for the newest version with this feature, you will reveal to evesdroppers the fact that you are using this software.  Most users should have no fear of this, but some in sensitive situations would like to keep this detail secret.\n\nAre you sure you would like to check for the newest version?");
  gint response = gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);

  if (response == GTK_RESPONSE_YES) {
    gaim_url_fetch("http://www.scatterchat.com/latest.txt", TRUE, NULL, FALSE, check_newer_cb, NULL);
  } else
    bc_dialog("Request cancelled.", GTK_MESSAGE_INFO, NULL);

}


void check_newer_cb(void *d, const char *data, size_t len) {

  char *latest_version = (char *)data;
  int ret = 0;

  if ((latest_version == NULL) || (len == 0)) {
    gaim_notify_formatted(NULL, _("Error"), _("There has been an error:"), NULL, _("There has been an error while contacting http://www.scatterchat.com/latest.txt!"), NULL, NULL);
    return;
  }

  
  if ((ret = bc_check_new_version(latest_version, len)) == 0) {
    GString *string = g_string_new(NULL);
    g_string_append_printf(string, "A new version (%s) is now available from http://www.scatterchat.com/", latest_version);

    gaim_notify_formatted(NULL, _("New Version Available"),
			  _("New Version Available"), NULL, string->str,
			  NULL, NULL);

    g_string_free(string, TRUE);  string = NULL;
  } else if (ret == 1) {
    gaim_notify_formatted(NULL, _("Version Check"), _(""), NULL, _("You have the most up-to-date version available."), NULL, NULL);
  } else {

    gaim_notify_formatted(NULL, _("Version Check"), _("Error"), NULL, _("There was an error while determining if you have the latest version."), NULL, NULL);
  }

}


void delete_id_button_clicked(GtkWidget *widget, gpointer data) {
  char buffer[ 256 ];

  memset(buffer, 0, sizeof(buffer));

  char *id_name = (char *)gtk_entry_get_text(GTK_ENTRY(id_combo_entry));
  GtkWidget *dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL,
		      GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL,
		      "Are you sure you want to permanently delete the ID, '%s'?", id_name);
  gint response = gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);

  if (response == GTK_RESPONSE_OK) {
    mod_write("DEL_ID ");
    mod_writeln(id_name);
    mod_readline(buffer, sizeof(buffer) - 1);
    if (strstr(buffer, "OK") != buffer)
      bc_dialog(buffer, GTK_MESSAGE_ERROR, NULL);
    else {
      int i = 0;
      int found = 0;
      gchar *idfp = NULL;

      for (i = 0; (i < g_list_length(idnames_list)) && (found == 0); i++) {
	if (strcmp(g_list_nth_data(idnames_list, i), id_name) == 0) {
	  idfp = g_list_nth_data(idfp_list, i);
	  id_name = g_list_nth_data(idnames_list, i);
	  idnames_list = g_list_remove(idnames_list, id_name);
	  idfp_list = g_list_remove(idfp_list, idfp);

	  gtk_entry_set_text(GTK_ENTRY(id_combo_entry), _(""));
	  gtk_entry_set_text(GTK_ENTRY(id_fingerprint), _(""));
	  found = 1;
	}
      }

      if (found == 0) {
	bc_dialog("Error while deleting ID from window!",
		  GTK_MESSAGE_ERROR, NULL);
      } else
	gtk_combo_set_popdown_strings(GTK_COMBO(id_combo), idnames_list);


    }
  }

}


void delete_button_clicked(GtkWidget *widget, gpointer data) {
  GtkTreeSelection *selection = NULL;
  gboolean b = FALSE;
  gchar *umid = NULL;
  gchar *fingerprint = NULL;
  unsigned int i = 0;
  unsigned int found = 0;

  GtkTreeIter iter;
  char buffer[ 256 ];

  memset(&iter, 0, sizeof(GtkTreeIter));
  memset(buffer, 0, sizeof(buffer));

  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(my_tree_view));

  b = gtk_tree_selection_get_selected(selection, NULL, &iter);
  if (b == TRUE) {
    gtk_tree_model_get(GTK_TREE_MODEL(database_list_store), &iter,
		       0, &umid, 1, &fingerprint, -1);


    mod_write("DEL_KEY ");
    mod_write(umid);
    mod_write("|");
    mod_writeln(fingerprint);

    mod_readline(buffer, sizeof(buffer) - 1);
    if (strstr(buffer, "OK") != buffer) {
      bc_dialog(buffer, GTK_MESSAGE_ERROR, NULL);
      return;
    }

    /*
    printf("xxx!\n");
    for (i = 0; i < g_list_length(buddynames_list); i++) {
      printf("%u:  %s:%s\n", i,
	     (gchar *)g_list_nth_data(buddynames_list, i),
	     (gchar *)g_list_nth_data(buddyfp_list, i));
    }
    printf("xxx!\n");
    */

    /* Remove the UMID and fingerprint from the lists, then update the UI. */
    for (i = 0; (i < g_list_length(buddynames_list)) && (found == 0); i++) {
      if ((strcmp(g_list_nth_data(buddynames_list, i), umid) == 0) &&
	  (strcmp(g_list_nth_data(buddyfp_list, i), fingerprint) == 0)) {
	gchar *name = (gchar *)g_list_nth_data(buddynames_list, i);
	gchar *fp = (gchar *)g_list_nth_data(buddyfp_list, i);


	buddynames_list = g_list_remove(buddynames_list, name);
	buddyfp_list= g_list_remove(buddyfp_list, fp);

	g_free(name);  name = NULL;
	g_free(fp);  fp = NULL;

	found = 1;
      }
    }

    /*printf("yyy!\n");

    for (i = 0; i < g_list_length(buddynames_list); i++) {
      printf("%u:  %s:%s\n", i,
	     (gchar *)g_list_nth_data(buddynames_list, i),
	     (gchar *)g_list_nth_data(buddyfp_list, i));
    }
    printf("yyy!\n");*/

    load_key_database_into_ui();
  }


}


void fake_generate_button_clicked(GtkWidget *widget, gpointer data) {
  gchar *id_combo_entry_text = NULL;

  id_combo_entry_text = (gchar *)gtk_entry_get_text(GTK_ENTRY(id_combo_entry));

  if (strcmp(id_combo_entry_text, "") == 0) {
    bc_dialog("You must enter an ID to generate the key with!",
	      GTK_MESSAGE_ERROR, NULL);
  } else
    show_um_keygen_win();

}



void select_button_clicked(GtkWidget *widget, gpointer data) {
  GtkWidget *directory_dialog = NULL;

  directory_dialog = gtk_file_selection_new("Select a directory");
  g_signal_connect(
          GTK_OBJECT(GTK_FILE_SELECTION(directory_dialog)->ok_button),
          "clicked", (GtkSignalFunc)directory_dialog_ok, directory_dialog);

  g_signal_connect(
         GTK_OBJECT(GTK_FILE_SELECTION(directory_dialog)->cancel_button),
         "clicked", (GtkSignalFunc)directory_dialog_cancel, directory_dialog);


  gtk_window_set_modal(GTK_WINDOW(directory_dialog), TRUE);
  gtk_widget_show(directory_dialog);
}



void directory_dialog_cancel(GtkWidget *widget,
                             GtkObject *directory_dialog) {
  gtk_widget_destroy(GTK_WIDGET(directory_dialog));
}


int load_save_dir_selected(char *path) {
  unsigned int num_ids = 0;
  unsigned int num_fps = 0;
  unsigned int i = 0;
  char *pipe_pos = NULL;
  char *umid = NULL;
  char *idname = NULL;
  char *fingerprint = NULL;
  GString *string = NULL;

  char buffer[ 256 ];

  memset(buffer, 0, sizeof(buffer));

  /*idnames_list = NULL;
  idfp_list = NULL;
  buddynames_list = NULL;
  buddyfp_list = NULL;*/

  /*unsigned int state = (unsigned int)gtk_check_menu_item_get_active(debug_enabled);*/

  if (bc_prefs_load(path) < 0)
    gaim_debug(GAIM_DEBUG_ERROR, "bc_ui.c", "Error while loading preferences.\n");

  mod_write("INIT ");
  mod_writeln(path);
  mod_readline(buffer, sizeof(buffer) - 1);
  /*printf("init result: %s\n", buffer);*/
  if (strstr(buffer, "ERROR") != NULL) {
    bc_dialog("Error while initializing directory.",
	      GTK_MESSAGE_ERROR, NULL);
    goto load_save_dir_selected_error;
  }

  mod_readline(buffer, sizeof(buffer) - 1);
  num_ids = (unsigned int)atoi(buffer);

  for (i = 0; i < num_ids; i++) {
    mod_readline(buffer, sizeof(buffer) - 1);
    /*printf("buffer: %s\n", buffer);*/
    pipe_pos = strchr(buffer, '|');
    if (pipe_pos == NULL)
      goto load_save_dir_selected_error;

    *pipe_pos = '\0';
    idname = buffer;
    fingerprint = pipe_pos + 1;

    /*printf("id: %s\n", buffer);*/
    idnames_list = g_list_append(idnames_list, g_strdup(idname));
    idfp_list = g_list_append(idfp_list, g_strdup(fingerprint));
  }

  /* If we loaded at least one ID, then set the selected index to the first
   * in the list. */
  if (g_list_length(idfp_list) > 0)
    selected_id_index = 0;



  mod_readline(buffer, sizeof(buffer) - 1);
  num_fps = (unsigned int)atoi(buffer);

  for (i = 0; i < num_fps; i++) {
    mod_readline(buffer, sizeof(buffer) - 1);

    pipe_pos = strchr(buffer, '|');
    if (pipe_pos == NULL)
      goto load_save_dir_selected_error;

    *pipe_pos = '\0';
    umid = buffer;
    fingerprint = pipe_pos + 1;

    buddynames_list = g_list_append(buddynames_list, g_strdup(umid));

    buddyfp_list = g_list_append(buddyfp_list, g_strdup(fingerprint));

  }

  /* Now that we added to the buddy*_list, update the UI with them. */
  load_key_database_into_ui();

  gtk_entry_set_text(GTK_ENTRY(directory_entry), path);
  gtk_combo_set_popdown_strings(GTK_COMBO(id_combo), idnames_list);


  if (num_ids == 0)
      gtk_entry_set_text(GTK_ENTRY(id_combo_entry), "<Enter new name and click Generate>");


  gtk_widget_set_sensitive(id_combo, TRUE);
  gtk_widget_set_sensitive(id_fingerprint, TRUE);


  /* Activate the debug menu item if the "enable_debugging" flag is in this
   * load/save dir... */
  string = g_string_new(path);
  g_string_append_printf(string, "%s%s", SLASH_CHAR, "enable_debugging");


  if (bc_is_regular_file(string->str) == 1)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(debug_menu), TRUE);

  g_string_free(string, TRUE);


  return 1;

 load_save_dir_selected_error:
  return -1;
}

void directory_dialog_ok(GtkWidget *widget,
                         GtkObject *directory_dialog) {
  gchar *directory_path = NULL;

  directory_path = (gchar *)gtk_file_selection_get_filename(GTK_FILE_SELECTION( directory_dialog));

  if (load_save_dir_selected(directory_path) < 0)
    bc_dialog("Error while initializing load/save directory!",
	      GTK_MESSAGE_ERROR, NULL);
  else
    gtk_widget_destroy(GTK_WIDGET(directory_dialog));

  return;
}


void show_fingerprint_window(struct NEW_FP_STRUCT *new_fp_struct) {

  create_fingerprint_window(new_fp_struct);


  gdk_threads_enter();
  gtk_widget_show(um_fingerprint_window);
  gtk_widget_grab_focus(um_fingerprint_window);

  gtk_main();
  gdk_threads_leave();

}


void accept_button_clicked(GtkWidget *widget, gpointer data) {


  GtkWidget *popup_menu = NULL;
  GtkMenuItem *menu_item_cancel = NULL;
  GtkMenuItem *menu_item_temporarily = NULL;
  GtkMenuItem *menu_item_permanently = NULL;
  GtkWidget *menu_item_separator = NULL;
  GtkWidget *image_1 = NULL;
  GtkWidget *image_2 = NULL;
  GtkWidget *image_3 = NULL;
  struct NEW_FP_STRUCT *new_fp_struct = NULL;

  new_fp_struct = (struct NEW_FP_STRUCT *)data;


  /* Ensure that the UMID does not contain the pipe character, as this would
   * wreak havoc on the key database. */
  if (strchr(gtk_entry_get_text(GTK_ENTRY(entUMID)), '|') != NULL) {
    bc_dialog("UMID cannot contain the pipe ('|') character!",
	      GTK_MESSAGE_ERROR,
	      um_fingerprint_window);
    return;
  }


  /* When the user clicks the 'Accept' button, a popup menu appears which
   * prompts whether or not the key should be accepted permanently, or just
   * temporarily.  This feature also prevents the user from accidentally
   * accepting a key through a mis-click. */
  popup_menu = gtk_menu_new();

  /* The first item is a 'Cancel' option, which comes in handy if the user
   * accidentally clicked the 'Accept' button. */
  menu_item_cancel = GTK_MENU_ITEM(gtk_image_menu_item_new_with_mnemonic(_("Cancel")));
  gtk_widget_show(GTK_WIDGET(menu_item_cancel));
  gtk_container_add(GTK_CONTAINER(popup_menu), GTK_WIDGET(menu_item_cancel));

  image_1 = gtk_image_new_from_stock("gtk-cancel", GTK_ICON_SIZE_MENU);
  gtk_widget_show(image_1);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menu_item_cancel),
				image_1);

  /* After the 'Cancel' button is a menu separator (it appears as an inset
   * line).  This separates the Cancel option from the real options below. */
  menu_item_separator = gtk_menu_item_new();
  gtk_widget_show(menu_item_separator);
  gtk_container_add(GTK_CONTAINER(popup_menu), menu_item_separator);
  gtk_widget_set_sensitive(menu_item_separator, FALSE);

  menu_item_separator = gtk_menu_item_new();
  gtk_widget_show(menu_item_separator);
  gtk_container_add(GTK_CONTAINER(popup_menu), menu_item_separator);
  gtk_widget_set_sensitive(menu_item_separator, FALSE);


  /* Accept Temporarily. */
  menu_item_temporarily = GTK_MENU_ITEM(gtk_image_menu_item_new_with_mnemonic(_("Accept Temporarily")));
  gtk_widget_show(GTK_WIDGET(menu_item_temporarily));
  gtk_container_add(GTK_CONTAINER(popup_menu), GTK_WIDGET(menu_item_temporarily));


  menu_item_separator = gtk_menu_item_new();
  gtk_widget_show(menu_item_separator);
  gtk_container_add(GTK_CONTAINER(popup_menu), menu_item_separator);
  gtk_widget_set_sensitive(menu_item_separator, FALSE);

  menu_item_separator = gtk_menu_item_new();
  gtk_widget_show(menu_item_separator);
  gtk_container_add(GTK_CONTAINER(popup_menu), menu_item_separator);
  gtk_widget_set_sensitive(menu_item_separator, FALSE);


  image_2 = gtk_image_new_from_stock("gtk-apply", GTK_ICON_SIZE_MENU);
  gtk_widget_show(image_2);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menu_item_temporarily),
				image_2);


  /* Accept Permanently. */
  menu_item_permanently = GTK_MENU_ITEM(gtk_image_menu_item_new_with_mnemonic(_("Accept Permanently"))); 
  gtk_widget_show(GTK_WIDGET(menu_item_permanently));
  gtk_container_add(GTK_CONTAINER(popup_menu), GTK_WIDGET(menu_item_permanently));

  image_3 = gtk_image_new_from_stock("gtk-save", GTK_ICON_SIZE_MENU);
  gtk_widget_show(image_3);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menu_item_permanently),
				image_3);


  /* Catch signals that go to the two Accept options and call the right
   * function to deal with the event. */
  g_signal_connect (GTK_OBJECT(menu_item_temporarily), "activate",
                      GTK_SIGNAL_FUNC(menu_item_temporarily_selected),
                      data);
  g_signal_connect (GTK_OBJECT(menu_item_permanently), "activate",
                      GTK_SIGNAL_FUNC(menu_item_permanently_selected),
                      data);

  /* Cause the pop-up menu to appear where the user's mouse coordinates are. */
  gtk_menu_popup(GTK_MENU(popup_menu), NULL, NULL, NULL, NULL, 1, 0);
  

}



/* Called when the user clicks on the 'Accept Temporarily' menu option in the
 * New Fingerprint window. */
void menu_item_temporarily_selected(GtkWidget *widget, gpointer data) {
  struct NEW_FP_STRUCT *new_fp_struct = NULL;

  new_fp_struct = (struct NEW_FP_STRUCT *)data;

  /* Record the UMID that the user entered. */
  g_strlcpy(new_fp_struct->umid, gtk_entry_get_text(GTK_ENTRY(entUMID)),
	    sizeof(new_fp_struct->umid) - 8);

  new_fp_struct->trigger = 0;
  /*g_thread_join(new_fp_struct->thread);*/
  if (!g_source_remove(new_fp_struct->source_id)) {
    bc_dialog("Error removing source ID!", GTK_MESSAGE_INFO, NULL);
  }


  new_fp_struct->action = ACTION_ACCEPT_TEMPORARILY;
  /*printf("ACCEPTED TEMPORARILY!\n");*/

  gtk_widget_destroy(um_fingerprint_window);
  um_fingerprint_window = NULL;

  gtk_main_quit();
}



/* Called when the user clicks on the 'Accept Permanently' menu option in the
 * New Fingerprint window. */
void menu_item_permanently_selected(GtkWidget *widget, gpointer data) {
  struct NEW_FP_STRUCT *new_fp_struct = NULL;

  new_fp_struct = (struct NEW_FP_STRUCT *)data;

  new_fp_struct->trigger = 0;
  /*g_thread_join(new_fp_struct->thread);*/
  if (!g_source_remove(new_fp_struct->source_id)) {
    bc_dialog("Error removing source ID!", GTK_MESSAGE_INFO, NULL);
  }

  /* Record the UMID that the user entered. */
  g_strlcpy(new_fp_struct->umid, gtk_entry_get_text(GTK_ENTRY(entUMID)),
	    sizeof(new_fp_struct->umid) - 8);

  new_fp_struct->action = ACTION_ACCEPT_PERMANENTLY;
  /*printf("ACCEPTED PERMANENTLY!\n");*/

  gtk_widget_destroy(um_fingerprint_window);
  um_fingerprint_window = NULL;

  gtk_main_quit();
}



/* */
void reject_button_clicked(GtkWidget *widget, gpointer data) {

  struct NEW_FP_STRUCT *new_fp_struct = NULL;

  new_fp_struct = (struct NEW_FP_STRUCT *)data;

  new_fp_struct->trigger = 0;
  /*g_thread_join(new_fp_struct->thread);*/

  if (!g_source_remove(new_fp_struct->source_id)) {
    bc_dialog("Error removing source ID!", GTK_MESSAGE_INFO, NULL);
  }

  memset(new_fp_struct->umid, 0, sizeof(new_fp_struct->umid) - 8);
  new_fp_struct->action = ACTION_REJECT;

  gtk_widget_destroy(um_fingerprint_window);
  um_fingerprint_window = NULL;

  gtk_main_quit();
}



void show_um_init_window(unsigned int grab_mutex) {

  if (um_init_window == NULL)
    um_init_window = create_um_init_window();

  /*gtk_window_set_modal(GTK_WINDOW(um_init_window), TRUE);*/
  gtk_widget_show(um_init_window);

  if (grab_mutex == 1)
    gdk_threads_enter();

  gtk_main();

  if (grab_mutex == 1)
    gdk_threads_leave();
}



void show_um_keygen_win() {
  GtkWidget *um_keygen_win = NULL;

  um_keygen_win = create_um_keygen_win();
  gtk_widget_show(um_keygen_win);

  gtk_main();

}



GtkWidget *create_um_keygen_win() {
  GtkWidget *frame1;
  GtkWidget *fixed2;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *label1;
  GtkWidget *frame2;
  GtkWidget *fixed1;
  GtkWidget *label3;
  GtkWidget *pwframe;
  GtkWidget *fixed3;
  GtkWidget *fixed_main;

  um_keygen_win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (um_keygen_win), _("Key Generation"));
  gtk_window_set_position (GTK_WINDOW (um_keygen_win), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (um_keygen_win), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (um_keygen_win), FALSE);
  gtk_widget_set_size_request (um_keygen_win, 425, 420);

  fixed_main = gtk_fixed_new();
  gtk_widget_show (fixed_main);
  gtk_container_add (GTK_CONTAINER (um_keygen_win), fixed_main);


  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_fixed_put (GTK_FIXED (fixed_main), frame1, 0, 0);

  gtk_frame_set_label_align (GTK_FRAME (frame1), 0, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_NONE);

  fixed2 = gtk_fixed_new ();
  gtk_widget_show (fixed2);
  gtk_container_add (GTK_CONTAINER (frame1), fixed2);
  gtk_container_set_border_width (GTK_CONTAINER (fixed2), 9);

  label4 = gtk_label_new (_("You may use this window to generate a new identity with new encryption keys.  You need at least one identity in order to connect to an instant messaging service.\n\nIf you wish to create an identity for testing purposes only, you may create it now.  Otherwise, it is highly recommended that you create the new identity after your computer has been used for at least one hour (leaving it on for an hour by itself doesn't count!).  See the official documentation for more details."));
  gtk_widget_show (label4);
  gtk_fixed_put (GTK_FIXED (fixed2), label4, 0, 0);
  gtk_widget_set_usize (label4, 390, 145);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (label4), TRUE);


  pwframe = gtk_frame_new(_("Identity Password"));
  gtk_widget_set_size_request (pwframe, 400, 140);

  gtk_widget_show(pwframe);

  fixed3 = gtk_fixed_new();
  gtk_widget_show(fixed3);
  gtk_fixed_put (GTK_FIXED (fixed2), pwframe, 0, 160);


  gtk_container_add (GTK_CONTAINER(pwframe), fixed3);
  key_pw_entry_1 = gtk_entry_new ();
  gtk_widget_show (key_pw_entry_1);
  gtk_fixed_put (GTK_FIXED (fixed3), key_pw_entry_1, 136, 56);
  gtk_widget_set_size_request (key_pw_entry_1, 232, 24);
  gtk_entry_set_visibility (GTK_ENTRY (key_pw_entry_1), FALSE);

  key_pw_entry_2 = gtk_entry_new ();
  gtk_widget_show (key_pw_entry_2);
  gtk_fixed_put (GTK_FIXED (fixed3), key_pw_entry_2, 136, 88);
  gtk_widget_set_size_request (key_pw_entry_2, 232, 24);
  gtk_entry_set_visibility (GTK_ENTRY (key_pw_entry_2), FALSE);

  label3 = gtk_label_new (_("You must choose a password here to protect the new identity.  This password must be provided each time you wish use it."));
  gtk_widget_show (label3);
  gtk_fixed_put (GTK_FIXED (fixed3), label3, 8, 8);
  gtk_widget_set_size_request (label3, 368, 40);
  gtk_label_set_line_wrap (GTK_LABEL (label3), TRUE);

  label5 = gtk_label_new (_("Password (again):"));
  gtk_widget_show (label5);
  gtk_fixed_put (GTK_FIXED (fixed3), label5, 8, 93);
  gtk_widget_set_size_request (label5, 112, 16);

  label4 = gtk_label_new (_("Password:"));
  gtk_widget_show (label4);
  gtk_fixed_put (GTK_FIXED (fixed3), label4, 8, 59);
  gtk_widget_set_size_request (label4, 72, 16);



  label1 = gtk_label_new ("");
  gtk_widget_show (label1);
  gtk_frame_set_label_widget (GTK_FRAME (frame1), label1);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_set_size_request (frame2, 400, 80);

  gtk_widget_show (frame2);
  gtk_fixed_put (GTK_FIXED (fixed_main), frame2, 11, 335);


  fixed1 = gtk_fixed_new ();
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (frame2), fixed1);

  prgGenerateBar = gtk_progress_bar_new ();
  gtk_widget_show (prgGenerateBar);
  gtk_fixed_put (GTK_FIXED (fixed1), prgGenerateBar, 8, 0);
  /*gtk_widget_set_usize (prgGenerateBar, 294, 22);*/
  gtk_widget_set_size_request (prgGenerateBar, 280, 22);

  gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR (prgGenerateBar), GTK_PROGRESS_RIGHT_TO_LEFT);
  gtk_progress_bar_set_pulse_step(GTK_PROGRESS_BAR(prgGenerateBar), (gdouble)0.01);

  btnGenerateForReal = gtk_button_new_with_mnemonic (_("Generate!"));
  gtk_widget_show (btnGenerateForReal);
  gtk_fixed_put (GTK_FIXED (fixed1), btnGenerateForReal, 294, 0);
  /*gtk_widget_set_usize (btnGenerateForReal, 94, 22);*/
  gtk_widget_set_size_request (btnGenerateForReal, 94, 25);


  lblKeyGenLabel = gtk_label_new (_(""));
  gtk_label_set_justify (GTK_LABEL(lblKeyGenLabel), GTK_JUSTIFY_CENTER);
  gtk_widget_set_usize (lblKeyGenLabel, 389, 31);
  gtk_fixed_put (GTK_FIXED (fixed1), lblKeyGenLabel, 0, 22);
  gtk_label_set_line_wrap (GTK_LABEL (lblKeyGenLabel), TRUE);
  gtk_widget_show (lblKeyGenLabel);


  label3 = gtk_label_new ("");
  gtk_widget_show (label3);
  gtk_frame_set_label_widget (GTK_FRAME (frame2), label3);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label3), 0, 0);

  g_signal_connect(GTK_OBJECT(btnGenerateForReal), "clicked",
                   (GtkSignalFunc)real_generate_button_clicked, NULL );
  g_signal_connect(G_OBJECT(um_keygen_win), "delete_event",
		   G_CALLBACK(keygen_win_closed), NULL);

  return um_keygen_win;
}


void keygen_win_closed(GtkWidget *widget, GdkEvent *event, void *nothing) {
  /*printf("KEYGEN WIN CLOSED!\n");*/
  gtk_main_quit();
}


void load_key_database_into_ui() {
  unsigned int i = 0;

  /*printf("load_key_database_into_ui()\n");*/
  clear_key_database_from_ui();

  for (i = 0; i < g_list_length(buddynames_list); i++) {
    gtk_list_store_append(database_list_store, &database_tree_iter);
    gtk_list_store_set(database_list_store, &database_tree_iter,
		       0, g_strdup(g_list_nth_data(buddynames_list, i)),
		       1, g_strdup(g_list_nth_data(buddyfp_list, i)), -1);
  }

}


void clear_key_database_from_ui(void) {
  gtk_list_store_clear(database_list_store);
}


void real_generate_button_clicked(GtkWidget *widget, gpointer data) {
  GThread *generate_thread = NULL;
  GThread *progress_thread = NULL;
  G_CONST_RETURN gchar *pw1 = gtk_entry_get_text(GTK_ENTRY(key_pw_entry_1));
  G_CONST_RETURN gchar *pw2 = gtk_entry_get_text(GTK_ENTRY(key_pw_entry_2));

  if (strcmp((char *)gtk_button_get_label(GTK_BUTTON(btnGenerateForReal)),
	     "Generate!") == 0) {
    if (strcmp(pw1, pw2) != 0) { 
      bc_dialog("Passwords do not match!", GTK_MESSAGE_ERROR, NULL);
      gtk_entry_set_text(GTK_ENTRY(key_pw_entry_1), _(""));
      gtk_entry_set_text(GTK_ENTRY(key_pw_entry_2), _(""));
      return;
    } else if (strcmp(pw1, "") == 0) {
      bc_dialog("You must enter a password for this new identity!",
		GTK_MESSAGE_ERROR, NULL);
      return;
    }
  }

  /* Make the 'real' generate button disabled for the duration of the
   * key generation process. */
  gtk_widget_set_sensitive(btnGenerateForReal, FALSE);

  progress_bar_continue = 1;
  keygen_mutex = g_mutex_new();

  if (strcmp((char *)gtk_button_get_label(GTK_BUTTON(btnGenerateForReal)),
	     "Generate!") == 0) {
    /* Create two threads:  one to handle the actual key generation, and the
     * other to handle the progress bar. */
    progress_thread = g_thread_create(&progress_bar_thread, NULL, TRUE, NULL);
    generate_thread = g_thread_create(&generate_key_thread, progress_thread,
				      FALSE, NULL);
    gtk_label_set_text(GTK_LABEL(lblKeyGenLabel),
		       "Now generating keys...\nPlease be "
                       "patient as this may take a few minutes.");
    gtk_button_set_label(GTK_BUTTON(btnGenerateForReal), _("Burninate!"));
  } else {
    gtk_widget_destroy(um_keygen_win);  um_keygen_win = NULL;
    gtk_main_quit();
  }

}



gpointer generate_key_thread(gpointer pg_thread) {
  int ret = 0;
  gchar *id_combo_entry_text = NULL;
  gchar *directory_entry_text = NULL;
  gchar *id_pw = NULL;
  unsigned int fingerprint_buffer_len = 256;
  GThread *progress_thread = NULL;

  progress_thread = (GThread *)pg_thread;

  char fingerprint_buffer[ 256 ];

  memset(fingerprint_buffer, 0, sizeof(fingerprint_buffer) - 8);


  /*printf("generate_key_thread()\n");*/
  /*return NULL;*/

  id_combo_entry_text = (gchar *)gtk_entry_get_text(
                               GTK_ENTRY(id_combo_entry));
  directory_entry_text = (gchar *)gtk_entry_get_text(
			       GTK_ENTRY(directory_entry));

  id_pw = (gchar *)gtk_entry_get_text(GTK_ENTRY(key_pw_entry_1));

  ret = bc_generate_key((char *)id_combo_entry_text, id_pw,
			fingerprint_buffer, fingerprint_buffer_len - 8);

  /* If the key generation process was successful, then update the UI
   * accordingly. */
  if (ret == 1) {
    gdk_threads_enter();
    idnames_list = g_list_append(idnames_list, id_combo_entry_text);
    idfp_list = g_list_append(idfp_list, fingerprint_buffer);
    selected_id_index = g_list_length(idfp_list) - 1;

    gtk_entry_set_text(GTK_ENTRY(id_fingerprint), fingerprint_buffer);
    gtk_widget_set_sensitive(generate_button, FALSE);
    gtk_widget_set_sensitive(ok_button, TRUE);
    gdk_threads_leave();
  } else {
    /*printf("\nXXX ERROR: %s\n\n", fingerprint_buffer);*/
    gdk_threads_enter();
    bc_dialog("There was a critical error while generating the key.  Please restart the program.", GTK_MESSAGE_ERROR, NULL);
    gdk_flush();
    gdk_threads_leave();
  }

  /* Signal the progress bar thread that it should terminate. */
  g_mutex_lock(keygen_mutex);
  progress_bar_continue = 0;
  g_mutex_unlock(keygen_mutex);

  /* Wait for the progress bar thread to terminate. */
  g_thread_join(progress_thread);

  /* Now that no one else is using the mutex, destroy it. */
  g_mutex_free(keygen_mutex);  keygen_mutex = NULL;

  gdk_threads_enter();
  gtk_button_set_label(GTK_BUTTON(btnGenerateForReal), "Close");
  gtk_widget_set_sensitive(btnGenerateForReal, TRUE);
  gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(prgGenerateBar), 0.0);

  gtk_entry_set_text(GTK_ENTRY(key_pw_entry_1), _(""));
  gtk_entry_set_text(GTK_ENTRY(key_pw_entry_2), _(""));

  if (ret == 1) {
    gtk_label_set_text(GTK_LABEL(lblKeyGenLabel),
		       "Keys have been generated successfully!");
  } else {
    gtk_label_set_text(GTK_LABEL(lblKeyGenLabel),
		       "There has been an error while generating the keys.");
  }

  gdk_flush();
  gdk_threads_leave();

  return NULL;
}



gpointer progress_bar_thread(gpointer nothing) {
  GtkProgressBar *progressBar = NULL;

  progressBar = GTK_PROGRESS_BAR(prgGenerateBar);

  /* We must lock the mutex every time we attempt to read the
   * 'progress_bar_continue' shared variable. */
  g_mutex_lock(keygen_mutex);
  while(progress_bar_continue == 1) {
    g_mutex_unlock(keygen_mutex);

    /* Increase the progress bar by one pulse. */
    gdk_threads_enter();
    gtk_progress_bar_pulse(progressBar);
    gdk_threads_leave();

    /* Sleep for 25ms, then loop. */
    g_usleep(25000);

    g_mutex_lock(keygen_mutex);
  }

  g_mutex_unlock(keygen_mutex);
  return NULL;
}


GtkWidget* create_new_entry_window(struct DATABASE_ENTRY *database_entry) {
  GtkWidget *window1;
  GtkWidget *vbox1;
  GtkWidget *hbox1;
  GtkWidget *fixed1;
  GtkWidget *frame2;
  GtkWidget *label2;
  GtkWidget *btnNewEntryCancel;
  GtkWidget *alignment2;
  GtkWidget *hbox3;
  GtkWidget *image2;
  GtkWidget *label5;
  GtkWidget *btnNewEntryOK;
  GtkWidget *alignment1;
  GtkWidget *hbox2;
  GtkWidget *image1;
  GtkWidget *label4;
  GtkWidget *frame3;
  GtkWidget *label3;

  window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window1), _("Add Entry"));
  gtk_window_set_position (GTK_WINDOW (window1), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (window1), TRUE);

  gtk_widget_set_usize (window1, 450, 125);

  gtk_window_set_resizable (GTK_WINDOW (window1), FALSE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window1), vbox1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  fixed1 = gtk_fixed_new ();
  gtk_widget_show (fixed1);
  gtk_box_pack_start (GTK_BOX (hbox1), fixed1, TRUE, TRUE, 0);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_show (frame2);
  gtk_fixed_put (GTK_FIXED (fixed1), frame2, 8, 64);
  gtk_widget_set_usize (frame2, 152, 48);

  entNewUMID = gtk_entry_new ();
  gtk_widget_show (entNewUMID);
  gtk_container_add (GTK_CONTAINER (frame2), entNewUMID);

  label2 = gtk_label_new (_("UM ID"));
  gtk_widget_show (label2);
  gtk_frame_set_label_widget (GTK_FRAME (frame2), label2);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);

  btnNewEntryCancel = gtk_button_new ();
  gtk_widget_show (btnNewEntryCancel);
  gtk_fixed_put (GTK_FIXED (fixed1), btnNewEntryCancel, 320, 80);
  gtk_widget_set_usize (btnNewEntryCancel, 88, 32);

  alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment2);
  gtk_container_add (GTK_CONTAINER (btnNewEntryCancel), alignment2);

  hbox3 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox3);
  gtk_container_add (GTK_CONTAINER (alignment2), hbox3);

  image2 = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image2);
  gtk_box_pack_start (GTK_BOX (hbox3), image2, FALSE, FALSE, 0);

  label5 = gtk_label_new_with_mnemonic (_("Cancel"));
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (hbox3), label5, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);

  btnNewEntryOK = gtk_button_new ();
  gtk_widget_show (btnNewEntryOK);
  gtk_fixed_put (GTK_FIXED (fixed1), btnNewEntryOK, 200, 80);
  gtk_widget_set_usize (btnNewEntryOK, 88, 32);
  GTK_WIDGET_SET_FLAGS (btnNewEntryOK, GTK_CAN_DEFAULT);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (btnNewEntryOK), alignment1);

  hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox2);

  image1 = gtk_image_new_from_stock ("gtk-apply", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (hbox2), image1, FALSE, FALSE, 0);

  label4 = gtk_label_new_with_mnemonic (_("OK"));
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (hbox2), label4, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_show (frame3);
  gtk_fixed_put (GTK_FIXED (fixed1), frame3, 8, 8);
  gtk_widget_set_usize (frame3, 432, 48);

  entNewFingerprint = gtk_entry_new ();
  gtk_widget_show (entNewFingerprint);
  gtk_container_add (GTK_CONTAINER (frame3), entNewFingerprint);

  label3 = gtk_label_new (_("Fingerprint"));
  gtk_widget_show (label3);
  gtk_frame_set_label_widget (GTK_FRAME (frame3), label3);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);

  g_signal_connect(GTK_OBJECT(btnNewEntryOK), "clicked",
                   (GtkSignalFunc)btnNewEntryOK_clicked, database_entry );

  g_signal_connect(GTK_OBJECT(btnNewEntryCancel), "clicked",
                   (GtkSignalFunc)btnNewEntryCancel_clicked, database_entry );

  g_signal_connect(GTK_OBJECT(entNewFingerprint), "changed",
		   (GtkSignalFunc) fingerprint_entry_changed,
		   entNewFingerprint);


  if (database_entry->umid[0] != '\0') {
    gtk_entry_set_text(GTK_ENTRY(entNewUMID), database_entry->umid);
  }

  if (database_entry->fingerprint[0] != '\0') {
    gtk_entry_set_text(GTK_ENTRY(entNewFingerprint),
		       database_entry->fingerprint);
  }

  gtk_widget_grab_default (btnNewEntryOK);
  return window1;
}



void btnNewEntryOK_clicked(GtkWidget *widget, gpointer data) {
  struct DATABASE_ENTRY *database_entry = NULL;
  char *new_umid = NULL;
  char *new_fingerprint = NULL;

  /*printf("OKX!\n");*/

  database_entry = (struct DATABASE_ENTRY *)data;


  new_umid = (char *)gtk_entry_get_text(GTK_ENTRY(entNewUMID));
  new_fingerprint =
    (char *)gtk_entry_get_text(GTK_ENTRY(entNewFingerprint));

  if (bc_is_key_fingerprint_valid(new_fingerprint)) {
    g_strlcpy(database_entry->umid, new_umid,
	      sizeof(database_entry->umid) - 8);
    g_strlcpy(database_entry->fingerprint, new_fingerprint,
	      sizeof(database_entry->fingerprint) - 8);
    gtk_widget_destroy(new_entry_window);  new_entry_window = NULL;
    gtk_main_quit();
  } else {
    bc_dialog("Key fingerprint must contain 20 hexidecimal bytes.  "
	      "An example of a valid fingerprint format is:\n\n"
	      "3F 5D 1D 4C CE FF 9A 2D 77 48 A4 D0 BE 67 8F 23 6A 3B 6E AD",
	      GTK_MESSAGE_ERROR, NULL);
  }


}


void fingerprint_entry_changed(GtkWidget *widget, gpointer data) {
  char last_char = '\0';
  unsigned int fingerprint_len = 0;
  gchar *fingerprint = NULL;


  fingerprint = (gchar *)gtk_entry_get_text(GTK_ENTRY(widget));
  /*printf("fp: [%s]\n", fingerprint);*/
  fingerprint_len = strlen(fingerprint);
  if (fingerprint_len == 0)
    return;


  fingerprint = g_strdup(fingerprint);

  last_char = fingerprint[ fingerprint_len - 1 ];
  if (!bc_is_char_hexidecimal(last_char) && (last_char != ' ')) {
    bc_dialog("You have entered an invalid character.  Valid characters "
	      "consist of any from the following: 0123456789ABCDEF",
	      GTK_MESSAGE_ERROR, NULL);
    fingerprint[ fingerprint_len - 1 ] = '\0';
    gtk_entry_set_text(GTK_ENTRY(data), fingerprint);
  }

  g_free(fingerprint); fingerprint = NULL;

}


void btnNewEntryCancel_clicked(GtkWidget *widget, gpointer data) {
  struct DATABASE_ENTRY *database_entry = NULL;

  database_entry = (struct DATABASE_ENTRY *)data;
  memset(database_entry, 0, sizeof(struct DATABASE_ENTRY));

  gtk_widget_destroy(new_entry_window);  new_entry_window = NULL;
  /*printf("Cancel!\n");*/
  gtk_main_quit();
}



void bc_register_icons(void) {
  GdkPixbuf *pixbuf = NULL;
  GtkIconSet *iconset = NULL;
  GtkIconFactory *iconfactory = NULL;
  unsigned int i;

  gtk_stock_add(stockitems, G_N_ELEMENTS(stockitems));
   
  iconfactory = gtk_icon_factory_new();
  gtk_icon_factory_add_default(iconfactory);
  for (i = 0; i < G_N_ELEMENTS(item_names); i++) {
    pixbuf =
      gdk_pixbuf_new_from_xpm_data((const char **)item_names[ i ].xpm_data);
    iconset = gtk_icon_set_new_from_pixbuf(pixbuf);
    gtk_icon_factory_add(iconfactory, item_names[ i ].name, iconset);
    gtk_icon_set_unref(iconset);
    g_object_unref(G_OBJECT (pixbuf));
  }
  g_object_unref(iconfactory);

}


void bc_system_message_with_conv(GaimConversation *c, char *what) {
  gaim_conversation_write(c, "BC", what, GAIM_MESSAGE_SYSTEM,
			  time((time_t)NULL));
}


void bc_system_message(char *who, char *what) {
  GaimConversation *c = NULL;

  c = gaim_find_conversation(who);
  if (c != NULL) {
    gaim_conversation_write(c, "BC", what, GAIM_MESSAGE_SYSTEM,
			    time((time_t)NULL));
  }
}

#include "gtkimhtml.h"
void new_conversation(GaimConversation *conv, void *data) {
  char line[ 256 ];

  memset(line, 0, sizeof(line));


  /*printf("new_conversation called!\n");*/

  if ((conv != NULL) && (gaim_conversation_get_type(conv) == GAIM_CONV_IM)) {
    GaimGtkConversation *gtkconv = GAIM_GTK_CONVERSATION(conv);
    GtkWidget *bbox = gtkconv->bbox;
    GtkWidget *button_greenlock = NULL;
    GtkWidget *button_yellowlock_1 = NULL;
    GtkWidget *button_yellowlock_2 = NULL;
    GtkWidget *button_redlock = NULL;
    gchar *status = NULL;
    GaimGtkWindow *gtkwin = NULL;
    GtkWidget *menu_autoencrypt = NULL;
    gboolean autoencrypt = FALSE;
    /*GtkIMHtml *imhtml = NULL;*/

    GtkRequisition requisition;

    memset(&requisition, 0, sizeof(requisition));
     /*
     button_greenlock = gaim_gtk_change_text(encrypted_button_text_encrypted,
					     0, "BC_Encrypted", GAIM_CONV_IM);
     button_redlock = gaim_gtk_change_text(encrypted_button_text_notencrypted,
					   0, "BC_Plaintext", GAIM_CONV_IM);

     g_signal_connect(G_OBJECT(button_greenlock), "clicked",
		      GTK_SIGNAL_FUNC(disable_encryption_cb), (gpointer)conv);
     g_signal_connect(G_OBJECT(button_redlock), "clicked",
		      GTK_SIGNAL_FUNC(enable_encryption_cb), (gpointer)conv);
     */
     button_greenlock = gaim_gtkconv_button_new("BC_Encrypted", encrypted_button_text_encrypted, NULL, NULL, disable_encryption_cb, (gpointer)conv);

     button_yellowlock_1 = gaim_gtkconv_button_new("BC_Transition_1", encrypted_button_text_transition1, NULL, NULL, disable_transition1_cb, (gpointer)conv);

     button_yellowlock_2 = gaim_gtkconv_button_new("BC_Transition_2", encrypted_button_text_transition2, NULL, NULL, NULL, (gpointer)conv);

     button_redlock = gaim_gtkconv_button_new("BC_Plaintext", encrypted_button_text_notencrypted, NULL, NULL, enable_transition1_cb, (gpointer)conv);


     gtk_box_pack_start(GTK_BOX(bbox), button_greenlock, FALSE, FALSE, 0);
     gtk_button_set_relief(GTK_BUTTON(button_greenlock), GTK_RELIEF_NONE);
     gtk_tooltips_set_tip(gtkconv->tooltips, button_greenlock,
			  g_strdup("This conversation is encrypted and secured."), 0);
     gtk_widget_size_request(button_greenlock, &requisition);
     gtk_widget_set_size_request(button_greenlock, requisition.width, -1);

 
     gtk_box_pack_start(GTK_BOX(bbox), button_redlock, FALSE, FALSE, 0);
     gtk_button_set_relief(GTK_BUTTON(button_redlock), GTK_RELIEF_NONE);
     gtk_tooltips_set_tip(gtkconv->tooltips, button_redlock,
			  g_strdup("This conversation is NOT encrypted!"), 0);
     gtk_widget_size_request(button_redlock, &requisition);
     gtk_widget_set_size_request(button_redlock, requisition.width, -1);


     gtk_box_pack_start(GTK_BOX(bbox), button_yellowlock_1, FALSE, FALSE, 0);
     gtk_button_set_relief(GTK_BUTTON(button_yellowlock_1), GTK_RELIEF_NONE);
     gtk_tooltips_set_tip(gtkconv->tooltips, button_yellowlock_1,
			  g_strdup("An encrypted conversation will begin once a message is sent."), 0);
     gtk_widget_size_request(button_yellowlock_1, &requisition);
     gtk_widget_set_size_request(button_yellowlock_1, requisition.width, -1);


     gtk_box_pack_start(GTK_BOX(bbox), button_yellowlock_2, FALSE, FALSE, 0);
     gtk_button_set_relief(GTK_BUTTON(button_yellowlock_2), GTK_RELIEF_NONE);
     gtk_tooltips_set_tip(gtkconv->tooltips, button_yellowlock_2,
			  g_strdup("Encrypted channel in negotiation phase..."), 0);
     gtk_widget_size_request(button_yellowlock_2, &requisition);
     gtk_widget_set_size_request(button_yellowlock_2, requisition.width, -1);


     g_hash_table_insert(conv->data, g_strdup("bc_button_redlock"),
			 button_redlock);
     g_hash_table_insert(conv->data, g_strdup("bc_button_greenlock"),
			 button_greenlock);
     g_hash_table_insert(conv->data, g_strdup("bc_button_yellowlock_1"),
			 button_yellowlock_1);
     g_hash_table_insert(conv->data, g_strdup("bc_button_yellowlock_2"),
			 button_yellowlock_2);

     g_hash_table_insert(conv->data, g_strdup(encrypt_state_key), g_malloc(32));

     /*status = get_status(conv->title, conv->account);*/
     status = get_status(conv->name, conv->account);
     /*printf("get_status(%s) = [%s]\n", conv->title, status);*/

     mod_write("AUTO_QUERY ");
     mod_writeln((char *)gaim_normalize(conv->account, conv->name));
     mod_readline(line, sizeof(line) - 8);
     if (strcmp(line, "YES") == 0)
       autoencrypt = TRUE;
     else if (strcmp(line, "NO") == 0)
       autoencrypt = FALSE;
     else {
       gaim_debug(GAIM_DEBUG_INFO, "new_conversation",
		  "Autoquery returned [%s]\n", line);
     }

     if (status == NULL) {
       /*gtk_widget_hide(button_greenlock);
       gtk_widget_show(button_redlock);

       g_hash_table_insert(conv->data,
			   g_strdup(encrypt_state_key),
			   encrypt_state_false);*/

       if (autoencrypt == TRUE)
	 bc_set_state_transition1(conv);
       else
	 bc_set_state_plaintext(conv);

       /*g_hash_table_insert(conv->data, g_strdup(lock_state_key),
	 lock_state_false);*/
     } else if (strcmp(status, "Connected.") == 0) {

       bc_set_state_encrypted(conv);
       g_free(status);  status = NULL;
       /*gtk_widget_hide(button_redlock);
       gtk_widget_show(button_greenlock);

       g_hash_table_insert(conv->data,
			   g_strdup(encrypt_state_key),
			   encrypt_state_true);*/

       /*g_hash_table_insert(conv->data, g_strdup(lock_state_key),
	 lock_state_true);*/
       
     } else {
       bc_set_state_transition2(conv);
       g_free(status);  status = NULL;
     }

     gtkconv->autoencrypt = autoencrypt;
     gtkwin = GAIM_GTK_WINDOW(gaim_conversation_get_window(conv));
     menu_autoencrypt = gtk_item_factory_get_widget(gtkwin->menu.item_factory,
						    N_("/Options/Auto Encrypt"));
     /*imhtml = GTK_IMHTML(gtkconv->entry);
     g_signal_connect(GTK_OBJECT(&imhtml->text_view), "changed",
     (GtkSignalFunc) im_text_buffer_changed, NULL);*/
     g_signal_connect(GTK_OBJECT(gtkconv->entry_buffer), "changed",
		      (GtkSignalFunc) im_text_buffer_changed,
		      conv);

   }
}


/* Triggered when the user enters text into the IM window.  Tries to enforce
 * the 500-character limit for encrypted IMs. */
void im_text_buffer_changed(GtkWidget *widget, gpointer data) {
  GtkTextBuffer *text_buffer = NULL;
  GtkIMHtml *gtk_imhtml = NULL;
  gchar *text = NULL;
  size_t text_len = 0;
  GaimConversation *conv = NULL;
  GaimGtkConversation *gtkconv = NULL;

  GtkTextIter start_iter;
  GtkTextIter end_iter;


  memset(&start_iter, 0, sizeof(start_iter));
  memset(&end_iter, 0, sizeof(end_iter));

  conv = (GaimConversation *)data;

  /* Don't worry about plaintext conversations... */
  if (bc_is_state_plaintext(conv))
    return;


  gtkconv = GAIM_GTK_CONVERSATION(conv);
/*gtkconv = (GaimGtkConversation *)data;*/
 

  /*  text_buffer = GTK_TEXT_BUFFER(data);*/
  /*gtk_imhtml = GTK_IMHTML(data);*/
  gtk_imhtml = GTK_IMHTML(gtkconv->entry);
  text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(&(gtk_imhtml->text_view)));

  gtk_text_buffer_get_start_iter(text_buffer, &start_iter);
  gtk_text_buffer_get_end_iter(text_buffer, &end_iter);

  text = gtk_imhtml_get_markup_range(gtk_imhtml, &start_iter, &end_iter);
  text_len = strlen(text);
  if (text_len > 500) {
    GString *string = g_string_new(NULL);


    gtk_text_iter_set_offset(&start_iter, 500);
    gtk_text_buffer_delete(text_buffer, &start_iter, &end_iter);

    g_string_printf(string, "You have exceeded the 500-character limit by %u characters.  Text has been automatically truncated.\n\nNote: if you are pasting formatted text, you may need to manually truncate more text because invisible formatting characters count towards this limit.", (unsigned int)(text_len - 500));
    bc_dialog(string->str, GTK_MESSAGE_ERROR, NULL);
    g_string_free(string, TRUE);  string = NULL;
    
  }
}


#include "debug.h"
void del_conversation(GaimConversation *c, void *data) {
  gchar *state = NULL;
  GtkWidget *widget = NULL;
  GtkTooltipsData *ttdata = NULL;

  char line[ 256 ];

  memset(line, 0, sizeof(line));
  /*gpointer key = NULL;
  gpointer value = NULL;

  GtkWidget *button_greenlock = NULL;
  GtkWidget *button_redlock = NULL;

  button_greenlock = g_hash_table_lookup(c->data, "bc_button_greenlock");
  button_redlock = g_hash_table_lookup(c->data, "bc_button_redlock");

  gtk_widget_destroy(button_greenlock);  button_greenlock = NULL;
    gtk_widget_destroy(button_redlock);  button_redlock = NULL;

  if (g_hash_table_lookup_extended(c->data, encrypt_state_key, &key, &value)){
    g_free(key);  key = NULL;
  }

  if (g_hash_table_lookup_extended(c->data, lock_state_key, &key, &value)) {
    g_free(key);  key = NULL;
    }*/

  if (bc_is_state_plaintext(c)) {
    /*printf("AF plaintext for: [%s]\n", c->title);*/
    mod_write("AUTO_FEEDBACK ");
    mod_write((char *)gaim_normalize(c->account, c->name));
    mod_writeln("|P");

    mod_readline(line, sizeof(line) - 8);
    /*printf("line: [%s]\n", line);*/
    if (strcmp(line, "OK") != 0) {
      gaim_debug(GAIM_DEBUG_INFO, "del_conversation",
		 "Autofeedback for plaintext session returned [%s]\n", line);
    }
  }

  state = (gchar *)g_hash_table_lookup(c->data, encrypt_state_key);
  g_free(state); state = NULL;

  widget = (GtkWidget *)g_hash_table_lookup(c->data, "bc_button_redlock");
  ttdata = gtk_tooltips_data_get(widget);
  /*printf("freeing: [%s]\n", ttdata->tip_text);*/
  g_free(ttdata->tip_text);  ttdata->tip_text = NULL;
  gtk_widget_destroy(widget);  widget = NULL;

  widget = (GtkWidget *)g_hash_table_lookup(c->data, "bc_button_greenlock");
  ttdata = gtk_tooltips_data_get(widget);
  g_free(ttdata->tip_text);  ttdata->tip_text = NULL;
  gtk_widget_destroy(widget);  widget = NULL;

  widget = (GtkWidget *)g_hash_table_lookup(c->data, "bc_button_yellowlock_1");
  ttdata = gtk_tooltips_data_get(widget);
  g_free(ttdata->tip_text);  ttdata->tip_text = NULL;
  gtk_widget_destroy(widget);  widget = NULL;

  widget = (GtkWidget *)g_hash_table_lookup(c->data, "bc_button_yellowlock_2");
  ttdata = gtk_tooltips_data_get(widget);
  g_free(ttdata->tip_text);  ttdata->tip_text = NULL;
  gtk_widget_destroy(widget);  widget = NULL;


}

void enable_transition1_cb(GtkWidget *callback,
			   GaimConversation *c) {

  bc_set_state_transition1(c);

  /* Disable logging if it is enabled.  We don't want to log encrypted
   * conversations. */
  if (gaim_conversation_is_logging(c)) {
    GaimConvWindow *win = gaim_conversation_get_window(c);
    GaimGtkWindow *gtkwin = GAIM_GTK_WINDOW(win);

    gaim_conversation_set_logging(c, FALSE);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtkwin->menu.logging),
				   FALSE);
    bc_system_message_with_conv(c, "NOTE: Conversation logging will be " \
				"disabled while conversation is encrypted.");
  }

  /*GtkWidget *button_yellowlock = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_1");
  GtkWidget *button_redlock = g_hash_table_lookup(c->data,
						  "bc_button_redlock");

  gtk_widget_hide(button_redlock);
  gtk_widget_show(button_yellowlock);

  g_hash_table_insert(c->data, g_strdup(encrypt_state_key), encrypt_state_transition1);*/
}

void disable_transition1_cb(GtkWidget *callback,
			    GaimConversation *c) {
  bc_set_state_plaintext(c);

  /*GtkWidget *button_yellowlock = g_hash_table_lookup(c->data,
						     "bc_button_yellowlock_1");
  GtkWidget *button_redlock = g_hash_table_lookup(c->data,
						  "bc_button_redlock");

  gtk_widget_hide(button_yellowlock);
  gtk_widget_show(button_redlock);

  g_hash_table_insert(c->data, g_strdup(encrypt_state_key), encrypt_state_false);*/
}


void disable_encryption_cb(GtkWidget *callback,
			   GaimConversation *conv) {

  bc_system_message(conv->name, "Encryption cannot be disabled once " \
		    "conversation has started.");
  /*if (!bc_is_encrypted_state_locked(conv))*/
    
    /*else {
    
		      }*/
}


/*void enable_encryption_cb(GtkWidget *callback,
			  GaimConversation *conv) {
  bc_enable_encryption_state(conv);
  }*/







/*int bc_is_encrypted_state_locked(GaimConversation *c) {
  gchar *lock_state = (gchar *)g_hash_table_lookup(c->data, lock_state_key);

  if (lock_state == NULL) {
    bc_dialog("Critical error in 'bc_is_encrypted_state_locked()'!",
	      GTK_MESSAGE_ERROR, NULL);
    exit(1);
  }

  if (g_ascii_strncasecmp(lock_state, _("TRUE"), 4) == 0)
    return 1;
  else if (g_ascii_strncasecmp(lock_state, _("FALSE"), 5) == 0)
    return 0;
  else {
    bc_dialog("Critical error in 'bc_is_encrypted_state_locked()'!",
	      GTK_MESSAGE_ERROR, NULL);
    exit(1);
  }

}*/




/*void bc_lock_encryption_state(GaimConversation *c) {
  if (!bc_is_encrypted_state_locked(c))
    g_hash_table_insert(c->data, g_strdup(lock_state_key), lock_state_true);
    }*/


void reset_crypto_init_ui(void) {
 gtk_entry_set_text(GTK_ENTRY(directory_entry), "");
 gtk_entry_set_text(GTK_ENTRY(id_combo_entry), "");
 g_list_free(combo_box_list);

 gtk_widget_set_sensitive(generate_button, FALSE);
 gtk_widget_set_sensitive(id_fingerprint, FALSE);
 gtk_widget_set_sensitive(ok_button, FALSE);
 gtk_widget_set_sensitive(id_combo, FALSE);
 gtk_widget_set_sensitive(select_button, TRUE);

 g_list_free(idnames_list);    idnames_list = NULL;
 g_list_free(idfp_list);       idfp_list = NULL;
 g_list_free(buddynames_list); buddynames_list = NULL;
 g_list_free(buddyfp_list);    buddyfp_list = NULL;

 gtk_combo_set_popdown_strings(GTK_COMBO(id_combo), NULL);
 selected_id_index = -1;

 clear_key_database_from_ui();

}


GtkWidget *create_key_pw_win(void) {
  GtkWidget *id_pw_win;
  GtkWidget *fixed1;
  GtkWidget *frame1;
  GtkWidget *fixed2;
  GtkWidget *pw_ok_btn;
  GtkWidget *alignment1;
  GtkWidget *hbox1;
  GtkWidget *image1;
  GtkWidget *label4;
  GtkWidget *label3;
  GtkWidget *label2;
  
  id_pw_win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (id_pw_win), _("Enter Identity Password"));
  gtk_window_set_position (GTK_WINDOW (id_pw_win), GTK_WIN_POS_CENTER);

  fixed1 = gtk_fixed_new ();
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (id_pw_win), fixed1);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_fixed_put (GTK_FIXED (fixed1), frame1, 8, 0);
  gtk_widget_set_size_request (frame1, 336, 112);

  fixed2 = gtk_fixed_new ();
  gtk_widget_show (fixed2);
  gtk_container_add (GTK_CONTAINER (frame1), fixed2);

  pw_entry = gtk_entry_new ();
  gtk_widget_show (pw_entry);
  gtk_fixed_put (GTK_FIXED (fixed2), pw_entry, 8, 56);
  gtk_widget_set_size_request (pw_entry, 232, 24);
  gtk_entry_set_visibility (GTK_ENTRY (pw_entry), FALSE);

  pw_ok_btn = gtk_button_new ();
  gtk_widget_show (pw_ok_btn);
  gtk_fixed_put (GTK_FIXED (fixed2), pw_ok_btn, 248, 48);
  gtk_widget_set_size_request (pw_ok_btn, 72, 32);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (pw_ok_btn), alignment1);

  hbox1 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox1);

  image1 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (hbox1), image1, FALSE, FALSE, 0);

  label4 = gtk_label_new_with_mnemonic (_("OK"));
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (hbox1), label4, FALSE, FALSE, 0);

  label3 = gtk_label_new (_("Please enter the password to unlock the chosen identity:"));
  gtk_widget_show (label3);
  gtk_fixed_put (GTK_FIXED (fixed2), label3, 8, 0);
  gtk_widget_set_size_request (label3, 304, 48);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_CENTER);
  gtk_label_set_line_wrap (GTK_LABEL (label3), TRUE);

  label2 = gtk_label_new ("");
  gtk_widget_show (label2);
  gtk_frame_set_label_widget (GTK_FRAME (frame1), label2);

  g_signal_connect(GTK_OBJECT(pw_ok_btn), "clicked",
                   (GtkSignalFunc) gtk_main_quit, NULL);

  GTK_WIDGET_SET_FLAGS(pw_ok_btn, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(pw_ok_btn);
  gtk_entry_set_activates_default(GTK_ENTRY(pw_entry), TRUE);

  gtk_widget_grab_focus(pw_entry);

  g_signal_connect(G_OBJECT(id_pw_win), "delete_event",
		   G_CALLBACK(id_pw_win_closed), NULL);

  return id_pw_win;

}

void id_pw_win_closed(GtkWidget *widget, GdkEvent *event, void *nothing) {
  /*printf("ID PW WIN CLOSED!\n");*/
  pw_entry = NULL;
  gtk_main_quit();
}


void get_id_pw(gchar *pwbuf, size_t pwbuf_len) {
  GtkWidget *pw_win = create_key_pw_win();
  gchar *password = NULL;

  gtk_widget_show(pw_win);
  gtk_main();

  if (pw_entry == NULL)
    pwbuf[ 0 ] = '\0';
  else {
    password = (gchar *)gtk_entry_get_text(GTK_ENTRY(pw_entry));
    g_strlcpy(pwbuf, password, pwbuf_len);
  }

  gtk_widget_destroy(pw_win);
}


void what_is_load_save_clicked(GtkWidget *widget, gpointer data) {
  bc_dialog("The \"Load/Save Directory\" is a place where this program can read and write information to.  Because sensitive data like your encryption keys are stored in this location, it should be a private place that no one else has access to.  In high-security situations, you may consider setting the \"Load/Save Directory\" to a floppy drive (or some other kind of removable media).  In most other situations, you may conveniently use the default location by clicking the checkbox titled, \"Use the default load/save directory\".", GTK_MESSAGE_INFO, NULL);
}


void what_is_id_clicked(GtkWidget *widget, gpointer data) {
  bc_dialog("An Encryption ID is simply an encryption key that has been given a specific name (this makes it easy to keep track of multiple keys).\n\nTo generate a new Encryption ID, type the name you desire to give the new key in the \"Choose An Identity\" box and click the \"Generate...\" button.  An window titled \"Generate Key\" will appear.  Follow the instructions on that window.\n\nFor more detailed instructions, see the official User's Guide.", GTK_MESSAGE_INFO, NULL);
}


void what_is_buddy_id_db_clicked(GtkWidget *widget, gpointer data) {
  bc_dialog("The Public Key Hash Database is a set of data maintained by this software that tracks what keys from other people you have chosen to trust (via the \"New Key Fingerprint Detected\" window--see the official User's Guide).\n\nIf ever you have accidentally chosen to trust a new key from another buddy, you can undo the changes by deleting the corresponding key's fingerprint from the database manually.  In most cases, however, you will not need to concern yourself with the Public Key Hash Database, which is why it is hidden from view by default.\n\nSee the official User's Guide for more information.", GTK_MESSAGE_INFO, NULL);
}


gboolean timeout_func(gpointer data) {
  struct NEW_FP_STRUCT *new_fp_struct = (struct NEW_FP_STRUCT *)data;
  GString *string = g_string_new("");
 
  if (new_fp_struct->trigger == 1) {

    g_string_append_printf(string, "Sorry, but you did not respond to %s's new key within 40 seconds, and so it was automatically rejected.  If you did not respond fast enough because you were not sure how to answer, please consult the official documentation.\nBy the way, %s's key fingerprint was:\n\n[%s]",
	       gtk_entry_get_text(GTK_ENTRY(new_fp_struct->ent_umid)),
	       gtk_entry_get_text(GTK_ENTRY(new_fp_struct->ent_umid)),
	       gtk_entry_get_text(GTK_ENTRY(new_fp_struct->ent_fingerprint)));

#ifndef _WIN32
    gdk_threads_enter();
#endif

    gtk_widget_destroy(new_fp_struct->fp_window);
    gtk_main_quit();
    /*gdk_flush();*/
    bc_dialog(string->str, GTK_MESSAGE_INFO, NULL);
    /*gdk_flush();*/

#ifndef _WIN32
    gdk_threads_leave();
#endif
  }

  g_string_free(string, TRUE);  string = NULL;

  return FALSE;
}

/*gpointer keyfp_thread(gpointer data) {

  struct NEW_FP_STRUCT *new_fp_struct = NULL;
  unsigned int i = 0;

  new_fp_struct = (struct NEW_FP_STRUCT *)data;

  return NULL;

  for (i = 0; ((i < 40) && (new_fp_struct->trigger == 1)); i++) {

    sleep(1);
  }

  * If the trigger is still 1, then the 40 seconds expired without the
   * user responding... *
  if (new_fp_struct->trigger == 1)
    write(new_fp_struct->the_pipe[ 1 ], "Y", 1);
  else
    write(new_fp_struct->the_pipe[ 1 ], "N", 1);



  i = 0;
  g_thread_exit(&i);
  return NULL;
}*/

/*#ifdef _WIN32
gboolean key_timeout_io_watch(GIOChannel *ioc,
                              GIOCondition condition,
                              gpointer ptr) {
                              #else*/
/*static void key_timeout_io_watch(gpointer ptr, gint read_fd, GaimInputCondition cond) {
  *#endif*
  struct NEW_FP_STRUCT *new_fp_struct = (struct NEW_FP_STRUCT *)ptr;
  char buf[ 2 ] = { '\0', '\0' };
#ifdef _WIN32
  gsize bleh = 0;
  GError *error = NULL;
#endif


  *#ifdef _WIN32
  g_io_channel_read_chars(new_fp_struct->channel, buf, 1, &bleh, &error);
  #else*
  read(read_fd, buf, 1);
  *#endif*



  if (buf[ 0 ] == 'Y') {

    GString *string = g_string_new("");
  
    g_string_append_printf(string, "Sorry, but you did not respond to %s's new key within 40 seconds, and so it was automatically rejected.  If you did not respond fast enough because you were not sure how to answer, please consult the official documentation.\nBy the way, %s's key fingerprint was:\n\n[%s]",
	       gtk_entry_get_text(GTK_ENTRY(new_fp_struct->ent_umid)),
	       gtk_entry_get_text(GTK_ENTRY(new_fp_struct->ent_umid)),
	       gtk_entry_get_text(GTK_ENTRY(new_fp_struct->ent_fingerprint)));

#ifndef _WIN32
    gdk_threads_enter();
#endif

    gtk_widget_destroy(new_fp_struct->fp_window);
    gtk_main_quit();

    bc_dialog(string->str, GTK_MESSAGE_INFO, NULL);


#ifndef _WIN32
    gdk_threads_leave();
#endif

    g_string_free(string, TRUE);  string = NULL;
  }

#ifdef _WIN32
  return FALSE;
#else
  gaim_input_remove(new_fp_struct->event_source_id);
  return;
#endif
}*/


gboolean ui_state_func(GIOChannel *ioc,
                       GIOCondition condition,
                       gpointer data) {
  if (condition & (G_IO_IN | G_IO_PRI)) {
    GIOStatus ret = 0;
    gchar *line = NULL;
    gsize length = 0;
    gsize terminator = 0;
    GError *error = NULL;
    unsigned int operation = 0;
    unsigned int oldstate = 0;
    unsigned int newstate = 0;
    /*GString *str = NULL;*/
    char *slash_pos = NULL;

    char screenname[ 64 ];
    char umid[ 64 ];

    memset(screenname, 0, sizeof(screenname));
    memset(umid, 0, sizeof(umid));

    ret = g_io_channel_read_line(ioc, &line, &length, &terminator, &error);
    if (length <= 0 || ret != G_IO_STATUS_NORMAL) {
      return FALSE;
    }


    if ((strcmp(line, "END_STDERR") == 0) || (strcmp(line, "") == 0))
      return TRUE;


    if (bc_parse_stderr_line(line, screenname, sizeof(screenname) - 8,
                             umid, sizeof(umid) - 8, &operation,
                             &oldstate, &newstate)) {
      /*printf("parsed: [%s][%s][%u][%u][%u]\n", screenname, umid, operation, oldstate, newstate);*/
      /*printf("PRETTY TEXT: [%s]\n", bc_parse_state_into_text(newstate));*/

      slash_pos = strrchr(screenname, '/');
      if (slash_pos != NULL)
	*slash_pos = '\0';

      GaimConversation *c = gaim_find_conversation(screenname);
      if (c != NULL) {
	GString *key = NULL;
	gchar *queued_message = NULL;


	/* We'll only notify the user of new states, not retracted states. */
	if ((operation == STATE_FLAG_ADD) ||
	    ((operation == STATE_FLAG_SET) && (newstate == CONNECTED)) ||
	    ((operation == STATE_FLAG_SET) && (newstate == BUDDY_RESET)) ||
	    ((operation == STATE_FLAG_SET) && (newstate == TIMEDOUT))) {
	  bc_system_message_with_conv(c, bc_parse_state_into_text(newstate));
	}

	key = g_string_new((gchar *)gaim_normalize(c->account, c->name));

	g_mutex_lock(pending_messages_mutex);
	queued_message = g_hash_table_lookup(pending_messages, key->str);



	if (newstate == CONNECTED) {
	  GaimConvIm *im = NULL;

	  bc_set_state_encrypted(c);

	  /*printf("AF crypto for: [%s]\n", c->title);*/
	  mod_write("AUTO_FEEDBACK ");
	  mod_write(key->str);
	  mod_writeln("|C");

	  mod_readline(line, sizeof(line) - 8);
	  /*printf("line: [%s]\n", line);*/

	  im = GAIM_CONV_IM(c);
	  gaim_conv_im_write(im, NULL, queued_message,
			     GAIM_MESSAGE_SEND, time(NULL));

	  g_hash_table_remove(pending_messages, key->str);
	} else if ((newstate == TIMEDOUT) || (newstate == BUDDY_RESET)) {
	  g_hash_table_remove(pending_messages, key->str);
	  bc_set_state_plaintext(c);
	} else if (newstate == REPLAY_IMMUNE)
	  bc_system_message_with_conv(c, "Conversation is now immune to replay attacks.");
	else
	  bc_set_state_transition2(c);


	g_string_free(key, TRUE);  key = NULL;
	g_mutex_unlock(pending_messages_mutex);

      }

    }

  }

  return TRUE;
}



/*#include "debug.h"*/
gpointer ui_state_thread(gpointer data) {
  unsigned int continue_flag = 1;
  unsigned int i = 0;
  /*char *ptr = NULL;
    char *pipe_pos = NULL;*/
  unsigned int operation = 0;
  unsigned int oldstate = 0;
  unsigned int newstate = 0;

  /*GString *str = NULL;*/

  char buffer[ 256 ];
  char screenname[ 64 ];
  char umid[ 64 ];

  memset(buffer, 0, sizeof(buffer));
  memset(screenname, 0, sizeof(screenname));
  memset(umid, 0, sizeof(umid));


  while(continue_flag == 1) {
    mod_stderr_readline(buffer, sizeof(buffer) - 8);
    /*printf("read stderr: [%s]\n", buffer);*/
    /*gaim_debug(GAIM_DEBUG_INFO, "read stderr", "%s", buffer);*/
    if ((strcmp(buffer, "END_STDERR") == 0) || (strcmp(buffer, "") == 0))
      continue_flag = 0;
    else if (bc_parse_stderr_line(buffer, screenname, sizeof(screenname) - 8,
				  umid, sizeof(umid) - 8, &operation,
				  &oldstate, &newstate)) {
      /*printf("parsed: [%s][%s][%u][%u][%u]\n", screenname, umid, operation, oldstate, newstate);*/

      /*str = g_string_new("");
      g_string_append_printf(str, "[%s][%s][%u][%u][%u]", screenname, umid, operation, oldstate, newstate);
      MessageBox(NULL, str->str, "bleh", MB_OK);*/

      /*printf("PRETTY TEXT: [%s]\n", bc_parse_state_into_text(newstate));*/

      /*gdk_threads_enter();*/

      GaimConversation *c = gaim_find_conversation(screenname);

      if (c != NULL) {
	gchar *key = NULL;
	gchar *queued_message = NULL;

	/* We'll only notify the user of new states, not retracted states. */
	if ((operation == STATE_FLAG_ADD) ||
	    ((operation == STATE_FLAG_SET) && (newstate == CONNECTED)) ||
	    ((operation == STATE_FLAG_SET) && (newstate == TIMEDOUT))) {

	  bc_system_message_with_conv(c, bc_parse_state_into_text(newstate));

	}

	key = (gchar *)gaim_normalize(c->account, c->name);

	g_mutex_lock(pending_messages_mutex);
	queued_message = g_hash_table_lookup(pending_messages, key);
	gaim_debug(GAIM_DEBUG_INFO, "bc_ui.c", "X queued message: [%s]\n", queued_message);
	/*fprintf(stdout, "X queued message: [%s]\n", queued_message);
	bc_dialog("X", GTK_MESSAGE_INFO, NULL);
	bc_dialog(queued_message, GTK_MESSAGE_INFO, NULL);*/

	if (newstate == CONNECTED) {
	  bc_set_state_encrypted(c);

	  if (queued_message != NULL) {
	    GaimConvIm *im = GAIM_CONV_IM(c);
	    gaim_conv_im_write(im, NULL, queued_message,
			       GAIM_MESSAGE_SEND, time(NULL));
	    /*gaim_debug(GAIM_DEBUG_ERROR, "bc_ui.c", "Y queued message: [%s]\n", queued_message);*/
	    /*fprintf(stdout, "Y queued message: [%s]\n", queued_message);*/
	    /*fprintf(stdout, "bc_ui.c: Removing from pending_messages due to CONNECT with %s: [%s]\n", c->name, key);*/
	    if (g_hash_table_remove(pending_messages, key) == FALSE) {
	      /*fprintf("bc_ui.c: Could not remove from pending_message hash table: [%s]\n", key);*/
	    }
	  } else {
	    /*fprintf(stdout, "bc_ui.c: No queued message was found.\n");*/
	    /*fprintf(stdout, "No queued message was found.\n");*/
	  }

	} else if ((newstate == TIMEDOUT) || (newstate == BUDDY_RESET)) {
	  /*fprintf(stdout, "bc_ui.c: Removing from pending_messages due to timeout/reset with %s: [%s]\n", c->name, key);*/
	  if (g_hash_table_remove(pending_messages, key) == FALSE) {
	    /*fprintf("bc_ui.c: Could not remove from pending_message hash table: [%s]\n", key);*/
	  }

	  if (newstate == BUDDY_RESET)
	    bc_system_message_with_conv(c, "Encrypted conversation reset.");

	  bc_set_state_plaintext(c);
	} else {
	  bc_set_state_transition2(c);
	}

	g_mutex_unlock(pending_messages_mutex);


      }
      
    }
  }


  g_thread_exit(&i);
  return NULL;
}


int bc_is_file_xfer_ok(char *filename) {
  GtkWidget *dialog = NULL;
  int response = 0;

  char buffer[ 512 ];

  memset(buffer, 0, sizeof(buffer));

  g_snprintf(buffer, sizeof(buffer) - 8, "Are you sure you would like to send the file, \"%s\" over an UNENCRYPTED channel?", filename);

  dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, buffer);
  response = gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);

  if (response != GTK_RESPONSE_YES)
    return 0;
  else
    return 1;
}

#endif
