/*
 * bc_ui_tor.c
 *
 * Copyright (C) 2005, J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "bc_ui_tor.h"

GString *torrc_string = NULL;

GtkWidget *win_torui_custom = NULL;

GtkWidget *btn_save = NULL;
GtkWidget *chk_usetor = NULL;
GtkWidget *chk_outgoing_ports = NULL;
GtkWidget *ent_outgoing_ports = NULL;
GtkWidget *chk_use_proxy = NULL;
GtkWidget *ent_proxy_host = NULL;
GtkWidget *ent_proxy_port = NULL;
GtkWidget *ent_proxy_username = NULL;
GtkWidget *ent_proxy_password = NULL;
GtkWidget *rb_http = NULL;
GtkWidget *rb_https = NULL;
GtkWidget *chk_usebuiltin = NULL;
GtkWidget *chk_custom_settings = NULL;
GtkWidget *ent_torport = NULL;
GtkWidget *btn_edit_settings = NULL;
GtkWidget *textview_contents = NULL;

/*GtkWidget *create_win_torui(void) {
  GtkWidget *win_torui;
  GtkWidget *fixed1;
  GtkWidget *frame2;
  GtkWidget *chk_usebuiltin;
  GtkWidget *label3;
  GtkWidget *frame1;
  GtkWidget *fixed2;
  GtkWidget *label2;
  GtkWidget *ent_torport;
  GtkWidget *btn_help;

  char buffer[ 32 ];

  memset(buffer, 0, sizeof(buffer));

  win_torui = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (win_torui, "win_torui");
  gtk_window_set_title (GTK_WINDOW (win_torui), _("Tor Setup"));
  gtk_window_set_position (GTK_WINDOW (win_torui), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (win_torui), FALSE);

  fixed1 = gtk_fixed_new ();
  gtk_widget_set_name (fixed1, "fixed1");
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (win_torui), fixed1);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame2, "frame2");
  gtk_widget_show (frame2);
  gtk_fixed_put (GTK_FIXED (fixed1), frame2, 16, 64);
  gtk_widget_set_size_request (frame2, 192, 42);

  chk_usebuiltin = gtk_check_button_new_with_mnemonic (_("Use built-in Tor"));
  gtk_widget_set_name (chk_usebuiltin, "chk_usebuiltin");
  gtk_widget_show (chk_usebuiltin);
  gtk_container_add (GTK_CONTAINER (frame2), chk_usebuiltin);

  label3 = gtk_label_new ("");
  gtk_widget_set_name (label3, "label3");
  gtk_widget_show (label3);
  gtk_frame_set_label_widget (GTK_FRAME (frame2), label3);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame1, "frame1");
  gtk_widget_show (frame1);
  gtk_fixed_put (GTK_FIXED (fixed1), frame1, 16, 16);
  gtk_widget_set_size_request (frame1, 192, 40);

  fixed2 = gtk_fixed_new ();
  gtk_widget_set_name (fixed2, "fixed2");
  gtk_widget_show (fixed2);
  gtk_container_add (GTK_CONTAINER (frame1), fixed2);

  label2 = gtk_label_new (_("Port:"));
  gtk_widget_set_name (label2, "label2");
  gtk_widget_show (label2);
  gtk_fixed_put (GTK_FIXED (fixed2), label2, 96, 10);
  gtk_widget_set_size_request (label2, 34, 16);

  ent_torport = gtk_entry_new ();
  gtk_widget_set_name (ent_torport, "ent_torport");
  gtk_widget_show (ent_torport);
  gtk_fixed_put (GTK_FIXED (fixed2), ent_torport, 136, 8);
  gtk_widget_set_size_request (ent_torport, 48, 24);
  gtk_widget_set_sensitive (ent_torport, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (ent_torport), FALSE);
  gtk_entry_set_text (GTK_ENTRY (ent_torport), _("9050"));
  gtk_entry_set_width_chars (GTK_ENTRY (ent_torport), 5);

  chk_usetor = gtk_check_button_new_with_mnemonic (_("Use Tor"));
  gtk_widget_set_name (chk_usetor, "chk_usetor");
  gtk_widget_show (chk_usetor);
  gtk_fixed_put (GTK_FIXED (fixed2), chk_usetor, 2, 8);
  gtk_widget_set_size_request (chk_usetor, 72, 21);

  btn_help = gtk_button_new_from_stock ("gtk-help");
  gtk_widget_set_name (btn_help, "btn_help");
  gtk_widget_show (btn_help);
  gtk_fixed_put (GTK_FIXED (fixed1), btn_help, 120, 128);
  gtk_widget_set_size_request (btn_help, 72, 34);

  btn_save = gtk_button_new_from_stock ("gtk-save");
  gtk_widget_set_name (btn_save, "btn_save");
  gtk_widget_show (btn_save);
  gtk_fixed_put (GTK_FIXED (fixed1), btn_save, 24, 128);
  gtk_widget_set_size_request (btn_save, 72, 34);

  gtk_widget_set_size_request (win_torui, 225, 175);

  gtk_window_set_modal(GTK_WINDOW(win_torui), TRUE);


  g_signal_connect(GTK_OBJECT(btn_save), "clicked",
                     (GtkSignalFunc)btn_save_clicked, win_torui);


  bc_prefs_get(BC_PREFS_USE_TOR, buffer, sizeof(buffer - 8));
  if (strcmp(buffer, BC_PREFS_YES) == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_usetor), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_usetor), FALSE);

  return win_torui;
}
*/

GtkWidget *create_win_torui(void) {
  GtkWidget *win_torui;
  GtkWidget *fixed1;
  GtkWidget *frame1;
  GtkWidget *fixed2;
  GtkWidget *label2;
  GtkWidget *btn_usetor_help;

  GtkWidget *frame2;
  GtkWidget *fixed3;
  GtkWidget *hseparator1;
  GtkWidget *hseparator2;
  GtkWidget *label4;
  GtkWidget *hseparator3;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *label3;
  GtkWidget *btn_outgoing_help;
  GtkWidget *btn_builtin_help;
  GtkWidget *btn_proxy_help;
  GtkWidget *btn_custom_help;
  GtkWidget *btn_save;
  GtkWidget *btn_close;
  GSList *rb_http_group = NULL;
 
  rb_http_group = g_slist_append(rb_http_group, "x");

  win_torui = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (win_torui, "win_torui");
  gtk_window_set_title (GTK_WINDOW (win_torui), _("Tor Setup"));
  gtk_window_set_position (GTK_WINDOW (win_torui), GTK_WIN_POS_CENTER);

  fixed1 = gtk_fixed_new ();
  gtk_widget_set_name (fixed1, "fixed1");
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (win_torui), fixed1);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame1, "frame1");
  gtk_widget_show (frame1);
  gtk_fixed_put (GTK_FIXED (fixed1), frame1, 16, 16);
  gtk_widget_set_size_request (frame1, 255, 40);

  fixed2 = gtk_fixed_new ();
  gtk_widget_set_name (fixed2, "fixed2");
  gtk_widget_show (fixed2);
  gtk_container_add (GTK_CONTAINER (frame1), fixed2);

  ent_torport = gtk_entry_new ();
  gtk_widget_set_name (ent_torport, "ent_torport");
  gtk_widget_show (ent_torport);
  gtk_fixed_put (GTK_FIXED (fixed2), ent_torport, 144, 4);
  gtk_widget_set_size_request (ent_torport, 48, 24);
  /*gtk_widget_set_sensitive (ent_torport, FALSE);*/
  gtk_entry_set_text (GTK_ENTRY (ent_torport), _("9050"));
  gtk_entry_set_width_chars (GTK_ENTRY (ent_torport), 5);

  label2 = gtk_label_new (_("Port:"));
  gtk_widget_set_name (label2, "label2");
  gtk_widget_show (label2);
  gtk_fixed_put (GTK_FIXED (fixed2), label2, 104, 10);
  gtk_widget_set_size_request (label2, 34, 16);

  btn_usetor_help = gtk_button_new_with_mnemonic (_("?"));
  gtk_widget_set_name (btn_usetor_help, "btn_usetor_help");
  gtk_widget_show (btn_usetor_help);
  gtk_fixed_put (GTK_FIXED (fixed2), btn_usetor_help, 216, 4);
  gtk_widget_set_size_request (btn_usetor_help, 24, 24);

  chk_usetor = gtk_check_button_new_with_mnemonic (_("Use Tor"));
  gtk_widget_set_name (chk_usetor, "chk_usetor");
  gtk_widget_show (chk_usetor);
  gtk_fixed_put (GTK_FIXED (fixed2), chk_usetor, 2, 8);
  gtk_widget_set_size_request (chk_usetor, 72, 21);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chk_usetor), TRUE);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame2, "frame2");
  gtk_widget_show (frame2);
  gtk_fixed_put (GTK_FIXED (fixed1), frame2, 16, 64);
  gtk_widget_set_size_request (frame2, 256, 248);

  fixed3 = gtk_fixed_new ();
  gtk_widget_set_name (fixed3, "fixed3");
  gtk_widget_show (fixed3);
  gtk_container_add (GTK_CONTAINER (frame2), fixed3);

  ent_outgoing_ports = gtk_entry_new ();
  gtk_widget_set_name (ent_outgoing_ports, "ent_outgoing_ports");
  gtk_widget_show (ent_outgoing_ports);
  gtk_fixed_put (GTK_FIXED (fixed3), ent_outgoing_ports, 120, 48);
  gtk_widget_set_size_request (ent_outgoing_ports, 80, 24);
  gtk_entry_set_text (GTK_ENTRY (ent_outgoing_ports), _("80, 443"));

  ent_proxy_host = gtk_entry_new ();
  gtk_widget_set_name (ent_proxy_host, "ent_proxy_host");
  gtk_widget_show (ent_proxy_host);
  gtk_fixed_put (GTK_FIXED (fixed3), ent_proxy_host, 72, 110);
  gtk_widget_set_size_request (ent_proxy_host, 93, 24);

  ent_proxy_port = gtk_entry_new ();
  gtk_widget_set_name (ent_proxy_port, "ent_proxy_port");
  gtk_widget_show (ent_proxy_port);
  gtk_fixed_put (GTK_FIXED (fixed3), ent_proxy_port, 176, 110);
  gtk_widget_set_size_request (ent_proxy_port, 32, 24);
  gtk_entry_set_max_length (GTK_ENTRY (ent_proxy_port), 5);

  ent_proxy_username = gtk_entry_new ();
  gtk_widget_set_name (ent_proxy_username, "ent_proxy_username");
  gtk_widget_show (ent_proxy_username);
  gtk_fixed_put (GTK_FIXED (fixed3), ent_proxy_username, 72, 138);
  gtk_widget_set_size_request (ent_proxy_username, 136, 24);

  ent_proxy_password = gtk_entry_new ();
  gtk_widget_set_name (ent_proxy_password, "ent_proxy_password");
  gtk_widget_show (ent_proxy_password);
  gtk_fixed_put (GTK_FIXED (fixed3), ent_proxy_password, 72, 166);
  gtk_widget_set_size_request (ent_proxy_password, 136, 24);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator1, "hseparator1");
  gtk_widget_show (hseparator1);
  gtk_fixed_put (GTK_FIXED (fixed3), hseparator1, 8, 32);
  gtk_widget_set_size_request (hseparator1, 224, 16);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator2, "hseparator2");
  gtk_widget_show (hseparator2);
  gtk_fixed_put (GTK_FIXED (fixed3), hseparator2, 8, 72);
  gtk_widget_set_size_request (hseparator2, 224, 16);

  label4 = gtk_label_new (_(":"));
  gtk_widget_set_name (label4, "label4");
  gtk_widget_show (label4);
  gtk_fixed_put (GTK_FIXED (fixed3), label4, 168, 111);
  gtk_widget_set_size_request (label4, 4, 16);

  hseparator3 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator3, "hseparator3");
  gtk_widget_show (hseparator3);
  gtk_fixed_put (GTK_FIXED (fixed3), hseparator3, 8, 192);
  gtk_widget_set_size_request (hseparator3, 224, 16);

  label5 = gtk_label_new (_("Username:"));
  gtk_widget_set_name (label5, "label5");
  gtk_widget_show (label5);
  gtk_fixed_put (GTK_FIXED (fixed3), label5, 2, 141);
  gtk_widget_set_size_request (label5, 66, 16);

  label6 = gtk_label_new (_("Password:"));
  gtk_widget_set_name (label6, "label6");
  gtk_widget_show (label6);
  gtk_fixed_put (GTK_FIXED (fixed3), label6, 2, 166);
  gtk_widget_set_size_request (label6, 63, 16);

  label3 = gtk_label_new (_("Proxy:"));
  gtk_widget_set_name (label3, "label3");
  gtk_widget_show (label3);
  gtk_fixed_put (GTK_FIXED (fixed3), label3, 4, 114);
  gtk_widget_set_size_request (label3, 36, 16);

  chk_usebuiltin = gtk_check_button_new_with_mnemonic (_("Use built-in Tor"));
  gtk_widget_set_name (chk_usebuiltin, "chk_usebuiltin");
  gtk_widget_show (chk_usebuiltin);
  gtk_fixed_put (GTK_FIXED (fixed3), chk_usebuiltin, 2, 8);
  gtk_widget_set_size_request (chk_usebuiltin, 118, 21);

  btn_outgoing_help = gtk_button_new_with_mnemonic (_("?"));
  gtk_widget_set_name (btn_outgoing_help, "btn_outgoing_help");
  gtk_widget_show (btn_outgoing_help);
  gtk_fixed_put (GTK_FIXED (fixed3), btn_outgoing_help, 216, 48);
  gtk_widget_set_size_request (btn_outgoing_help, 24, 26);

  btn_builtin_help = gtk_button_new_with_mnemonic (_("?"));
  gtk_widget_set_name (btn_builtin_help, "btn_builtin_help");
  gtk_widget_show (btn_builtin_help);
  gtk_fixed_put (GTK_FIXED (fixed3), btn_builtin_help, 216, 8);
  gtk_widget_set_size_request (btn_builtin_help, 24, 24);

  chk_outgoing_ports = gtk_check_button_new_with_mnemonic (_("Outgoing ports:"));
  gtk_widget_set_name (chk_outgoing_ports, "chk_outgoing_ports");
  gtk_widget_show (chk_outgoing_ports);
  gtk_fixed_put (GTK_FIXED (fixed3), chk_outgoing_ports, 2, 48);
  gtk_widget_set_size_request (chk_outgoing_ports, 110, 24);

  chk_use_proxy = gtk_check_button_new_with_mnemonic (_("Use proxy"));
  gtk_widget_set_name (chk_use_proxy, "chk_use_proxy");
  gtk_widget_show (chk_use_proxy);
  gtk_fixed_put (GTK_FIXED (fixed3), chk_use_proxy, 2, 87);
  gtk_widget_set_size_request (chk_use_proxy, 86, 21);

  rb_http = gtk_radio_button_new_with_mnemonic (NULL, _("HTTP"));
  gtk_widget_set_name (rb_http, "rb_http");
  gtk_widget_show (rb_http);
  gtk_fixed_put (GTK_FIXED (fixed3), rb_http, 85, 87);
  gtk_widget_set_size_request (rb_http, 56, 21);
  /*gtk_radio_button_set_group (GTK_RADIO_BUTTON (rb_http), rb_http_group);
    rb_http_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (rb_http));*/

  /*rb_https = gtk_radio_button_new_with_mnemonic (NULL, _("HTTPS"));*/
  rb_https = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(rb_http), _("HTTPS"));

  gtk_widget_set_name (rb_https, "rb_https");
  gtk_widget_show (rb_https);
  gtk_fixed_put (GTK_FIXED (fixed3), rb_https, 145, 87);
  gtk_widget_set_size_request (rb_https, 65, 21);
  /*gtk_radio_button_set_group (GTK_RADIO_BUTTON (rb_https), rb_http_group);
    rb_http_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (rb_https));*/

  btn_proxy_help = gtk_button_new_with_mnemonic (_("?"));
  gtk_widget_set_name (btn_proxy_help, "btn_proxy_help");
  gtk_widget_show (btn_proxy_help);
  gtk_fixed_put (GTK_FIXED (fixed3), btn_proxy_help, 216, 87);
  gtk_widget_set_size_request (btn_proxy_help, 24, 24);

  chk_custom_settings = gtk_check_button_new_with_mnemonic (_("Customize settings"));
  gtk_widget_set_name (chk_custom_settings, "chk_custom_settings");
  gtk_widget_show (chk_custom_settings);
  gtk_fixed_put (GTK_FIXED (fixed3), chk_custom_settings, 2, 208);
  gtk_widget_set_size_request (chk_custom_settings, 134, 21);

  btn_edit_settings = gtk_button_new_with_mnemonic (_("Edit ..."));
  gtk_widget_set_name (btn_edit_settings, "btn_edit_settings");
  gtk_widget_show (btn_edit_settings);
  gtk_fixed_put (GTK_FIXED (fixed3), btn_edit_settings, 152, 207);
  gtk_widget_set_size_request (btn_edit_settings, 48, 26);

  btn_custom_help = gtk_button_new_with_mnemonic (_("?"));
  gtk_widget_set_name (btn_custom_help, "btn_custom_help");
  gtk_widget_show (btn_custom_help);
  gtk_fixed_put (GTK_FIXED (fixed3), btn_custom_help, 216, 207);
  gtk_widget_set_size_request (btn_custom_help, 24, 24);

  btn_save = gtk_button_new_from_stock ("gtk-save");
  gtk_widget_set_name (btn_save, "btn_save");
  gtk_widget_show (btn_save);
  gtk_fixed_put (GTK_FIXED (fixed1), btn_save, 48, 328);
  gtk_widget_set_size_request (btn_save, 72, 34);

  btn_close = gtk_button_new_from_stock ("gtk-close");
  gtk_widget_set_name (btn_close, "btn_close");
  gtk_widget_show (btn_close);
  gtk_fixed_put (GTK_FIXED (fixed1), btn_close, 152, 328);
  gtk_widget_set_size_request (btn_close, 72, 34);

  gtk_window_set_modal(GTK_WINDOW(win_torui), TRUE);
  gtk_widget_set_size_request (win_torui, 285, 375);
  gtk_window_set_resizable (GTK_WINDOW (win_torui), FALSE);


  gtk_widget_set_sensitive(chk_outgoing_ports, FALSE);
  gtk_widget_set_sensitive(ent_outgoing_ports, FALSE);

  gtk_widget_set_sensitive(chk_use_proxy, FALSE);
  gtk_widget_set_sensitive(rb_http, FALSE);
  gtk_widget_set_sensitive(rb_https, FALSE);

  gtk_widget_set_sensitive(ent_proxy_host, FALSE);
  gtk_widget_set_sensitive(ent_proxy_port, FALSE);
  gtk_widget_set_sensitive(ent_proxy_username, FALSE);
  gtk_widget_set_sensitive(ent_proxy_password, FALSE);
  gtk_widget_set_sensitive(rb_http, FALSE);
  gtk_widget_set_sensitive(rb_https, FALSE);

  gtk_widget_set_sensitive(chk_custom_settings, FALSE);
  gtk_widget_set_sensitive(btn_edit_settings, FALSE);

  gtk_widget_set_sensitive(chk_usebuiltin, FALSE);




  g_signal_connect(GTK_OBJECT(btn_save), "clicked",
                     (GtkSignalFunc)btn_save_clicked, win_torui);
  g_signal_connect(GTK_OBJECT(btn_close), "clicked",
                     (GtkSignalFunc)btn_close_clicked, win_torui);
  g_signal_connect(GTK_OBJECT(chk_outgoing_ports), "clicked",
                     (GtkSignalFunc)chk_outgoing_ports_clicked, NULL);
  g_signal_connect(GTK_OBJECT(chk_use_proxy), "clicked",
                     (GtkSignalFunc)chk_use_proxy_clicked, NULL);
  g_signal_connect(GTK_OBJECT(chk_usetor), "clicked",
                     (GtkSignalFunc)chk_usetor_clicked, NULL);
  g_signal_connect(GTK_OBJECT(chk_usebuiltin), "clicked",
                     (GtkSignalFunc)chk_usebuiltin_clicked, NULL);
  g_signal_connect(GTK_OBJECT(chk_custom_settings), "clicked",
                     (GtkSignalFunc)chk_custom_settings_clicked, NULL);
  g_signal_connect(GTK_OBJECT(btn_edit_settings), "clicked",
                     (GtkSignalFunc)btn_edit_settings_clicked, win_torui);

  g_signal_connect(GTK_OBJECT(btn_usetor_help), "clicked",
                     (GtkSignalFunc)btn_usetor_help_clicked, win_torui);

  g_signal_connect(GTK_OBJECT(btn_outgoing_help), "clicked",
                     (GtkSignalFunc)btn_outgoing_help_clicked, win_torui);
  g_signal_connect(GTK_OBJECT(btn_builtin_help), "clicked",
                     (GtkSignalFunc)btn_builtin_help_clicked, win_torui);
  g_signal_connect(GTK_OBJECT(btn_proxy_help), "clicked",
                     (GtkSignalFunc)btn_proxy_help_clicked, win_torui);
  g_signal_connect(GTK_OBJECT(btn_custom_help), "clicked",
                     (GtkSignalFunc)btn_custom_help_clicked, win_torui);


  load_tor_prefs_into_ui();

  return win_torui;
}



void show_torui(void) {
  GtkWidget *win_torui = NULL;

#ifdef _WIN32
  tor_kill();
#endif

  win_torui = create_win_torui();
  gtk_widget_show(win_torui);
}

void chk_custom_settings_clicked(GtkWidget *widget, gpointer data) {
  gboolean flag = FALSE;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_custom_settings)))
    flag = TRUE;

  if (flag == TRUE) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_outgoing_ports), FALSE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_use_proxy), FALSE);
  }

  gtk_widget_set_sensitive(chk_outgoing_ports, !flag);
  gtk_widget_set_sensitive(chk_use_proxy, !flag);

  gtk_widget_set_sensitive(btn_edit_settings, flag);
}

void btn_edit_settings_clicked(GtkWidget *widget, gpointer data) {
  build_torrc_string();
  show_torui_custom();
}

void chk_usetor_clicked(GtkWidget *widget, gpointer data) {
  gboolean flag = FALSE;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_usetor)))
    flag = TRUE;

  gtk_widget_set_sensitive(ent_torport, flag);

#ifdef _WIN32
  /* Only the Win32 build comes with Tor built-in. */
  gtk_widget_set_sensitive(chk_usebuiltin, flag);
#endif

  if (flag == FALSE)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_usebuiltin), FALSE);

#ifdef _WIN32
  /* The Win32 version should use the built-in version by default. */
  if (flag == TRUE)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_usebuiltin), TRUE);
#endif
}

void chk_usebuiltin_clicked(GtkWidget *widget, gpointer data) {
  gboolean flag = FALSE;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_usebuiltin)))
    flag = TRUE;

  if (flag == FALSE) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_custom_settings), FALSE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_outgoing_ports), FALSE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_use_proxy), FALSE);
  }

  gtk_widget_set_sensitive(chk_outgoing_ports, flag);
  gtk_widget_set_sensitive(chk_use_proxy, flag);
  gtk_widget_set_sensitive(chk_custom_settings, flag);
}


void chk_outgoing_ports_clicked(GtkWidget *widget, gpointer data) {
  gtk_widget_set_sensitive(ent_outgoing_ports, gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_outgoing_ports)));
}

void chk_use_proxy_clicked(GtkWidget *widget, gpointer data) {
  gboolean flag = FALSE;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_use_proxy)))
    flag = TRUE;

  gtk_widget_set_sensitive(ent_proxy_host, flag);
  gtk_widget_set_sensitive(ent_proxy_port, flag);
  gtk_widget_set_sensitive(ent_proxy_username, flag);
  gtk_widget_set_sensitive(ent_proxy_password, flag);
  gtk_widget_set_sensitive(rb_http, flag);
  gtk_widget_set_sensitive(rb_https, flag);
}

void btn_save_clicked(GtkWidget *widget, gpointer data) {
  GtkWidget *window = (GtkWidget *)data;

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_usetor)))
    bc_prefs_set(BC_PREFS_TOR_ENABLED, BC_PREFS_YES);
  else {
    bc_prefs_set(BC_PREFS_TOR_ENABLED, BC_PREFS_NO);
    bc_tor_restore_proxy_settings();
  }

  bc_prefs_set(BC_PREFS_TOR_PORT, (char *)gtk_entry_get_text(GTK_ENTRY(ent_torport)));


  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_usebuiltin)))
    bc_prefs_set(BC_PREFS_TOR_USE_BUILTIN, BC_PREFS_YES);
  else
    bc_prefs_set(BC_PREFS_TOR_USE_BUILTIN, BC_PREFS_NO);

  
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_outgoing_ports)))
    bc_prefs_set(BC_PREFS_TOR_USE_OUTGOING_PORTS, BC_PREFS_YES);
  else
    bc_prefs_set(BC_PREFS_TOR_USE_OUTGOING_PORTS, BC_PREFS_NO);

  bc_prefs_set(BC_PREFS_TOR_OUTGOING_PORTS, (char *)gtk_entry_get_text(GTK_ENTRY(ent_outgoing_ports)));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_use_proxy)))
    bc_prefs_set(BC_PREFS_TOR_USE_PROXY, BC_PREFS_YES);
  else
    bc_prefs_set(BC_PREFS_TOR_USE_PROXY, BC_PREFS_NO);

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rb_http)))
    bc_prefs_set(BC_PREFS_TOR_PROXY_USE_HTTP, BC_PREFS_YES);
  else
    bc_prefs_set(BC_PREFS_TOR_PROXY_USE_HTTP, BC_PREFS_NO);

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rb_https)))
    bc_prefs_set(BC_PREFS_TOR_PROXY_USE_HTTPS, BC_PREFS_YES);
  else
    bc_prefs_set(BC_PREFS_TOR_PROXY_USE_HTTPS, BC_PREFS_NO);


  bc_prefs_set(BC_PREFS_TOR_PROXY_HOST, (char *)gtk_entry_get_text(GTK_ENTRY(ent_proxy_host)));
  bc_prefs_set(BC_PREFS_TOR_PROXY_PORT, (char *)gtk_entry_get_text(GTK_ENTRY(ent_proxy_port)));

  bc_prefs_set(BC_PREFS_TOR_PROXY_USERNAME, (char *)gtk_entry_get_text(GTK_ENTRY(ent_proxy_username)));
  bc_prefs_set(BC_PREFS_TOR_PROXY_PASSWORD, (char *)gtk_entry_get_text(GTK_ENTRY(ent_proxy_password)));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_custom_settings)))
    bc_prefs_set(BC_PREFS_TOR_USE_CUSTOM_SETTINGS, BC_PREFS_YES);
  else
    bc_prefs_set(BC_PREFS_TOR_USE_CUSTOM_SETTINGS, BC_PREFS_NO);


  build_torrc_string();

  bc_prefs_save();

  write_tor_config(torrc_string->str);

  gtk_widget_destroy(window);
}

void btn_close_clicked(GtkWidget *widget, gpointer data) {
  GtkWidget *window = (GtkWidget *)data;
  gtk_widget_destroy(window);
}



GtkWidget *create_win_torui_custom(void) {
  GtkWidget *win_torui_custom;
  GtkWidget *fixed4;
  GtkWidget *frame3;
  GtkWidget *scrolledwindow1;
  GtkWidget *btn_save_custom;
  GtkWidget *btn_close_custom;;
  GtkTextBuffer *textbuffer_default = NULL;

  win_torui_custom = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (win_torui_custom, "win_torui_custom");
  gtk_window_set_title (GTK_WINDOW (win_torui_custom), _("Custom Tor Settings"));
  gtk_window_set_position (GTK_WINDOW (win_torui_custom), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (win_torui_custom), TRUE);

  fixed4 = gtk_fixed_new ();
  gtk_widget_set_name (fixed4, "fixed4");
  gtk_widget_show (fixed4);
  gtk_container_add (GTK_CONTAINER (win_torui_custom), fixed4);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame3, "frame3");
  gtk_widget_show (frame3);
  gtk_fixed_put (GTK_FIXED (fixed4), frame3, 8, 8);
  gtk_widget_set_size_request (frame3, 384, 344);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (frame3), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_ALWAYS, GTK_POLICY_AUTOMATIC);

  textview_contents = gtk_text_view_new ();
  gtk_widget_set_name (textview_contents, "textview_contents");
  gtk_widget_show (textview_contents);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), textview_contents);

  btn_close_custom = gtk_button_new_from_stock ("gtk-close");
  gtk_widget_show (btn_close_custom);
  gtk_fixed_put (GTK_FIXED (fixed4), btn_close_custom, 224, 368);
  gtk_widget_set_size_request (btn_close_custom, 72, 34);

  btn_save_custom = gtk_button_new_from_stock ("gtk-save");
  gtk_widget_show (btn_save_custom);
  gtk_fixed_put (GTK_FIXED (fixed4), btn_save_custom, 104, 368);
  gtk_widget_set_size_request (btn_save_custom, 72, 34);

  gtk_widget_set_size_request(win_torui_custom, 400, 420);
  gtk_window_set_resizable (GTK_WINDOW (win_torui_custom), FALSE);


  textbuffer_default = gtk_text_buffer_new(NULL);
  if (torrc_string != NULL) {
    gtk_text_buffer_set_text(textbuffer_default, torrc_string->str,
			     strlen(torrc_string->str));
  } else {
    char buffer[ 1024 ];

    memset(buffer, 0, sizeof(buffer));

    bc_prefs_get(BC_PREFS_TOR_CUSTOM_SETTINGS_DATA, buffer, sizeof(buffer) - 8);
    gtk_text_buffer_set_text(textbuffer_default, buffer, strlen(buffer));
  }

  gtk_text_view_set_buffer((GtkTextView *)textview_contents, textbuffer_default);

  g_signal_connect(GTK_OBJECT(btn_close_custom), "clicked",
                     (GtkSignalFunc)btn_close_custom_clicked, win_torui_custom);
  g_signal_connect(GTK_OBJECT(btn_save_custom), "clicked",
                     (GtkSignalFunc)btn_save_custom_clicked, win_torui_custom);


  return win_torui_custom;
}

void btn_close_custom_clicked(GtkWidget *widget, gpointer data) {
  gtk_widget_destroy((GtkWidget *)data);
}

void btn_save_custom_clicked(GtkWidget *widget, gpointer data) {
  GtkTextBuffer *textbuffer = gtk_text_view_get_buffer((GtkTextView *)textview_contents);
  gchar *custom_settings = NULL;
  GtkTextIter iter_start;
  GtkTextIter iter_end;

  gtk_text_buffer_get_iter_at_offset(textbuffer, &iter_start, 0);
  gtk_text_buffer_get_iter_at_offset(textbuffer, &iter_end, -1);


  custom_settings = gtk_text_buffer_get_text(textbuffer, &iter_start, &iter_end, FALSE);


  if (torrc_string != NULL) {
    g_string_free(torrc_string, TRUE);  torrc_string = NULL;
  }
  torrc_string = g_string_new(custom_settings);

  bc_prefs_set(BC_PREFS_TOR_CUSTOM_SETTINGS_DATA, custom_settings);
  gtk_widget_destroy((GtkWidget *)data);
}


void show_torui_custom(void) {

  win_torui_custom = create_win_torui_custom();
  gtk_widget_show(win_torui_custom);

}

void load_tor_prefs_into_ui(void) {
  char buffer[ 256 ];

  memset(buffer, 0, sizeof(buffer));


  bc_prefs_get(BC_PREFS_TOR_ENABLED, buffer, sizeof(buffer) - 8);
  if (strcmp(buffer, BC_PREFS_YES) == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_usetor), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_usetor), FALSE);

  
  bc_prefs_get(BC_PREFS_TOR_PORT, buffer, sizeof(buffer) - 8);
  gtk_entry_set_text(GTK_ENTRY(ent_torport), buffer);


  bc_prefs_get(BC_PREFS_TOR_USE_BUILTIN, buffer, sizeof(buffer) - 8);
  if (strcmp(buffer, BC_PREFS_YES) == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_usebuiltin), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_usebuiltin), FALSE);


  bc_prefs_get(BC_PREFS_TOR_USE_OUTGOING_PORTS, buffer, sizeof(buffer) - 8);
  if (strcmp(buffer, BC_PREFS_YES) == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_outgoing_ports), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_outgoing_ports), FALSE);


  bc_prefs_get(BC_PREFS_TOR_OUTGOING_PORTS, buffer, sizeof(buffer) - 8);
  gtk_entry_set_text(GTK_ENTRY(ent_outgoing_ports), buffer);


  bc_prefs_get(BC_PREFS_TOR_USE_PROXY, buffer, sizeof(buffer - 8));
  if (strcmp(buffer, BC_PREFS_YES) == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_use_proxy), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_use_proxy), FALSE);


  bc_prefs_get(BC_PREFS_TOR_PROXY_USE_HTTP, buffer, sizeof(buffer) - 8);
  if (strcmp(buffer, BC_PREFS_YES) == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rb_http), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rb_http), FALSE);


  bc_prefs_get(BC_PREFS_TOR_PROXY_USE_HTTPS, buffer, sizeof(buffer) - 8);
  if (strcmp(buffer, BC_PREFS_YES) == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rb_https), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rb_https), FALSE);


  bc_prefs_get(BC_PREFS_TOR_PROXY_HOST, buffer, sizeof(buffer) - 8);
  gtk_entry_set_text(GTK_ENTRY(ent_proxy_host), buffer);

  bc_prefs_get(BC_PREFS_TOR_PROXY_PORT, buffer, sizeof(buffer) - 8);
  gtk_entry_set_text(GTK_ENTRY(ent_proxy_port), buffer);

  bc_prefs_get(BC_PREFS_TOR_PROXY_USERNAME, buffer, sizeof(buffer) - 8);
  gtk_entry_set_text(GTK_ENTRY(ent_proxy_username), buffer);

  bc_prefs_get(BC_PREFS_TOR_PROXY_PASSWORD, buffer, sizeof(buffer) - 8);
  gtk_entry_set_text(GTK_ENTRY(ent_proxy_password), buffer);

  bc_prefs_get(BC_PREFS_TOR_USE_CUSTOM_SETTINGS, buffer, sizeof(buffer) - 8);
  if (strcmp(buffer, BC_PREFS_YES) == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_custom_settings), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_custom_settings), FALSE);

}

void btn_usetor_help_clicked(GtkWidget *widget, gpointer data) {
  bc_dialog("Tor is an external program which lets you connect anonymously to other systems on the Internet.  It also allows you to bypass national firewalls and state-sponsored censorship.\n\nSee section X.X of the User's Manual for tips on maximizing your anonymity.", GTK_MESSAGE_INFO, (GtkWidget *)data);
}

void btn_builtin_help_clicked(GtkWidget *widget, gpointer data) {
  bc_dialog("The Windows installer comes with Tor built-in to maximize ease of use.  If you have Tor already installed and running on your system, you may wish to use that instead of the packaged version.\n\nIf you are unsure what to do, leave this option enabled.", GTK_MESSAGE_INFO, (GtkWidget *)data);
}

void btn_outgoing_help_clicked(GtkWidget *widget, gpointer data) {
  bc_dialog("If you are behind a firewall that restricts outgoing connections, then you can use this option to make Tor connect to onion routers via the ports list specified (default is 80 and 443, which should work in most cases).\n\nIf you are unsure about this setting, leave it off\n\nThis option only affects the built-in Tor program on Windows.", GTK_MESSAGE_INFO, (GtkWidget *)data);
}

void btn_proxy_help_clicked(GtkWidget *widget, gpointer data) {
  bc_dialog("If you are behind a proxy, you must enter the relevant information so that outgoing connections can be made.  The username and password fields may be left blank if your proxy does not require them.\n\nThis option only affects the built-in Tor program on Windows.", GTK_MESSAGE_INFO, (GtkWidget *)data);
}

void btn_custom_help_clicked(GtkWidget *widget, gpointer data) {
  bc_dialog("If you are an advanced user, you may wish to manually edit the options passed to Tor.  Do not do this unless you really know what you are doing.\n\nThis option only affects the built-in Tor program on Windows.", GTK_MESSAGE_INFO, (GtkWidget *)data);
}

void build_torrc_string(void) {
  if (torrc_string != NULL) {
    g_string_free(torrc_string, TRUE);  torrc_string = NULL;
  }

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_custom_settings))) {
    char buffer[ 1024 ];

    memset(buffer, 0, sizeof(buffer));

    bc_prefs_get(BC_PREFS_TOR_CUSTOM_SETTINGS_DATA,buffer,sizeof(buffer) - 8);
    torrc_string = g_string_new(buffer);
    return;
  }



  torrc_string = g_string_new("# THIS FILE IS RE-GENERATED AUTOMATICALLY.  DO NOT EDIT\r\nDataDirectory $datadir\r\nClientOnly 1\r\nRunAsDaemon 1\r\n");

  g_string_append_printf(torrc_string, "SOCKSPort %s\r\n", gtk_entry_get_text(GTK_ENTRY(ent_torport)));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_outgoing_ports))) {
    g_string_append_printf(torrc_string, "FascistFirewall 1\r\nFirewallPorts %s\r\n", gtk_entry_get_text(GTK_ENTRY(ent_outgoing_ports)));
  }


  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_use_proxy))) {
    const gchar *host = gtk_entry_get_text(GTK_ENTRY(ent_proxy_host));
    const gchar *port = gtk_entry_get_text(GTK_ENTRY(ent_proxy_port));
    const gchar *username = gtk_entry_get_text(GTK_ENTRY(ent_proxy_username));
    const gchar *password = gtk_entry_get_text(GTK_ENTRY(ent_proxy_password));
    gboolean isHTTP = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rb_http));
    if (isHTTP)
      g_string_append_printf(torrc_string, "HttpProxy %s:%s\r\n", host, port);
    else
      g_string_append_printf(torrc_string, "HttpsProxy %s:%s\r\n", host, port);

    if (isHTTP && (g_strcasecmp(username, "") != 0)) {
      g_string_append_printf(torrc_string, "HttpProxyAuthenticator %s:%s\r\n",
			     username, password);
    } else if (g_strcasecmp(username, "") != 0){
      g_string_append_printf(torrc_string, "HttpsProxyAuthenticator %s:%s\r\n",
			     username, password);
    }

  }


}
