/*
 * bc_main.h
 *
 * Copyright (C) 2004-2005 J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef BC_MAIN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gaim.h>
#include <core.h>
#include <version.h>

#include "bc_proghandler.h"
#include "bc_ui.h"
#include "blist.h"
#include "debug.h"
#include "ft.h"
#include "gaim.h"
#include "gtkconv.h"
#include "gtkplugin.h"
#include "gtkutils.h"
#include "signals.h"
#include "util.h"



#define BC_PROCESS_MESSAGE_UNUSED 0
#define BC_PROCESS_MESSAGE_ENCRYPTED 1
#define BC_PROCESS_MESSAGE_CLEARTEXT 2
#define BC_PROCESS_MESSAGE_ACTIONABLE_HANDSHAKE 3
#define BC_PROCESS_MESSAGE_NONACTIONABLE_HANDSHAKE 4
#define BC_PROCESS_MESSAGE_PUBLICKEY 5



/*extern void gaim_xfer_conversation_write(GaimXfer *xfer, char *message,
  gboolean is_error);*/

/*extern void gaim_xfer_show_file_error(GaimXfer *xfer, const char *filename);*/

extern char *get_status(char *who, GaimAccount *acct);

extern void show_um_init_window(unsigned int grab_mutex);



int bc_generate_key(const char *id, gchar *id_pw,
		    char *fingerprint_buffer,
		    size_t fingerprint_buffer_len);

int bc_do_tor_stuff(void);

void bc_plugin_init(void);

int bc_tor_restore_proxy_settings(void);

int bc_tor_set_proxy_settings(void);

void buddy_signoff_handler(GaimBuddy *b, void *data);

gboolean get_handler(GaimAccount *acct, char **who, char **message,
		     GaimConvImFlags flags, void *m);

char *get_status(char *who, GaimAccount *acct);

char *get_umid(char *who, GaimAccount *acct);

int handle_fingerprint(GaimAccount *acct, GaimConversation *c,
		       char *who, char *data);

int is_encryption_id_selected(void);

void quitting_handler(void *x, void *y);

void send_handler(GaimAccount *acct, char *who, char **message, void *m);

void signoff_handler(GaimConnection *gc, void *data);

void signon_handler(GaimConnection *gc, void *data);


#endif

