/**
 * bc_ui.h
 *
 * Copyright (C) 2003-2005, J. Salvatore Testa II
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* TODO:  Add comments! */

#ifndef BC_UI_H
#define BC_UI_H

#include "bc_export_ui.h"
#include "bc_prefs.h"
#include "bc_proghandler.h"
#include "bc_ui_state.h"
#include "bc_utils.h"

#include "gaim.h"
#include "gtkutils.h"
#include "notify.h"
#include "pixmaps/bc_greenlock.xpm"
#include "pixmaps/bc_redlock.xpm"
#include "pixmaps/bc_yellowlock.xpm"
#include "util.h"



#define ACTION_REJECT 0
#define ACTION_ACCEPT_TEMPORARILY 1
#define ACTION_ACCEPT_PERMANENTLY 2

#define STATE_FLAG_REMOVE 0
#define STATE_FLAG_ADD    1
#define STATE_FLAG_SET    2



static const GtkStockItem stockitems[] = {
  { "BC_Encrypted", "_GTK!", (GdkModifierType)0, 0, NULL },
  { "BC_Plaintext", "_GTK!", (GdkModifierType)0, 0, NULL },
  { "BC_Transition_1", "_GTK!", (GdkModifierType)0, 0, NULL },
  { "BC_Transition_2", "_GTK!", (GdkModifierType)0, 0, NULL },
};



struct NEW_FP_STRUCT {
  GtkWidget *fp_window;
  GtkWidget *ent_umid;
  GtkWidget *ent_fingerprint;
  unsigned int trigger;
  char fingerprint[ 128 ];
  char umid[ 32 ];
  unsigned int action;
  char protocol[ 32 ];
  guint source_id;
};

struct DATABASE_ENTRY {
  char umid[ 32 ];
  char fingerprint[ 128 ];
};

static struct StockPixmap {
  const char *name;
  char **xpm_data;
} const item_names[] = {
  { "BC_Encrypted", bc_greenlock_xpm },
  { "BC_Plaintext", bc_redlock_xpm },
  { "BC_Transition_1", bc_yellowlock_xpm },
  { "BC_Transition_2", bc_yellowlock_xpm },
};



extern int generate_key(char *directory_entry_text,
			char *id_combo_entry_text,
			char *fingerprint_buffer,
			unsigned int fingerprint_buffer_len);

extern int is_encryption_initialized(void);

extern int load_database_and_keys(char *directory_path, char *id);

extern void show_torui(void);



void accept_button_clicked(GtkWidget *widget, gpointer data);

void add_button_clicked(GtkWidget *widget, gpointer data);

void bc_dialog(gchar *message, GtkMessageType type, GtkWidget *parent_window);

void bc_disable_encryption_state(GaimConversation *c);

void bc_enable_encryption_state(GaimConversation *c);

int bc_is_encrypted_state_locked(GaimConversation *c);

unsigned int bc_is_state_encrypted(GaimConversation *c);

void bc_lock_encryption_state(GaimConversation *c);

void bc_register_icons(void);

void bc_system_message(char *who, char *what);

void bc_system_message_with_conv(GaimConversation *c, char *what);

void btnNewEntryCancel_clicked(GtkWidget *widget, gpointer data);

void btnNewEntryOK_clicked(GtkWidget *widget, gpointer data);

void check_newer_cb(void *d, const char *data, size_t len);

void check_newer_clicked(GtkWidget *widget, gpointer data);

void clear_key_database_from_ui(void);

void combo_entry_changed(GtkWidget *widget, gpointer data);

GtkWidget *create_fingerprint_window(struct NEW_FP_STRUCT *new_fp_struct);

GtkWidget *create_key_pw_win(void);

GtkWidget *create_new_entry_window(struct DATABASE_ENTRY *stuff);

GtkWidget *create_um_init_window(void);

GtkWidget *create_um_keygen_win(void);

void default_checkbox_clicked(GtkWidget *widget, gpointer data);

void del_conversation(GaimConversation *conv, void *data);

void delete_button_clicked(GtkWidget *widget, gpointer data);

void delete_id_button_clicked(GtkWidget *widget, gpointer data);

void directory_dialog_cancel(GtkWidget *widget, GtkObject *directory_dialog);

void directory_dialog_ok(GtkWidget *widget, GtkObject *directory_dialog);

void disable_encryption_cb(GtkWidget *callback,
			   GaimConversation* conv);

void disable_transition1_cb(GtkWidget *callback,
			    GaimConversation *conv);

void edit_button_clicked(GtkWidget *widget, gpointer data);

void enable_debug_clicked(GtkWidget *widget, gpointer data);

void enable_encryption_cb(GtkWidget *callback,
			  GaimConversation *conv);

void enable_transition1_cb(GtkWidget *callback,
			    GaimConversation *conv);

void export_buddy_key_clicked(GtkWidget *widget, gpointer data);

void fake_generate_button_clicked(GtkWidget *widget, gpointer data);

void fingerprint_entry_changed(GtkWidget *widget, gpointer data);

gpointer generate_key_thread(gpointer nothing);

void get_id_pw(char *pwbuf, size_t pwbuf_len);

void id_pw_win_closed(GtkWidget *widget, GdkEvent *event, void *nothing);

void im_text_buffer_changed(GtkWidget *widget, gpointer data);

void import_buddy_key_clicked(GtkWidget *widget, gpointer data);

void import_dialog_cancel_button_clicked(GtkWidget *widget, gpointer data);

void import_dialog_ok_button_clicked(GtkWidget *widget, gpointer data);

void keydb_button_clicked(GtkWidget *widget, gpointer data);

gpointer keyfp_thread(gpointer fp_struct);

void keygen_win_closed(GtkWidget *widget, GdkEvent *event, void *nothing);

void load_key_database_into_ui(void);

int load_save_dir_selected(char *path);

void log_dialog_ok_button_clicked(GtkWidget *widget, gpointer data);

void menu_item_permanently_selected(GtkWidget *widget, gpointer data);

void menu_item_temporarily_selected(GtkWidget *widget, gpointer data);

void new_conversation(GaimConversation *conv, void *data);

void ok_button_clicked(GtkWidget *widget, gpointer data);

gpointer progress_bar_thread(gpointer nothing);

void real_generate_button_clicked(GtkWidget *widget, gpointer data);

void reject_button_clicked(GtkWidget *widget, gpointer data);

void reset_crypto_init_ui(void);

void select_button_clicked(GtkWidget *widget, gpointer data);

void show_fingerprint_window(struct NEW_FP_STRUCT *new_fp_struct);

void show_um_keygen_win(void);

void show_um_init_window(unsigned int grab_mutex);

gboolean timeout_func(gpointer data);

void tor_menu_clicked(GtkWidget *widget, gpointer data);

gpointer ui_state_thread(gpointer fp_struct);

void um_dialog(gchar *message, gchar *title, GtkWidget *parent_window);

void um_enc_help_button_clicked(GtkWidget *widget, gpointer data);

void um_fp_help_button_clicked(GtkWidget *widget, gpointer data);

void um_init_window_destroyed(GtkWidget *widget, gpointer data);

void what_is_buddy_id_db_clicked(GtkWidget *widget, gpointer data);

void what_is_id_clicked(GtkWidget *widget, gpointer data);

void what_is_load_save_clicked(GtkWidget *widget, gpointer data);

void window_destroy(GtkWidget *widget, gpointer data);



#endif
