/**
 * auto.c
 *
 * Copyright (C) 2005, J. Salvatore Testa II
 *
 * This software, including this piece of code, is distributed according
 * to the Hacktivismo Software License, as stated in LICENSE.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
  #include "config.h"
#endif

#include "auto.h"
#ifdef DMALLOC
  #include "dmalloc.h"
#endif


struct AUTO_ENCRYPT *ae_head = NULL;

int auto_feedback(char *name, char *cp) {
  struct AUTO_ENCRYPT *previous = NULL;
  struct AUTO_ENCRYPT *tmp = NULL;
  struct AUTO_ENCRYPT *current = ae_head;
  unsigned int found = 0;

  unsigned char hash[ 32 ];

  memset(hash, 0, sizeof(hash));

  /*printf("auto_feedback(%s, %s) called.\n", name, cp);*/

  gcry_md_hash_buffer(GCRY_MD_SHA1, hash, name, strlen(name));
  /*hex_dump("searching hash", hash, 20);*/

  if ((ae_head == NULL) && (strcmp(cp, "C") == 0)) {
    ae_head = (struct AUTO_ENCRYPT *)calloc(1, sizeof(struct AUTO_ENCRYPT));
    memcpy(ae_head->hash, hash, 20);
    ae_head->n = 1;
    ae_head->flag = 0;
    ae_head->next = NULL;
    /*printf("Made new HEAD!\n");*/
    return 1;
  } else if ((ae_head == NULL) && (strcmp(cp, "P") == 0)) {
    /*printf("head is null, and P encountered.\n");*/
    return 1;
  }



  while((current != NULL) && (found == 0)) {
    /*hex_dump("examining hash", current->hash, 20);*/
    if (memcmp(current->hash, hash, 20) == 0)
      found = 1;
    else {
      previous = current;
      current = current->next;
    }
  }

  if (found == 1) {
    /*printf("FOUND!\n");*/

    if ((strcmp(cp, "C") == 0) && (current->flag == 0)) {

      if (current->n < 2)
	current->n++;
      else {
	current->n = 0;
	current->flag = 1;
      }

    } else if ((strcmp(cp, "C") == 0) && (current->flag == 1)) {

      if (current->n > 0)
	current->n--;

    } else if ((strcmp(cp, "P") == 0) && (current->flag == 0)) {

      if (current->n > 1)
	current->n--;
      else
	auto_kill_link(previous, current);

    } else if ((strcmp(cp, "P") == 0) && (current->flag == 1)) {

      if (current->n < 3)
	current->n++;
      else
	auto_kill_link(previous, current);

    }

    /*if (current != NULL)
      printf("n: %u\nflag: %u\n", current->n, current->flag);
    else
    printf("KILLED!\n");*/
  } else if (strcmp(cp, "C") == 0) {
    tmp = (struct AUTO_ENCRYPT *)calloc(1, sizeof(struct AUTO_ENCRYPT));
    memcpy(tmp->hash, hash, 20);
    tmp->n = 1;
    tmp->flag = 0;
    tmp->next = NULL;

    previous->next = tmp;
    /*printf("Made new element!\n");*/
  } /*else
      printf("Did not make a new element.\n");*/

  return 1;
}


int auto_query(char *name) {
  struct AUTO_ENCRYPT *current = ae_head;
  unsigned int found = 0;

  char hash[ 32 ];

  memset(hash, 0, sizeof(hash));


  /*printf("auto_query [%s]\n", name);*/

  if (ae_head == NULL) {
    /*printf("AE_HEAD IS NULL!\n");*/
    return 0;
  }

  gcry_md_hash_buffer(GCRY_MD_SHA1, hash, name, strlen(name));
  /*hex_dump("query hash", hash, 20);*/

  while((current != NULL) && (found == 0)) {
    if (memcmp(current->hash, hash, 20) == 0)
      found = 1;
    else
      current = current->next;
  }

  /*if (current != NULL)
    printf("\tflag: %u\n\tn: %u\n", current->flag, current->n);
  else
  printf("\tquery hash not found.\n");*/

  if ((found == 1) && (current->flag == 1))
    return 1;
  else
    return 0;
}


int auto_load(char *path) {
  int ret = 0;
  unsigned int i = 0;
  struct AUTO_ENCRYPT *ae_previous = NULL;
  struct AUTO_ENCRYPT *ae_current = NULL;
#ifdef _WIN32
  HANDLE hFile = NULL;
  DWORD read_len = 0;
#else
  FILE *hFile = NULL;
  size_t read_len = 0;
#endif
  u_int32_t num_records = 0;
  u_int32_t n = 0;
  u_int32_t flag = 0;

  char file_path[ 256 ];
  char hash[ 32 ];

  memset(file_path, 0, sizeof(file_path));
  memset(hash, 0, sizeof(hash));

  /*printf("auto_load called.\n");*/


  bc_strlcpy(file_path, path, sizeof(file_path) - 8);
  bc_strlcat(file_path, "buddies", sizeof(file_path) - 8);

  ret = is_regular_file(file_path);
  if (ret == -1)
    goto auto_load_error;
  else if (ret == 0) {
    /*printf("[%s] does not exist, creating...\n", file_path);*/

    /*#ifdef _WIN32
    hFile = CreateFile(file_path, GENERIC_WRITE, FILE_SHARE_WRITE, NULL,
                       CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
    CloseHandle(hFile);  hFile = NULL;
    #else*/
    hFile = fopen(file_path, "w+");
    if (hFile != NULL) { fclose(hFile);  hFile = NULL; }
    /*#endif*/
    return 0;
  }

#ifdef _WIN32
  hFile = CreateFile(file_path, GENERIC_READ, FILE_SHARE_READ, NULL,
                     OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if (hFile == INVALID_HANDLE_VALUE) {
    /*printf("XXXX\n");*/
    bc_log("auto_load", BC_LOG_ERROR, "Error opening %s.", path);
    goto auto_load_error;
  }

  if (!ReadFile(hFile, &num_records, sizeof(u_int32_t), &read_len, NULL)) {
    /*printf("YYYY\n");*/
    goto auto_load_error;
  }

#else
  if (!(hFile = fopen(file_path, "r"))) {
    bc_log("auto_load", BC_LOG_ERROR, "fopen failed.");
    /*printf("fopen failed.\n");*/
    goto auto_load_error;
  }

  read_len = fread(&num_records, sizeof(u_int32_t), 1, hFile);
  if (read_len != 1)
    goto auto_load_error;

#endif


  /*printf("num_records: %u\n", num_records);*/

  for (i = 0; i < num_records; i++) {

#ifdef _WIN32
    if (!ReadFile(hFile, hash, 20, &read_len, NULL)) {
      /*printf("X1: %u\n", read_len);*/
      goto auto_load_error;
    }

    if (!ReadFile(hFile, &n, sizeof(u_int32_t), &read_len, NULL)) {
      /*printf("X2: %u\n", read_len);*/
      goto auto_load_error;
    }

    if (!ReadFile(hFile, &flag, sizeof(u_int32_t), &read_len, NULL)) {
      /*printf("X3: %u\n", read_len);*/
      goto auto_load_error;
    }

#else
    read_len = fread(hash, sizeof(unsigned char),
		     MY_MIN(20, sizeof(hash) - 8), hFile);
    if (read_len != 20)
      goto auto_load_error;

    read_len = fread(&n, sizeof(u_int32_t), 1, hFile);
    if (read_len != 1)
      goto auto_load_error;

    read_len = fread(&flag, sizeof(u_int32_t), 1, hFile);
    if (read_len != 1)
      goto auto_load_error;
#endif

    ae_current = (struct AUTO_ENCRYPT *)calloc(1, sizeof(struct AUTO_ENCRYPT));
    if (ae_current == NULL)
      goto auto_load_error;

    memcpy(ae_current->hash, hash, 20);
    ae_current->n = n;
    ae_current->flag = flag;
    ae_current->next = NULL;

    /*hex_dump("hash", hash, 20);
      printf("n: %u\nflag: %u\n", n, flag);*/

    if (ae_previous == NULL) {
      /*printf("set head.\n");*/
      ae_head = ae_current;
    } else {
      /*printf("set link.\n");*/
      ae_previous->next = ae_current;
    }
    ae_previous = ae_current;

  }

#ifdef _WIN32
  CloseHandle(hFile);  hFile = NULL;
#else
  fclose(hFile);  hFile = NULL;
#endif
  return 1;

 auto_load_error:
  if (hFile != NULL) {
#ifdef _WIN32
  CloseHandle(hFile);  hFile = NULL;
#else
    fclose(hFile);  hFile = NULL;
#endif
  }
  return -1;
}


int auto_save(char *path) {
  int ret = 0;
  FILE *hFile = NULL;
  /*u_int32_t num_records = 0;*/
  unsigned int i = 0;
  /*size_t read_len = 0;*/
  /*  struct AUTO_ENCRYPT *ae_previous = NULL;*/
  struct AUTO_ENCRYPT *ae_current = NULL;
  u_int32_t n = 0;

  char file_path[ 256 ];
  unsigned char hash[ 32 ];

  memset(file_path, 0, sizeof(file_path));
  memset(hash, 0, sizeof(hash));


  /*printf("auto_save called.\n");*/

  bc_strlcpy(file_path, path, sizeof(file_path) - 8);
  bc_strlcat(file_path, "buddies", sizeof(file_path) - 8);

  ret = is_regular_file(file_path);
  /*printf("is_regular_file(%s) = %d\n", file_path, ret);*/

  if (ret == -1)
    goto auto_save_error;
  else if (ret == 0)
    return 0;

  /*printf("file_path: [%s]\n", file_path);*/
  hFile = fopen(file_path, "w");
  if (hFile == NULL) {
    bc_log("auto_save", BC_LOG_ERROR, "fopen failed.");
    /*printf("fopen failed!\n");*/
    goto auto_save_error;
  }

  ae_current = ae_head;
  while(ae_current != NULL) {
    ae_current = ae_current->next;
    n++;
  }

  /*printf("list is of size %u\n", n);*/

  fwrite(&n, sizeof(u_int32_t), 1, hFile);

  ae_current = ae_head;
  for (i = 0; i < n; i++, ae_current = ae_current->next) {
    fwrite(ae_current->hash, sizeof(unsigned char), 20, hFile);
    /*hex_dump("hash", ae_current->hash, 20);*/
    fwrite(&(ae_current->n), sizeof(u_int32_t), 1, hFile);
    fwrite(&(ae_current->flag), sizeof(u_int32_t), 1, hFile);
    /*printf("wrote hash with n of %u, flag of %u\n", ae_current->n, ae_current->flag);*/
  }

  fclose(hFile);  hFile = NULL;
  return 1;

 auto_save_error:
  return -1;
}


void auto_kill_link(struct AUTO_ENCRYPT *previous,
		    struct AUTO_ENCRYPT *current) {

  if (current == NULL) {
    /*printf("ERROR: CAN'T KILL NULL LINK!\n");*/
    return;
  }

  if (previous != NULL)
    previous->next = current->next;
  else
    ae_head = ae_head->next;

  memset(current, 0, sizeof(struct AUTO_ENCRYPT));
  free(current);  current = NULL;

  return;
}

void auto_clear(void) {
  struct AUTO_ENCRYPT *ae_current = NULL;
  struct AUTO_ENCRYPT *ae_next = NULL;

  ae_current = ae_head;
  while(ae_current != NULL) {
    ae_next = ae_current->next;
    free(ae_current);  ae_current = NULL;
    ae_current = ae_next;
  }
  ae_head = NULL;
}
