/**
 * auto.h
 *
 * Copyright (C) 2005, J. Salvatore Testa II
 *
 * This software, including this piece of code, is distributed according
 * to the Hacktivismo Software License, as stated in LICENSE.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _AUTO_H
#define _AUTO_H

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <gcrypt.h>

#include "module.h"
#include "utils.h"

#ifdef _WIN32
typedef unsigned int u_int32_t;
#endif

struct AUTO_ENCRYPT {
  unsigned char hash[ 24 ];
#ifdef _WIN32
  unsigned int n;
  unsigned int flag;
#else
  u_int32_t n;
  u_int32_t flag;
#endif
  struct AUTO_ENCRYPT *next;
};

int auto_feedback(char *name, char *cp);
int auto_load(char *path);
int auto_query(char *name);
int auto_save(char *path);
void auto_kill_link(struct AUTO_ENCRYPT *previous,
		    struct AUTO_ENCRYPT *current);
void auto_clear(void);

#endif
