/**
 * console.h
 *
 * Copyright (C) 2004-2005, J. Salvatore Testa II
 *
 * This software, including this piece of code, is distributed according
 * to the Hacktivismo Software License, as stated in LICENSE.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef CONSOLE_H
#define CONSOLE_H

#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <gcrypt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#include "utils.h"
#include "key_database.h"
#include "module.h"
#include "auto.h"


void change_state(struct UM_BUDDY *buddy, unsigned int operation, unsigned int new_state);
void handle_commands(void);
void module_addkey(char *line);
void module_autofeedback(char *line);
void module_autoquery(char *line);
void module_b64_padding(char *line);
void module_decryptfile(char *line);
void module_delid(char *line);
void module_delkey(char *line);
void module_dirinit(char *line);
void module_encryptfile(char *line);
void module_generatekey(char *line);
void module_init(void);
void module_lookupname(char *line);
void module_keyacceptpermanently(char *line);
void module_keyaccepttemporary(char *line);
void module_keyreject(char *line);
void module_processmessage(char *line);
void module_reset(void);
void module_selectuser(char *user);
void module_sendmessage(char *line);
void module_shutdown(void);
void module_status(char *line);
void module_wipe(char *line);
void process_args(int ac, char **av);
void readcrlf(void);

#endif /* CONSOLE_H */
