/**
 * client_normal.c
 *
 * Copyright (C) 2004-2005, Joe Testa
 *
 * This software, including this piece of code, is distributed according
 * to the Hacktivismo Software License, as stated in LICENSE.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
  #include "config.h"
#endif

#include <stdio.h>

#ifdef _WIN32
   #include <windows.h>
   #include <winsock.h>
   /* -lws2_32 */
#else
   #include <sys/socket.h>
   #include <netinet/in.h>
   #include <netdb.h>
#endif

#include "shared_normal.h"
#include "../src/debug.h"

void connect_to_serverpeer(char *server_ip);

struct sockaddr_in my_addr;
struct sockaddr_in client_addr;

int socket_fd = 0;


int main(int ac, char **av) {
  char buffer[ 256 ];
#ifdef _WIN32
  WSADATA wsaData;
#endif

  memset(buffer, 0, sizeof(buffer));

#ifdef _WIN32
  if (WSAStartup(MAKEWORD(2,0), &wsaData) != 0) {
    printf("WSAStartup failed!\n");
    return 1;
  }
#endif

  printf("Enter the IP of the serverpeer [127.0.0.1]: ");
  fflush(stdout);
  console_read_line(buffer, sizeof(buffer));

  connect_to_serverpeer((buffer[ 0 ] == '\0') ? "127.0.0.1" : buffer);

  handle_chat(socket_fd);
  return 0;
}


void connect_to_serverpeer(char *server_ip) {

  struct hostent *server_hostent = NULL;
  struct in_addr server_addr;

  memset(&server_addr, 0, sizeof(struct in_addr));
  memset(&my_addr, 0, sizeof(struct sockaddr_in));
  memset(&client_addr, 0, sizeof(struct sockaddr_in));

  printf("Connecting to [%s:%u]\n", server_ip, PORT);
  fflush(stdout);

  socket_fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);


  server_hostent = gethostbyname(server_ip);
  memcpy(&server_addr, *(server_hostent->h_addr_list), sizeof(struct in_addr));

  my_addr.sin_family = AF_INET;
  my_addr.sin_addr = server_addr;
  my_addr.sin_port = htons(PORT);

  if (connect(socket_fd, (struct sockaddr *)&my_addr,
	      sizeof(my_addr)) < 0) {
    printf("Could not connect to %s:%u.\n", server_ip, PORT);
    exit(1);
  }

  printf("Connected!\n");
  fflush(stdout);
}
