/**
 * server_crypto.c
 *
 * Copyright (C) 2004-2005, Joe Testa
 *
 * This software, including this piece of code, is distributed according
 * to the Hacktivismo Software License, as stated in LICENSE.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
  #include "config.h"
#endif


#ifdef _WIN32
   #include <windows.h>
   #include <winsock2.h>
#else
   #include <arpa/inet.h>
   #include <netinet/in.h>
   #include <sys/socket.h>
#endif

#include <stdio.h>

#include "shared_crypto.h"
/*#include "../src/debug.h"*/

void handle_client(void);
void start_socket(long listen_address);

struct sockaddr_in my_addr;
struct sockaddr_in client_addr;

int socket_fd = 0;
int client_fd = 0;


int main(int ac, char **av) {
#ifndef _WIN32
  unsigned int sin_size = sizeof(struct sockaddr_in);
  int x = 1;
#endif
  char client_ip[ 16 ];
  long listen_address = 0;
  int ret = 0;

  memset(client_ip, 0, sizeof(client_ip));
  memset(&my_addr, 0, sizeof(struct sockaddr_in));
  memset(&client_addr, 0, sizeof(struct sockaddr_in));

  srand(777);

  if ((ac == 2) && (strcmp(av[ 1 ], "any") == 0))
    listen_address = INADDR_ANY;
  else if (ac > 1) {
    printf("Usage:    %s [any]\n", av[ 0 ]);
    printf("Examples: %s       /* Makes server listen on 127.0.0.1:31337 */\n",
	   av[ 0 ]);
    printf("          %s any   /* Makes server listen on 0.0.0.0:31337 */\n",
	   av[ 0 ]);
    exit(1);
  } else
    listen_address = INADDR_LOOPBACK;


  run_module();
  init_module();

#ifdef _WIN32
  WSADATA wsaData;
  struct sockaddr_in s_in;
  SOCKET client;
  int len = sizeof(s_in);

  if (WSAStartup(MAKEWORD(2,0), &wsaData) != 0) {
    printf("WSAStartup failed!\n");
    return 1;
  }

  socket_fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  if (socket_fd == INVALID_SOCKET) {
    printf("socket(): %d\n", WSAGetLastError());
    WSACleanup();
    return 1;
  }

  s_in.sin_family = AF_INET;

  if (listen_address == INADDR_LOOPBACK) {
    s_in.sin_addr.s_addr = inet_addr("127.0.0.1");
    printf("Listening on 127.0.0.1:%u...\n", PORT);
    fflush(stdout);
  } else {
    s_in.sin_addr.s_addr = inet_addr("0.0.0.0");
    printf("Listening on 0.0.0.0:%u...\n", PORT);
    fflush(stdout);
  }
  s_in.sin_port = htons(PORT);

  if (bind(socket_fd, (SOCKADDR *)&s_in, sizeof(s_in)) == SOCKET_ERROR) {
    printf("bind() failed!\n");
    closesocket(socket_fd);
    return 1;
  }


  if (listen(socket_fd, 1) == SOCKET_ERROR) {
    printf("listen() failed!\n");
    return 1;
  }

  ret = 1;
  while(ret > 0) {
    client = accept(socket_fd, (struct sockaddr *)&s_in, &len);
    /*    printf("Got connection from %s\n",
	   inet_ntop(AF_INET, &(client_addr.sin_addr.s_addr),
	   client_ip, sizeof(client_ip) - 1));*/
    printf("Got a connection\n");
    fflush(stdout);

    ret = handle_chat(client);
    closesocket(client);
  }
#else

  printf("\nNow listening for incoming connection on ");
  if (listen_address == INADDR_LOOPBACK)
    printf("127.0.0.1");
  else
    printf("0.0.0.0");

  printf(":%u...\n", PORT);


  socket_fd = socket(AF_INET, SOCK_STREAM, 0);
  setsockopt(socket_fd, SOL_SOCKET, SO_REUSEADDR, &x, sizeof(x));

  my_addr.sin_family = AF_INET;
  my_addr.sin_addr.s_addr = htonl(listen_address); /*htonl(INADDR_ANY);*/
  my_addr.sin_port = htons(PORT);

  bind(socket_fd, (struct sockaddr *)&my_addr, sizeof(struct sockaddr));
  listen(socket_fd, 1);

  ret = 1;
  while(ret > 0) {
    client_fd = accept(socket_fd, (struct sockaddr *)&client_addr, &sin_size);

    printf("Got connection from %s\n",
	   inet_ntop(AF_INET, &(client_addr.sin_addr.s_addr),
		     client_ip, sizeof(client_ip) - 1));
    ret = handle_chat(client_fd);
    reset_module();
    close(client_fd);
    printf("Peer disconnected.\n");
  }

  shutdown_module();
  return 0;
#endif
}
